/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.CompiledFunction;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import java.util.Hashtable;

public class MathMLInterpreter
implements Interpreter {
    private static final Hashtable constants = new Hashtable();
    private static final Hashtable unaryOperators = new Hashtable();
    private static final Hashtable binaryOperators = new Hashtable();
    private static final Hashtable commonFunctions = new Hashtable();

    public Object getLiteralValue(Object object) {
        if (object instanceof Number) {
            String string;
            if (object instanceof Integer || object instanceof Long) {
                return "<cn type=\"integer\">" + object + "</cn>\n";
            }
            if (object instanceof Float) {
                if (((Float)object).isInfinite()) {
                    return "<infinity/>\n";
                }
                if (((Float)object).isNaN()) {
                    return "<notanumber/>\n";
                }
            } else if (object instanceof Double) {
                if (((Double)object).isInfinite()) {
                    return "<infinity/>\n";
                }
                if (((Double)object).isNaN()) {
                    return "<notanumber/>\n";
                }
            }
            if ((string = object.toString()).indexOf(69) >= 0) {
                return "<cn type=\"e-notation\">" + string + "</cn>\n";
            }
            return "<cn>" + string + "</cn>\n";
        }
        throw new IllegalArgumentException("Literal " + object + " not an instance of Number, String or Character");
    }

    public Object getParameterValue(Object object) {
        if (object instanceof Number) {
            return this.getLiteralValue(object);
        }
        if (object instanceof String || object instanceof Character) {
            if (((String)object).indexOf(60) >= 0) {
                return object;
            }
            return "<ci>" + object + "</ci>\n";
        }
        throw new IllegalArgumentException("Parameter " + object + " not an instance of Number, String or Character");
    }

    public Object getConstantValue(Object object) {
        String string = (String)constants.get(object);
        if (string != null) {
            return String.valueOf(string) + "\n";
        }
        throw new IllegalArgumentException("Constant key " + object + " not implemented");
    }

    public Object getUnaryOperatorValue(Object object, Object object2) {
        if (Syntax.OPERATOR_POSITIVE.equals(object)) {
            return object2;
        }
        String string = (String)unaryOperators.get(object);
        if (string != null) {
            return "<apply>\n" + string + "\n" + object2 + "</apply>\n";
        }
        throw new IllegalArgumentException("Unary operator key " + object + " not implemented");
    }

    public Object getBinaryOperatorValue(Object object, Object object2, Object object3) {
        String string = (String)binaryOperators.get(object);
        if (string != null) {
            return "<apply>\n" + string + "\n" + object2 + object3 + "</apply>\n";
        }
        throw new IllegalArgumentException("Binary operator key " + object + " not implemented");
    }

    public Object getCommonFunctionValue(Object object, Object object2) {
        if (Syntax.FUNCTION_SQR.equals(object)) {
            return this.getBinaryOperatorValue(Syntax.OPERATOR_POWER, object2, new Integer(2));
        }
        String string = (String)commonFunctions.get(object);
        if (string != null) {
            return "<apply>\n" + string + "\n" + object2 + "</apply>\n";
        }
        throw new IllegalArgumentException("Unary operator key " + object + " not implemented");
    }

    public Object getConditionValue(Object object, Object object2, Object object3) {
        return "<piecewise>\n<piece>\n" + object2 + object + "</piece>\n<otherwise>\n" + object3 + "</otherwise>\n<piecewise>\n";
    }

    public boolean isTrue(Object object) {
        throw new IllegalArgumentException("Can't evaluate condition");
    }

    public boolean supportsRecursiveCall() {
        return false;
    }

    public Object getFunctionValue(Function function, Object[] objectArray, boolean bl) {
        if (function instanceof CompiledFunction) {
            if (!bl) {
                return function.computeFunction(this, objectArray);
            }
            throw new IllegalArgumentException("Can't evaluate recursive function " + function.getName());
        }
        try {
            return function.computeFunction(this, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Can't evaluate function " + function.getName());
        }
    }

    static {
        constants.put(Syntax.CONSTANT_PI, "<pi/>");
        constants.put(Syntax.CONSTANT_E, "<exponentiale/>");
        constants.put(Syntax.CONSTANT_TRUE, "<true/>");
        constants.put(Syntax.CONSTANT_FALSE, "<false/>");
        unaryOperators.put(Syntax.OPERATOR_OPPOSITE, "<minus/>");
        unaryOperators.put(Syntax.OPERATOR_LOGICAL_NOT, "<not/>");
        binaryOperators.put(Syntax.OPERATOR_LOGICAL_OR, "<or/>");
        binaryOperators.put(Syntax.OPERATOR_LOGICAL_XOR, "<xor/>");
        binaryOperators.put(Syntax.OPERATOR_LOGICAL_AND, "<and/>");
        binaryOperators.put(Syntax.OPERATOR_EQUAL, "<eq/>");
        binaryOperators.put(Syntax.OPERATOR_DIFFERENT, "<neq/>");
        binaryOperators.put(Syntax.OPERATOR_GREATER_OR_EQUAL, "<geq/>");
        binaryOperators.put(Syntax.OPERATOR_LESS_OR_EQUAL, "<leq/>");
        binaryOperators.put(Syntax.OPERATOR_GREATER, "<gt/>");
        binaryOperators.put(Syntax.OPERATOR_LESS, "<lt/>");
        binaryOperators.put(Syntax.OPERATOR_ADD, "<plus/>");
        binaryOperators.put(Syntax.OPERATOR_SUBSTRACT, "<minus/>");
        binaryOperators.put(Syntax.OPERATOR_MODULO, "<rem/>");
        binaryOperators.put(Syntax.OPERATOR_REMAINDER, "<rem/>");
        binaryOperators.put(Syntax.OPERATOR_DIVIDE, "<divide/>");
        binaryOperators.put(Syntax.OPERATOR_MULTIPLY, "<times/>");
        binaryOperators.put(Syntax.OPERATOR_POWER, "<power/>");
        commonFunctions.put(Syntax.FUNCTION_LN, "<ln/>");
        commonFunctions.put(Syntax.FUNCTION_LOG, "<log/>");
        commonFunctions.put(Syntax.FUNCTION_EXP, "<exp/>");
        commonFunctions.put(Syntax.FUNCTION_SQRT, "<root/><degree><ci type=\"integer\">2</ci></degree>");
        commonFunctions.put(Syntax.FUNCTION_COS, "<cos/>");
        commonFunctions.put(Syntax.FUNCTION_SIN, "<sin/>");
        commonFunctions.put(Syntax.FUNCTION_TAN, "<tan/>");
        commonFunctions.put(Syntax.FUNCTION_ACOS, "<arccos/>");
        commonFunctions.put(Syntax.FUNCTION_ASIN, "<arcsin/>");
        commonFunctions.put(Syntax.FUNCTION_ATAN, "<arctan/>");
        commonFunctions.put(Syntax.FUNCTION_COSH, "<cosh/>");
        commonFunctions.put(Syntax.FUNCTION_SINH, "<sinh/>");
        commonFunctions.put(Syntax.FUNCTION_TANH, "<tanh/>");
        commonFunctions.put(Syntax.FUNCTION_FLOOR, "<floor/>");
        commonFunctions.put(Syntax.FUNCTION_CEIL, "<ceiling/>");
        commonFunctions.put(Syntax.FUNCTION_ROUND, "<ceiling/>");
        commonFunctions.put(Syntax.FUNCTION_ABS, "<abs/>");
        commonFunctions.put(Syntax.FUNCTION_OPPOSITE, "<minus/>");
        commonFunctions.put(Syntax.FUNCTION_NOT, "<not/>");
    }
}

