/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser.node;

import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import com.eteks.parser.node.ConstantNode;
import com.eteks.parser.node.ExpressionNode;
import com.eteks.parser.node.ParameterizedNode;

public class BinaryOperatorNode
extends ConstantNode
implements ParameterizedNode {
    private ExpressionNode firstOperand;
    private ExpressionNode secondOperand;

    public BinaryOperatorNode(Object object) {
        super(object);
    }

    public void addParameter(ExpressionNode expressionNode) {
        if (this.firstOperand == null) {
            this.firstOperand = expressionNode;
        } else {
            this.secondOperand = expressionNode;
        }
    }

    public int getParameterCount() {
        return this.firstOperand != null ? (this.secondOperand != null ? 2 : 1) : 0;
    }

    public ExpressionNode getFirstOperand() {
        return this.firstOperand;
    }

    public ExpressionNode getSecondOperand() {
        return this.secondOperand;
    }

    public Object computeExpression(Interpreter interpreter, Object[] objectArray) {
        Object object = this.firstOperand.computeExpression(interpreter, objectArray);
        Object object2 = this.secondOperand.computeExpression(interpreter, objectArray);
        return interpreter.getBinaryOperatorValue(this.getKey(), object, object2);
    }

    public double computeExpression(double[] dArray) {
        double d = this.firstOperand.computeExpression(dArray);
        double d2 = this.secondOperand.computeExpression(dArray);
        Object object = this.getKey();
        if (object.equals(Syntax.OPERATOR_ADD)) {
            return d + d2;
        }
        if (object.equals(Syntax.OPERATOR_SUBSTRACT)) {
            return d - d2;
        }
        if (object.equals(Syntax.OPERATOR_MULTIPLY)) {
            return d * d2;
        }
        if (object.equals(Syntax.OPERATOR_DIVIDE)) {
            return d / d2;
        }
        if (object.equals(Syntax.OPERATOR_POWER)) {
            return Math.pow(d, d2);
        }
        if (object.equals(Syntax.OPERATOR_MODULO)) {
            double d3 = d - d2 * (double)((int)(d / d2));
            if (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) {
                d3 += d2;
            }
            return d3;
        }
        if (object.equals(Syntax.OPERATOR_REMAINDER)) {
            return d % d2;
        }
        if (object.equals(Syntax.OPERATOR_EQUAL)) {
            return d == d2 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_DIFFERENT)) {
            return d != d2 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_GREATER_OR_EQUAL)) {
            return d >= d2 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_LESS_OR_EQUAL)) {
            return d <= d2 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_GREATER)) {
            return d > d2 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_LESS)) {
            return d < d2 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_OR)) {
            return d != 0.0 || d2 != 0.0 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_AND)) {
            return d != 0.0 && d2 != 0.0 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_XOR)) {
            return d != 0.0 && d2 == 0.0 || d == 0.0 && d2 != 0.0 ? 1.0 : 0.0;
        }
        if (Math.floor(d) != d) {
            throw new IllegalArgumentException("Operand " + d + " of bit operator not an integer");
        }
        if (Math.floor(d2) != d2) {
            throw new IllegalArgumentException("Operand " + d2 + " of bit operator not an integer");
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_OR)) {
            return (long)d | (long)d2;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_XOR)) {
            return (long)d ^ (long)d2;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_AND)) {
            return (long)d & (long)d2;
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_LEFT)) {
            return (long)d << (int)d2;
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_RIGHT)) {
            return (long)d >> (int)d2;
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_RIGHT_0)) {
            return (long)d >>> (int)d2;
        }
        throw new IllegalArgumentException("Binary operator key " + object + " not implemented");
    }
}

