/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeGraph;
import edu.uci.ics.jung.graph.impl.AbstractElement;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.PredicateUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSparseGraph
extends AbstractArchetypeGraph
implements Graph,
Cloneable {
    protected Set mVertices;
    protected Set mEdges;

    public AbstractSparseGraph() {
        this.initialize();
    }

    protected void initialize() {
        this.mVertices = new HashSet();
        this.mEdges = new HashSet();
        super.initialize();
    }

    public Set getVertices() {
        return Collections.unmodifiableSet(this.mVertices);
    }

    public Set getEdges() {
        return Collections.unmodifiableSet(this.mEdges);
    }

    public Edge addEdge(Edge e) {
        this.checkConstraints(e, this.edge_requirements);
        if (e instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)e);
            ae.checkIDs(this.mEdgeIDs);
            if (ae instanceof AbstractSparseEdge) {
                ((AbstractSparseEdge)ae).addGraph_internal(this);
            } else {
                ae.addGraph_internal(this);
            }
        }
        this.mEdges.add(e);
        this.mGraphListenerHandler.handleAdd(e);
        return e;
    }

    public Vertex addVertex(Vertex v) {
        this.checkConstraints(v, this.vertex_requirements);
        if (v instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)v);
            ae.checkIDs(this.mVertexIDs);
            ae.addGraph_internal(this);
        }
        this.mVertices.add(v);
        this.mGraphListenerHandler.handleAdd(v);
        return v;
    }

    public void removeVertex(Vertex v) {
        if (v.getGraph() != this) {
            throw new IllegalArgumentException("This vertex is not in this graph");
        }
        GraphUtils.removeEdges(this, v.getIncidentEdges());
        this.mVertices.remove(v);
        if (v instanceof AbstractSparseVertex) {
            AbstractSparseVertex asv = (AbstractSparseVertex)v;
            asv.removeGraph_internal();
            this.mVertexIDs.remove(new Integer(asv.getID()));
        }
        this.mGraphListenerHandler.handleRemove(v);
    }

    public void removeEdge(Edge e) {
        if (e.getGraph() != this) {
            throw new IllegalArgumentException("This edge is not in this graph");
        }
        Pair endpoints = e.getEndpoints();
        Vertex from = (Vertex)endpoints.getFirst();
        Vertex to = (Vertex)endpoints.getSecond();
        if (from instanceof AbstractSparseVertex) {
            ((AbstractSparseVertex)from).removeNeighbor_internal(e, to);
        }
        if (to instanceof AbstractSparseVertex) {
            ((AbstractSparseVertex)to).removeNeighbor_internal(e, from);
        }
        if (e instanceof AbstractSparseEdge) {
            AbstractSparseEdge ase = (AbstractSparseEdge)e;
            ase.removeGraph_internal();
            this.mEdgeIDs.remove(new Integer(ase.getID()));
        }
        this.mEdges.remove(e);
        this.mGraphListenerHandler.handleRemove(e);
    }

    public boolean isDirected() {
        return PredicateUtils.enforcesDirected(this);
    }

    public void removeVertices(Set vertices) {
        GraphUtils.removeVertices(this, vertices);
    }

    public void removeEdges(Set edges) {
        GraphUtils.removeEdges(this, edges);
    }
}

