/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.predicates.EdgePredicate;
import edu.uci.ics.jung.utils.Pair;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.OnePredicate;

public class KPartiteEdgePredicate
extends EdgePredicate {
    private Collection vertex_partitions;
    private Predicate mutex;
    private static String message = "KPartiteEdgePredicate";

    public KPartiteEdgePredicate(Collection vertex_partitions) {
        this.mutex = OnePredicate.getInstance((Collection)vertex_partitions);
        this.vertex_partitions = vertex_partitions;
    }

    public boolean evaluateEdge(ArchetypeEdge edge) {
        Edge e = (Edge)edge;
        Pair endpoints = e.getEndpoints();
        Vertex v1 = (Vertex)endpoints.getFirst();
        Vertex v2 = (Vertex)endpoints.getSecond();
        Predicate p1 = this.getSatisfyingPredicate(v1);
        Predicate p2 = this.getSatisfyingPredicate(v2);
        return this.mutex.evaluate((Object)v1) && this.mutex.evaluate((Object)v2) && p1 != null && p2 != null && p1 != p2;
    }

    public String toString() {
        return message;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KPartiteEdgePredicate)) {
            return false;
        }
        return ((Object)((KPartiteEdgePredicate)o).vertex_partitions).equals(this.vertex_partitions);
    }

    public int hashCode() {
        return ((Object)this.vertex_partitions).hashCode();
    }

    private Predicate getSatisfyingPredicate(Vertex v) {
        Iterator p_iter = this.vertex_partitions.iterator();
        while (p_iter.hasNext()) {
            Predicate p = (Predicate)p_iter.next();
            if (!p.evaluate((Object)v)) continue;
            return p;
        }
        return null;
    }
}

