/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.random.generators.Lattice2DGenerator;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.Arrays;

public class KleinbergSmallWorldGenerator
extends Lattice2DGenerator {
    private double mClusteringExponent;
    private int mLongRangeDistanceDistributionsSize = this.getLatticeSize() * 1000;
    private int[] mLongRangeDistanceDistributions;

    public KleinbergSmallWorldGenerator(int latticeSize, double clusteringExponent) {
        super(latticeSize, true);
        this.mClusteringExponent = clusteringExponent;
    }

    public ArchetypeGraph generateGraph() {
        Lattice2DGenerator generator = new Lattice2DGenerator(this.getLatticeSize(), true);
        Graph graph = (Graph)generator.generateGraph();
        Indexer id = Indexer.getIndexer(graph);
        this.computeLongDistanceEdgeDistributionSample();
        int numNodes = (int)Math.pow(this.getLatticeSize(), 2.0);
        for (int i = 0; i < numNodes; ++i) {
            Vertex source;
            int randomNodeIndex;
            Vertex target;
            int sampleNodeIndex = (int)(Math.random() * (double)this.mLongRangeDistanceDistributionsSize);
            int randomDistance = this.mLongRangeDistanceDistributions[sampleNodeIndex];
            do {
                randomNodeIndex = this.simulatePath(i, randomDistance);
                source = (Vertex)id.getVertex(i);
            } while ((target = (Vertex)id.getVertex(randomNodeIndex)).isSuccessorOf(source));
            GraphUtils.addEdge(graph, source, target);
        }
        return graph;
    }

    private static int pickValue(boolean[] choices) {
        int i;
        int totalNumChoicesLeft = 0;
        for (int x = 0; x < choices.length; ++x) {
            if (!choices[x]) continue;
            ++totalNumChoicesLeft;
        }
        double randValue = Math.random();
        for (i = 1; i <= totalNumChoicesLeft && !(randValue < (double)i / (double)totalNumChoicesLeft); ++i) {
        }
        int currentChoice = 1;
        int j = 0;
        while (i < choices.length) {
            if (choices[j]) {
                if (currentChoice == i) {
                    return j + 1;
                }
                ++currentChoice;
            }
            ++j;
        }
        return currentChoice;
    }

    private int simulatePath(int index, int distance) {
        boolean[] currentChoices = new boolean[4];
        Arrays.fill(currentChoices, true);
        int currentChoice = 0;
        int newIndex = 0;
        int xCoordinate = index / this.getLatticeSize();
        int yCoordinate = index % this.getLatticeSize();
        for (int numSteps = 0; numSteps < distance; ++numSteps) {
            currentChoice = KleinbergSmallWorldGenerator.pickValue(currentChoices);
            switch (currentChoice) {
                case 1: {
                    currentChoices[1] = false;
                    newIndex = this.upIndex(xCoordinate, yCoordinate);
                    break;
                }
                case 2: {
                    currentChoices[0] = false;
                    newIndex = this.downIndex(xCoordinate, yCoordinate);
                    break;
                }
                case 3: {
                    currentChoices[3] = false;
                    newIndex = this.leftIndex(xCoordinate, yCoordinate);
                    break;
                }
                case 4: {
                    currentChoices[2] = false;
                    newIndex = this.rightIndex(xCoordinate, yCoordinate);
                }
            }
            xCoordinate = newIndex / this.getLatticeSize();
            yCoordinate = newIndex % this.getLatticeSize();
        }
        return newIndex;
    }

    public double getClusteringExponent() {
        return this.mClusteringExponent;
    }

    public void setClusteringExponent(double clusteringExponent) {
        this.mClusteringExponent = clusteringExponent;
    }

    private void computeLongDistanceEdgeDistributionSample() {
        int i;
        int numLongRangeLevels = this.getLatticeSize() - 2;
        if (this.getLatticeSize() % 2 == 0) {
            numLongRangeLevels = this.getLatticeSize() - 1;
        }
        double[] probDists = new double[numLongRangeLevels];
        double normalizingFactor = 0.0;
        int currentDistance = 2;
        for (i = 0; i < numLongRangeLevels; ++i) {
            probDists[i] = Math.pow(currentDistance, -1.0 * this.mClusteringExponent);
            normalizingFactor += probDists[i];
            ++currentDistance;
        }
        i = 0;
        while (i < numLongRangeLevels) {
            int n = i++;
            probDists[n] = probDists[n] / normalizingFactor;
        }
        this.mLongRangeDistanceDistributions = new int[this.mLongRangeDistanceDistributionsSize];
        block2: for (i = 0; i < this.mLongRangeDistanceDistributionsSize; ++i) {
            currentDistance = 2;
            double currentCumProb = 0.0;
            double randomVal = Math.random();
            for (int j = 0; j < numLongRangeLevels; ++j) {
                if (randomVal < (currentCumProb += probDists[j])) {
                    this.mLongRangeDistanceDistributions[i] = currentDistance;
                    continue block2;
                }
                ++currentDistance;
            }
        }
    }
}

