/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantDirectionalEdgeValue;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeFontFunction;
import edu.uci.ics.jung.graph.decorators.ConstantEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStringer;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexFontFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexSizeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexStringer;
import edu.uci.ics.jung.graph.decorators.ConstantVertexStrokeFunction;
import edu.uci.ics.jung.graph.decorators.DirectionalEdgeArrowFunction;
import edu.uci.ics.jung.graph.decorators.EdgeArrowFunction;
import edu.uci.ics.jung.graph.decorators.EdgeColorFunction;
import edu.uci.ics.jung.graph.decorators.EdgeFontFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.PickableVertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexColorFunction;
import edu.uci.ics.jung.graph.decorators.VertexFontFunction;
import edu.uci.ics.jung.graph.decorators.VertexIconFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.decorators.VertexStrokeFunction;
import edu.uci.ics.jung.graph.predicates.EdgePredicate;
import edu.uci.ics.jung.graph.predicates.SelfLoopEdgePredicate;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.ParallelEdgeIndexFunction;
import edu.uci.ics.jung.utils.ParallelEdgeIndexSingleton;
import edu.uci.ics.jung.visualization.AbstractRenderer;
import edu.uci.ics.jung.visualization.DefaultGraphLabelRenderer;
import edu.uci.ics.jung.visualization.EdgeColorToEdgePaintFunctionConverter;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import edu.uci.ics.jung.visualization.HasShapeFunctions;
import edu.uci.ics.jung.visualization.PickedInfo;
import edu.uci.ics.jung.visualization.VertexColorToVertexPaintConverter;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;

public class PluggableRenderer
extends AbstractRenderer
implements PickedInfo,
HasShapeFunctions {
    protected float arrow_placement_tolerance = 1.0f;
    protected static final float[] dotting = new float[]{1.0f, 3.0f};
    public static final Stroke DOTTED = new BasicStroke(1.0f, 1, 1, 1.0f, dotting, 0.0f);
    protected static final float[] dashing = new float[]{5.0f};
    public static final Stroke DASHED = new BasicStroke(1.0f, 2, 2, 1.0f, dashing, 0.0f);
    public static final int LABEL_OFFSET = 10;
    protected static final int MAX_ITERATIONS = 10;
    protected Predicate vertexIncludePredicate = TruePredicate.getInstance();
    protected VertexStrokeFunction vertexStrokeFunction = new ConstantVertexStrokeFunction(1.0f);
    protected VertexShapeFunction vertexShapeFunction = new EllipseVertexShapeFunction(new ConstantVertexSizeFunction(20), new ConstantVertexAspectRatioFunction(1.0f));
    protected VertexStringer vertexStringer = new ConstantVertexStringer(null);
    protected VertexIconFunction vertexIconFunction;
    protected VertexFontFunction vertexFontFunction = new ConstantVertexFontFunction(new Font("Helvetica", 0, 12));
    protected boolean centerVertexLabel = false;
    protected VertexPaintFunction vertexPaintFunction = new PickableVertexPaintFunction(this, Color.BLACK, Color.RED, Color.ORANGE);
    protected EdgeStringer edgeStringer = new ConstantEdgeStringer(null);
    protected EdgeStrokeFunction edgeStrokeFunction = new ConstantEdgeStrokeFunction(1.0f);
    protected EdgeArrowFunction edgeArrowFunction = new DirectionalEdgeArrowFunction(10, 8, 4);
    protected Predicate edgeArrowPredicate = Graph.DIRECTED_EDGE;
    protected Predicate edgeIncludePredicate = TruePredicate.getInstance();
    protected EdgeFontFunction edgeFontFunction = new ConstantEdgeFontFunction(new Font("Helvetica", 0, 12));
    protected NumberEdgeValue edgeLabelClosenessFunction = new ConstantDirectionalEdgeValue(0.5, 0.65);
    protected EdgeShapeFunction edgeShapeFunction = new EdgeShape.QuadCurve();
    protected EdgePaintFunction edgePaintFunction = new ConstantEdgePaintFunction(Color.black, null);
    protected ParallelEdgeIndexFunction parallelEdgeIndexFunction = ParallelEdgeIndexSingleton.getInstance();
    protected MutableTransformer viewTransformer = new MutableAffineTransformer();
    protected JComponent screenDevice;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected GraphLabelRenderer graphLabelRenderer = new DefaultGraphLabelRenderer(Color.blue, Color.cyan);
    protected static final EdgePredicate self_loop = SelfLoopEdgePredicate.getInstance();

    public PluggableRenderer() {
        this.setEdgeShapeFunction(new EdgeShape.QuadCurve());
    }

    public EdgeArrowFunction getEdgeArrowFunction() {
        return this.edgeArrowFunction;
    }

    public Predicate getEdgeArrowPredicate() {
        return this.edgeArrowPredicate;
    }

    public EdgeFontFunction getEdgeFontFunction() {
        return this.edgeFontFunction;
    }

    public Predicate getEdgeIncludePredicate() {
        return this.edgeIncludePredicate;
    }

    public NumberEdgeValue getEdgeLabelClosenessFunction() {
        return this.edgeLabelClosenessFunction;
    }

    public EdgePaintFunction getEdgePaintFunction() {
        return this.edgePaintFunction;
    }

    public EdgeStringer getEdgeStringer() {
        return this.edgeStringer;
    }

    public EdgeStrokeFunction getEdgeStrokeFunction() {
        return this.edgeStrokeFunction;
    }

    public JComponent getScreenDevice() {
        return this.screenDevice;
    }

    public VertexFontFunction getVertexFontFunction() {
        return this.vertexFontFunction;
    }

    public Predicate getVertexIncludePredicate() {
        return this.vertexIncludePredicate;
    }

    public VertexPaintFunction getVertexPaintFunction() {
        return this.vertexPaintFunction;
    }

    public VertexStringer getVertexStringer() {
        return this.vertexStringer;
    }

    public VertexIconFunction getVertexIconFunction() {
        return this.vertexIconFunction;
    }

    public void setVertexIconFunction(VertexIconFunction vertexIconFunction) {
        this.vertexIconFunction = vertexIconFunction;
    }

    public VertexStrokeFunction getVertexStrokeFunction() {
        return this.vertexStrokeFunction;
    }

    public void setScreenDevice(JComponent screenDevice) {
        this.screenDevice = screenDevice;
        this.screenDevice.add(this.rendererPane);
    }

    public void setArrowPlacementTolerance(float tolerance) {
        this.arrow_placement_tolerance = tolerance;
    }

    public void setEdgeArrowFunction(EdgeArrowFunction eaf) {
        this.edgeArrowFunction = eaf;
    }

    public GraphLabelRenderer getGraphLabelRenderer() {
        return this.graphLabelRenderer;
    }

    public void setGraphLabelRenderer(GraphLabelRenderer graphLabelRenderer) {
        this.graphLabelRenderer = graphLabelRenderer;
    }

    public void setEdgeArrowPredicate(Predicate p) {
        this.edgeArrowPredicate = p;
    }

    public void setEdgeColorFunction(EdgeColorFunction ecf) {
        this.edgePaintFunction = new EdgeColorToEdgePaintFunctionConverter(ecf);
    }

    public void setEdgeFontFunction(EdgeFontFunction eff) {
        this.edgeFontFunction = eff;
    }

    public void setEdgeIncludePredicate(Predicate p) {
        this.edgeIncludePredicate = p;
    }

    public void setEdgeLabelClosenessFunction(NumberEdgeValue nev) {
        this.edgeLabelClosenessFunction = nev;
    }

    public void setEdgePaintFunction(EdgePaintFunction impl) {
        this.edgePaintFunction = impl;
    }

    public void setEdgeShapeFunction(EdgeShapeFunction impl) {
        this.edgeShapeFunction = impl;
        if (this.edgeShapeFunction instanceof EdgeShape.ParallelRendering) {
            ((EdgeShape.ParallelRendering)((Object)this.edgeShapeFunction)).setParallelEdgeIndexFunction(this.parallelEdgeIndexFunction);
        }
    }

    public EdgeShapeFunction getEdgeShapeFunction() {
        return this.edgeShapeFunction;
    }

    public void setEdgeStringer(EdgeStringer es) {
        this.edgeStringer = es;
    }

    public void setEdgeStrokeFunction(EdgeStrokeFunction esf) {
        this.edgeStrokeFunction = esf;
    }

    public void setVertexColorFunction(VertexColorFunction vcf) {
        this.vertexPaintFunction = new VertexColorToVertexPaintConverter(vcf);
    }

    public void setVertexPaintFunction(VertexPaintFunction vpf) {
        this.vertexPaintFunction = vpf;
    }

    public VertexShapeFunction getVertexShapeFunction() {
        return this.vertexShapeFunction;
    }

    public void setVertexFontFunction(VertexFontFunction vff) {
        this.vertexFontFunction = vff;
    }

    public void setVertexIncludePredicate(Predicate p) {
        this.vertexIncludePredicate = p;
    }

    public void setVertexLabelCentering(boolean b) {
        this.centerVertexLabel = b;
    }

    public boolean getVertexLabelCentering() {
        return this.centerVertexLabel;
    }

    public void setVertexShapeFunction(VertexShapeFunction vsf) {
        this.vertexShapeFunction = vsf;
    }

    public void setVertexStringer(VertexStringer vs) {
        this.vertexStringer = vs;
    }

    public void setVertexStrokeFunction(VertexStrokeFunction vsf) {
        this.vertexStrokeFunction = vsf;
    }

    public void paintEdge(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        if (!this.edgeIncludePredicate.evaluate((Object)e)) {
            return;
        }
        Pair endpoints = e.getEndpoints();
        Vertex v1 = (Vertex)endpoints.getFirst();
        Vertex v2 = (Vertex)endpoints.getSecond();
        if (!this.vertexIncludePredicate.evaluate((Object)v1) || !this.vertexIncludePredicate.evaluate((Object)v2)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Stroke new_stroke = this.edgeStrokeFunction.getStroke(e);
        Stroke old_stroke = g2d.getStroke();
        if (new_stroke != null) {
            g2d.setStroke(new_stroke);
        }
        this.drawSimpleEdge(g2d, e, x1, y1, x2, y2);
        if (new_stroke != null) {
            g2d.setStroke(old_stroke);
        }
    }

    protected void drawSimpleEdge(Graphics2D g, Edge e, int x1, int y1, int x2, int y2) {
        Pair endpoints = e.getEndpoints();
        Vertex v1 = (Vertex)endpoints.getFirst();
        Vertex v2 = (Vertex)endpoints.getSecond();
        boolean isLoop = v1.equals(v2);
        Shape s2 = this.vertexShapeFunction.getShape(v2);
        Shape edgeShape = this.edgeShapeFunction.getShape(e);
        boolean edgeHit = true;
        boolean arrowHit = true;
        Rectangle deviceRectangle = null;
        if (this.screenDevice != null) {
            Dimension d = this.screenDevice.getSize();
            if (d.width <= 0 || d.height <= 0) {
                d = this.screenDevice.getPreferredSize();
            }
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        edgeHit = this.viewTransformer.transform(edgeShape).intersects(deviceRectangle);
        if (edgeHit) {
            String label;
            Paint draw_paint;
            Paint oldPaint = g.getPaint();
            Paint fill_paint = this.edgePaintFunction.getFillPaint(e);
            if (fill_paint != null) {
                g.setPaint(fill_paint);
                g.fill(edgeShape);
            }
            if ((draw_paint = this.edgePaintFunction.getDrawPaint(e)) != null) {
                g.setPaint(draw_paint);
                g.draw(edgeShape);
            }
            float scalex = (float)g.getTransform().getScaleX();
            float scaley = (float)g.getTransform().getScaleY();
            if ((double)scalex < 0.3 || (double)scaley < 0.3) {
                return;
            }
            if (this.edgeArrowPredicate.evaluate((Object)e)) {
                Shape destVertexShape = this.vertexShapeFunction.getShape((Vertex)e.getEndpoints().getSecond());
                AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
                destVertexShape = xf.createTransformedShape(destVertexShape);
                arrowHit = this.viewTransformer.transform(destVertexShape).intersects(deviceRectangle);
                if (arrowHit) {
                    AffineTransform at = edgeShape instanceof GeneralPath ? this.getArrowTransform((GeneralPath)edgeShape, destVertexShape) : this.getArrowTransform(new GeneralPath(edgeShape), destVertexShape);
                    if (at == null) {
                        return;
                    }
                    Shape arrow = this.edgeArrowFunction.getArrow(e);
                    arrow = at.createTransformedShape(arrow);
                    g.fill(arrow);
                }
                if (e instanceof UndirectedEdge) {
                    Shape vertexShape = this.vertexShapeFunction.getShape((Vertex)e.getEndpoints().getFirst());
                    xf = AffineTransform.getTranslateInstance(x1, y1);
                    vertexShape = xf.createTransformedShape(vertexShape);
                    arrowHit = this.viewTransformer.transform(vertexShape).intersects(deviceRectangle);
                    if (arrowHit) {
                        AffineTransform at = edgeShape instanceof GeneralPath ? this.getReverseArrowTransform((GeneralPath)edgeShape, vertexShape, !isLoop) : this.getReverseArrowTransform(new GeneralPath(edgeShape), vertexShape, !isLoop);
                        if (at == null) {
                            return;
                        }
                        Shape arrow = this.edgeArrowFunction.getArrow(e);
                        arrow = at.createTransformedShape(arrow);
                        g.fill(arrow);
                    }
                }
            }
            if (draw_paint == null) {
                g.setPaint(oldPaint);
            }
            if ((label = this.edgeStringer.getLabel(e)) != null) {
                this.labelEdge(g, e, label, x1, x2, y1, y2);
            }
            g.setPaint(oldPaint);
        }
    }

    public AffineTransform getArrowTransform(GeneralPath edgeShape, Shape vertexShape) {
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = edgeShape.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
                if (vertexShape.contains(p2)) {
                    at = this.getArrowTransform(new Line2D.Float(p1, p2), vertexShape);
                    break;
                }
            }
            i.next();
        }
        return at;
    }

    public AffineTransform getReverseArrowTransform(GeneralPath edgeShape, Shape vertexShape) {
        return this.getReverseArrowTransform(edgeShape, vertexShape, true);
    }

    public AffineTransform getReverseArrowTransform(GeneralPath edgeShape, Shape vertexShape, boolean passedGo) {
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = edgeShape.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
                if (!passedGo && vertexShape.contains(p2)) {
                    passedGo = true;
                } else if (passedGo && !vertexShape.contains(p2)) {
                    at = this.getReverseArrowTransform(new Line2D.Float(p1, p2), vertexShape);
                    break;
                }
            }
            i.next();
        }
        return at;
    }

    public AffineTransform getArrowTransform(Line2D edgeShape, Shape vertexShape) {
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        while (dx * dx + dy * dy > this.arrow_placement_tolerance) {
            try {
                edgeShape = this.getLastOutsideSegment(edgeShape, vertexShape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.toString());
                return null;
            }
            dx = (float)(edgeShape.getX1() - edgeShape.getX2());
            dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        }
        double atheta = Math.atan2(dx, dy) + 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected AffineTransform getReverseArrowTransform(Line2D edgeShape, Shape vertexShape) {
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        while (dx * dx + dy * dy > this.arrow_placement_tolerance) {
            try {
                edgeShape = this.getFirstOutsideSegment(edgeShape, vertexShape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.toString());
                return null;
            }
            dx = (float)(edgeShape.getX1() - edgeShape.getX2());
            dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        }
        double atheta = Math.atan2(dx, dy) - 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected Line2D getLastOutsideSegment(Line2D line, Shape shape) {
        if (!shape.contains(line.getP2())) {
            String errorString = "line end point: " + line.getP2() + " is not contained in shape: " + shape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Double left = new Line2D.Double();
        Line2D.Double right = new Line2D.Double();
        int iterations = 0;
        do {
            this.subdivide(line, left, right);
        } while (!shape.contains((line = right).getP1()) && iterations++ < 10);
        return left;
    }

    protected Line2D getFirstOutsideSegment(Line2D line, Shape shape) {
        if (!shape.contains(line.getP1())) {
            String errorString = "line start point: " + line.getP1() + " is not contained in shape: " + shape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Float left = new Line2D.Float();
        Line2D.Float right = new Line2D.Float();
        do {
            this.subdivide(line, left, right);
        } while (!shape.contains((line = left).getP2()));
        return right;
    }

    protected void subdivide(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        if (left != null) {
            left.setLine(x1, y1, mx, my);
        }
        if (right != null) {
            right.setLine(mx, my, x2, y2);
        }
    }

    public Component prepareRenderer(GraphLabelRenderer graphLabelRenderer, Object value, boolean isSelected, Vertex vertex) {
        return graphLabelRenderer.getGraphLabelRendererComponent(this.screenDevice, value, this.vertexFontFunction.getFont(vertex), isSelected, vertex);
    }

    public Component prepareRenderer(GraphLabelRenderer renderer, Object value, boolean isSelected, Edge edge) {
        return this.graphLabelRenderer.getGraphLabelRendererComponent(this.screenDevice, value, this.edgeFontFunction.getFont(edge), isSelected, edge);
    }

    protected void labelEdge(Graphics2D g2d, Edge e, String label, int x1, int x2, int y1, int y2) {
        int distX = x2 - x1;
        int distY = y2 - y1;
        double totalLength = Math.sqrt(distX * distX + distY * distY);
        double closeness = this.edgeLabelClosenessFunction.getNumber(e).doubleValue();
        int posX = (int)((double)x1 + closeness * (double)distX);
        int posY = (int)((double)y1 + closeness * (double)distY);
        int xDisplacement = (int)(10.0 * ((double)distY / totalLength));
        int yDisplacement = (int)(10.0 * ((double)(-distX) / totalLength));
        Component component = this.prepareRenderer(this.graphLabelRenderer, (Object)label, this.isPicked(e), e);
        Dimension d = component.getPreferredSize();
        Shape edgeShape = this.edgeShapeFunction.getShape(e);
        double parallelOffset = 1.0;
        parallelOffset += (double)this.parallelEdgeIndexFunction.getIndex(e);
        if (edgeShape instanceof Ellipse2D) {
            parallelOffset += edgeShape.getBounds().getHeight();
            parallelOffset = -parallelOffset;
        }
        parallelOffset *= (double)d.height;
        AffineTransform old = g2d.getTransform();
        AffineTransform xform = new AffineTransform(old);
        xform.translate(posX + xDisplacement, posY + yDisplacement);
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (this.graphLabelRenderer.isRotateEdgeLabels()) {
            double theta = Math.atan2(dy, dx);
            if (dx < 0.0) {
                theta += Math.PI;
            }
            xform.rotate(theta);
        }
        if (dx < 0.0) {
            parallelOffset = -parallelOffset;
        }
        xform.translate(-d.width / 2, -((double)(d.height / 2) - parallelOffset));
        g2d.setTransform(xform);
        this.rendererPane.paintComponent(g2d, component, this.screenDevice, 0, 0, d.width, d.height, true);
        g2d.setTransform(old);
    }

    public void paintVertex(Graphics g, Vertex v, int x, int y) {
        if (!this.vertexIncludePredicate.evaluate((Object)v)) {
            return;
        }
        boolean vertexHit = true;
        Rectangle deviceRectangle = null;
        Graphics2D g2d = (Graphics2D)g;
        if (this.screenDevice != null) {
            Dimension d = this.screenDevice.getSize();
            if (d.width <= 0 || d.height <= 0) {
                d = this.screenDevice.getPreferredSize();
            }
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        Stroke old_stroke = g2d.getStroke();
        Stroke new_stroke = this.vertexStrokeFunction.getStroke(v);
        if (new_stroke != null) {
            g2d.setStroke(new_stroke);
        }
        Shape s = this.vertexShapeFunction.getShape(v);
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        s = xform.createTransformedShape(s);
        vertexHit = this.viewTransformer.transform(s).intersects(deviceRectangle);
        if (vertexHit) {
            String label;
            if (this.vertexIconFunction != null) {
                this.paintIconForVertex(g2d, v, x, y);
            } else {
                this.paintShapeForVertex(g2d, v, s);
            }
            if (new_stroke != null) {
                g2d.setStroke(old_stroke);
            }
            if ((label = this.vertexStringer.getLabel(v)) != null) {
                this.labelVertex(g, v, label, x, y);
            }
        }
    }

    public void paintShapeForVertex(Graphics2D g2d, Vertex v, Shape shape) {
        Paint drawPaint;
        Paint oldPaint = g2d.getPaint();
        Paint fillPaint = this.vertexPaintFunction.getFillPaint(v);
        if (fillPaint != null) {
            g2d.setPaint(fillPaint);
            g2d.fill(shape);
            g2d.setPaint(oldPaint);
        }
        if ((drawPaint = this.vertexPaintFunction.getDrawPaint(v)) != null) {
            g2d.setPaint(drawPaint);
            g2d.draw(shape);
            g2d.setPaint(oldPaint);
        }
    }

    public void paintIconForVertex(Graphics g, Vertex v, int x, int y) {
        Icon icon = this.vertexIconFunction.getIcon(v);
        if (icon == null) {
            Shape s = AffineTransform.getTranslateInstance(x, y).createTransformedShape(this.getVertexShapeFunction().getShape(v));
            this.paintShapeForVertex((Graphics2D)g, v, s);
        } else {
            int xLoc = x - icon.getIconWidth() / 2;
            int yLoc = y - icon.getIconHeight() / 2;
            icon.paintIcon(this.screenDevice, g, xLoc, yLoc);
        }
    }

    protected void labelVertex(Graphics g, Vertex v, String label, int x, int y) {
        int v_offset;
        int h_offset;
        Component component = this.prepareRenderer(this.graphLabelRenderer, (Object)label, this.isPicked(v), v);
        Dimension d = component.getPreferredSize();
        if (this.centerVertexLabel) {
            h_offset = -d.width / 2;
            v_offset = -d.height / 2;
        } else {
            Rectangle2D bounds = this.vertexShapeFunction.getShape(v).getBounds2D();
            h_offset = (int)(bounds.getWidth() / 2.0) + 5;
            v_offset = (int)(bounds.getHeight() / 2.0) + 5 - d.height;
        }
        this.rendererPane.paintComponent(g, component, this.screenDevice, x + h_offset, y + v_offset, d.width, d.height, true);
    }

    public boolean isPicked(ArchetypeVertex v) {
        return super.isPicked(v);
    }

    public boolean isPicked(ArchetypeEdge e) {
        return super.isPicked(e);
    }

    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public void setRendererPane(CellRendererPane rendererPane) {
        this.rendererPane = rendererPane;
    }

    public ParallelEdgeIndexFunction getParallelEdgeIndexFunction() {
        return this.parallelEdgeIndexFunction;
    }

    public void setParallelEdgeIndexFunction(ParallelEdgeIndexFunction parallelEdgeIndexFunction) {
        this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
    }

    public void setViewTransformer(MutableTransformer viewTransformer) {
        this.viewTransformer = viewTransformer;
    }
}

