/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.transform;

import java.awt.Dimension;
import java.util.Iterator;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.transform.LayoutTransformer;

public class PipelineResizingTransformer
implements LayoutTransformer {
    private Dimension elPreviousSize;
    private Dimension viewingDimension;

    public EmittedLayout transform(EmittedLayout el) {
        if (el.screenSize.equals(this.viewingDimension.getSize())) {
            return el;
        }
        Iterator iter = el.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vv = (VisVertex)iter.next();
            vv.scale(el.screenSize, this.viewingDimension);
        }
        this.elPreviousSize = el.screenSize;
        el.screenSize = this.viewingDimension.getSize();
        return el;
    }

    public void adjustSize(Dimension d) {
        this.viewingDimension = d;
    }

    public boolean supportsInvert() {
        return true;
    }

    public Coordinates invert(Coordinates in) {
        in.scale(this.viewingDimension, this.elPreviousSize);
        return in;
    }
}

