/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.tools.SwingWorker;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import com.lowagie.tools.plugins.InspectPDF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageXRefViewer
extends AbstractTool {
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    int picturenumber = 0;
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    CardLayout cardLayout1 = new CardLayout();
    JPanel jPanel3 = new JPanel();
    JSpinner jSpinner1 = new JSpinner();
    BorderLayout borderLayout3 = new BorderLayout();
    SpinnerModel spinnerModel1 = this.jSpinner1.getModel();
    JScrollPane jScrollPane1 = new JScrollPane();

    public ImageXRefViewer() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("View Image XObjects", true, false, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("images");
        this.jPanel2.setLayout(this.cardLayout1);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jSpinner1.addChangeListener(new ViewXRefImages_jSpinner1_propertyChangeAdapter(this));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.internalFrame.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel3.add((Component)this.jSpinner1, "Center");
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setViewportView(this.jPanel2);
        System.out.println("=== Image XObject Viewer OPENED ===");
    }

    public void valueHasChanged(ToolArgument toolArgument) {
    }

    public void jSpinner_propertyChange(ChangeEvent changeEvent) {
        int n = Integer.parseInt(this.jSpinner1.getValue().toString());
        if (n < 0) {
            n = 0;
        }
        if (n >= this.picturenumber) {
            n = this.picturenumber - 1;
        }
        this.cardLayout1.show(this.jPanel2, String.valueOf(n));
        this.jPanel2.repaint();
    }

    public static void main(String[] stringArray) {
        InspectPDF inspectPDF = new InspectPDF();
        if (stringArray.length < 1) {
            System.err.println(inspectPDF.getUsage());
        }
        inspectPDF.setArguments(stringArray);
        inspectPDF.execute();
    }

    public void execute() {
        this.picturenumber = 0;
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    try {
                        PdfReader pdfReader = new PdfReader(((File)ImageXRefViewer.this.getValue("srcfile")).getAbsolutePath());
                        for (int i = 0; i < pdfReader.getXrefSize(); ++i) {
                            PdfStream pdfStream;
                            PdfObject pdfObject;
                            PdfObject pdfObject2 = pdfReader.getPdfObject(i);
                            if (pdfObject2 == null || !pdfObject2.isStream() || (pdfObject = (pdfStream = (PdfStream)pdfObject2).get(PdfName.SUBTYPE)) == null || !pdfObject.toString().equals(PdfName.IMAGE.toString())) continue;
                            System.out.println("picturenumber: " + ImageXRefViewer.this.picturenumber);
                            System.out.println("height:" + pdfStream.get(PdfName.HEIGHT));
                            System.out.println("width:" + pdfStream.get(PdfName.WIDTH));
                            System.out.println("bitspercomponent:" + pdfStream.get(PdfName.BITSPERCOMPONENT));
                            byte[] byArray = PdfReader.getStreamBytesRaw((PRStream)pdfStream);
                            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                            ImageIcon imageIcon = new ImageIcon(image);
                            JLabel jLabel = new JLabel();
                            jLabel.setIcon(imageIcon);
                            ImageXRefViewer.this.jPanel2.add((Component)jLabel, "" + ImageXRefViewer.this.picturenumber++);
                        }
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ImageXRefViewer.this.internalFrame.setCursor(Cursor.getDefaultCursor());
                    return null;
                }
            };
            this.internalFrame.setCursor(Cursor.getPredefinedCursor(3));
            swingWorker.start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    static {
        ImageXRefViewer.addVersion("$Id: ImageXRefViewer.java,v 1.4 2006/09/14 23:10:57 xlv Exp $");
    }

    class ViewXRefImages_jSpinner1_propertyChangeAdapter
    implements ChangeListener {
        private ImageXRefViewer adaptee;

        ViewXRefImages_jSpinner1_propertyChangeAdapter(ImageXRefViewer imageXRefViewer2) {
            this.adaptee = imageXRefViewer2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.adaptee.jSpinner_propertyChange(changeEvent);
        }
    }
}

