/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.analysisView;

import SocLab.GUI.analysisView.QuickOrgGraphView;
import SocLab.GUI.desktop.DesktopFrame;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.tools.StatTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class GraphView
extends JInternalFrame {
    private QuickOrgGraphView quickOrgGraphView;
    private JButton buttonHelp;

    public GraphView(JDesktopPane desktop) {
        super("Networks", true, true, true, true);
        this.setFrameIcon(DesktopFrame.statAnalysisIcon);
        this.quickOrgGraphView = new QuickOrgGraphView(null);
        if (SocLabToolkit.currentOrgNew.getNbActorsNew() < 2 && SocLabToolkit.currentOrgNew.getNbRelationsNew() < 2) {
            this.hide();
        } else {
            this.init();
        }
    }

    private void init() {
        this.setOrgNew(SocLabToolkit.currentOrgNew);
        this.setLayout(new BorderLayout());
        this.buttonHelp = new JButton("Help");
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newHelpNetwork();
            }
        });
        this.add((Component)this.quickOrgGraphView, "Center");
        this.add((Component)this.buttonHelp, "South");
        this.setSize(1200, 650);
        this.setVisible(true);
    }

    public void setOrgNew(OrgNew orgNew) {
        StatTools.computeOrgVars(orgNew);
        this.quickOrgGraphView.setOrgNew(orgNew);
    }
}

