/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.analysisView;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocialGameState;
import java.util.LinkedHashMap;

class SignifiantStates {
    private OrgNew orgNew;
    private String[] rNames;
    private String[] aNames;
    String[][] actorIndicators;
    String[][] relationIndicators;
    LinkedHashMap<String, String[][]> actorActorIndicators;
    LinkedHashMap<String, String[][]> relationActorIndicators;
    String[][] signifiantStates;
    String[] actorIndicatorLabels;
    String[] relationIndicatorLabels;
    LinkedHashMap<String, String[]> actorActorIndicatorLabels;
    LinkedHashMap<String, String[]> relationActorIndicatorLabels;
    String[] signifiantStateLabels;
    private String[] actorVariablesNames;
    private String[] relationVariablesNames;
    String[] relationActorVariablesNames;
    String[] actorActorVariablesNames;
    private String[] signifiantStateNames;
    private String[] actorSignifiantStateNames;

    SignifiantStates(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.init();
    }

    private void init() {
        this.rNames = this.orgNew.getRelationsNewName();
        this.aNames = this.orgNew.getActorsNewName();
        this.initNames();
        this.initIndicatorsAndSignificantStates();
    }

    private void initIndicatorsAndSignificantStates() {
        int i;
        double val;
        int j;
        this.actorActorIndicators = new LinkedHashMap();
        this.relationActorIndicators = new LinkedHashMap();
        this.actorActorIndicatorLabels = new LinkedHashMap();
        this.relationActorIndicatorLabels = new LinkedHashMap();
        this.actorIndicatorLabels = new String[this.actorVariablesNames.length + 1];
        this.actorIndicatorLabels[0] = "Actors";
        int length = this.actorVariablesNames.length;
        System.arraycopy(this.actorVariablesNames, 0, this.actorIndicatorLabels, 1, length);
        this.relationIndicatorLabels = new String[this.relationVariablesNames.length + 1];
        this.relationIndicatorLabels[0] = "Relations";
        int taille = this.relationVariablesNames.length;
        System.arraycopy(this.relationVariablesNames, 0, this.relationIndicatorLabels, 1, taille);
        int k = 0;
        while (k < this.relationActorVariablesNames.length) {
            String[] relationActorIndicatorLabel = new String[this.rNames.length + 2];
            relationActorIndicatorLabel[0] = this.relationActorVariablesNames[k];
            relationActorIndicatorLabel[1] = "";
            System.arraycopy(this.rNames, 0, relationActorIndicatorLabel, 2, this.rNames.length);
            this.relationActorIndicatorLabels.put(this.relationActorVariablesNames[k], relationActorIndicatorLabel);
            ++k;
        }
        k = 0;
        while (k < this.actorActorVariablesNames.length) {
            String[] actorActorIndicatorLabel = new String[this.aNames.length + 2];
            actorActorIndicatorLabel[0] = this.actorActorVariablesNames[k];
            actorActorIndicatorLabel[1] = "";
            System.arraycopy(this.aNames, 0, actorActorIndicatorLabel, 2, this.aNames.length);
            this.actorActorIndicatorLabels.put(this.actorActorVariablesNames[k], actorActorIndicatorLabel);
            ++k;
        }
        int signifiantStateWidth = this.aNames.length * this.actorSignifiantStateNames.length + this.signifiantStateNames.length + 1;
        this.signifiantStateLabels = new String[signifiantStateWidth];
        this.signifiantStateLabels[0] = "Relations/Actors";
        System.arraycopy(this.signifiantStateNames, 0, this.signifiantStateLabels, 1, this.signifiantStateNames.length);
        int i2 = 0;
        while (i2 < this.actorSignifiantStateNames.length) {
            j = 0;
            while (j < this.aNames.length) {
                this.signifiantStateLabels[this.signifiantStateNames.length + i2 * this.aNames.length + j + 1] = String.valueOf(this.aNames[j]) + "'s " + this.actorSignifiantStateNames[i2];
                ++j;
            }
            ++i2;
        }
        this.actorIndicators = new String[this.aNames.length][this.actorVariablesNames.length + 1];
        int j2 = 0;
        while (j2 < this.aNames.length) {
            this.actorIndicators[j2][0] = this.aNames[j2];
            ++j2;
        }
        i2 = 0;
        while (i2 < this.actorVariablesNames.length) {
            j = 0;
            while (j < this.aNames.length) {
                ActorNew aN = this.orgNew.getActorNew(this.aNames[j]);
                val = 0.0;
                switch (i2) {
                    case 0: {
                        val = aN.getAutonomy();
                        break;
                    }
                    case 1: {
                        val = aN.getSubordination();
                        break;
                    }
                    case 2: {
                        val = aN.getMaxSatis();
                        break;
                    }
                    case 3: {
                        val = aN.getMinSatis();
                        break;
                    }
                    case 4: {
                        val = aN.getMaxStructPowerBrut();
                        break;
                    }
                    case 5: {
                        val = aN.getMinStructPowerBrut();
                    }
                }
                this.actorIndicators[j][i2 + 1] = "" + this.shiftDecimal(val, 1);
                ++j;
            }
            ++i2;
        }
        this.relationIndicators = new String[this.rNames.length][this.relationVariablesNames.length + 1];
        j2 = 0;
        while (j2 < this.rNames.length) {
            this.relationIndicators[j2][0] = this.rNames[j2];
            ++j2;
        }
        i2 = 0;
        while (i2 < this.relationVariablesNames.length) {
            j = 0;
            while (j < this.rNames.length) {
                RelationNew rN = this.orgNew.getRelationNew(this.rNames[j]);
                val = 0.0;
                switch (i2) {
                    case 0: {
                        val = rN.getMaxPotentialStrength();
                        break;
                    }
                    case 1: {
                        val = rN.getAccumulatedPotentialStrength();
                        break;
                    }
                    case 2: {
                        val = rN.getEffectiveMaxStrength();
                        break;
                    }
                    case 3: {
                        val = rN.getAccumulatedEffectiveStrength();
                        break;
                    }
                    case 4: {
                        val = rN.getRelevance();
                    }
                }
                this.relationIndicators[j][i2 + 1] = "" + this.shiftDecimal(val, 1);
                ++j;
            }
            ++i2;
        }
        int k2 = 0;
        while (k2 < this.relationActorVariablesNames.length) {
            String[][] relationActorIndicator = new String[this.aNames.length * 3][this.rNames.length + 1];
            int j3 = 0;
            int m = 0;
            i = 0;
            while (i < this.aNames.length) {
                relationActorIndicator[j3][0] = this.aNames[i];
                relationActorIndicator[j3 + 1][0] = this.aNames[i];
                relationActorIndicator[j3 + 2][0] = this.aNames[i];
                j3 += 3;
                ++i;
            }
            i = 0;
            while (i < this.aNames.length) {
                int l = 0;
                while (l < this.rNames.length) {
                    ActorNew aN = this.orgNew.getActorNew(this.aNames[i]);
                    RelationNew rN = this.orgNew.getRelationNew(this.rNames[l]);
                    relationActorIndicator[m][l + 1] = "" + this.shiftDecimal(rN.getDepend(aN.getName()).getStrengthMin(aN, rN), 1);
                    relationActorIndicator[m + 1][l + 1] = "" + this.shiftDecimal(rN.getDepend(aN.getName()).getStrengthMax(aN, rN), 1);
                    relationActorIndicator[m + 2][l + 1] = "" + this.shiftDecimal(rN.getDepend(aN.getName()).getStrength(), 1);
                    ++l;
                }
                m += 3;
                ++i;
            }
            this.relationActorIndicators.put(this.relationActorVariablesNames[k2], relationActorIndicator);
            ++k2;
        }
        k2 = 0;
        while (k2 < this.actorActorVariablesNames.length) {
            String[][] actorActorIndicator = new String[this.aNames.length * 3][this.aNames.length + 1];
            int j4 = 0;
            int i3 = 0;
            while (i3 < this.aNames.length) {
                actorActorIndicator[j4][0] = this.aNames[i3];
                actorActorIndicator[j4 + 1][0] = this.aNames[i3];
                actorActorIndicator[j4 + 2][0] = this.aNames[i3];
                j4 += 3;
                ++i3;
            }
            j4 = 0;
            i3 = 0;
            while (i3 < this.aNames.length) {
                int l = 0;
                while (l < this.aNames.length) {
                    ActorNew aN1 = this.orgNew.getActorNew(this.aNames[l]);
                    ActorNew aN2 = this.orgNew.getActorNew(this.aNames[i3]);
                    actorActorIndicator[j4][l + 1] = "" + this.shiftDecimal(aN1.getTarget(aN2.getName()).getMinStructPowerBrut(aN1, aN2), 1);
                    actorActorIndicator[j4 + 1][l + 1] = "" + this.shiftDecimal(aN1.getTarget(aN2.getName()).getMaxStructPowerBrut(aN1, aN2), 1);
                    actorActorIndicator[j4 + 2][l + 1] = "" + this.shiftDecimal(aN1.getTarget(aN2.getName()).getStructPowerBrut(), 1);
                    ++l;
                }
                j4 += 3;
                this.actorActorIndicators.put(this.actorActorVariablesNames[k2], actorActorIndicator);
                ++i3;
            }
            ++k2;
        }
        this.signifiantStates = new String[this.rNames.length + this.aNames.length + 1][signifiantStateWidth];
        i2 = 0;
        while (i2 < this.rNames.length) {
            this.signifiantStates[i2][0] = this.rNames[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.aNames.length) {
            this.signifiantStates[this.rNames.length + i2][0] = this.aNames[i2];
            ++i2;
        }
        this.signifiantStates[this.signifiantStates.length - 1][0] = "GLOBAL";
        k2 = 0;
        while (k2 < this.signifiantStateNames.length) {
            SocialGameState state = null;
            switch (k2) {
                case 0: {
                    state = this.orgNew.getStatesMaxSS().getRandomState();
                    break;
                }
                case 1: {
                    state = this.orgNew.getStatesMinSS().getRandomState();
                }
            }
            int i4 = 0;
            while (i4 < this.rNames.length) {
                this.signifiantStates[i4][k2 + 1] = "" + this.shiftDecimal((Double)state.get(this.orgNew.getRelationNew(this.rNames[i4])), 1);
                ++i4;
            }
            i4 = 0;
            while (i4 < this.aNames.length) {
                this.signifiantStates[this.rNames.length + i4][k2 + 1] = "" + this.shiftDecimal(this.orgNew.getActorNew(this.aNames[i4]).getSatisfaction(this.orgNew.getActorNew(this.aNames[i4]), state), 1);
                ++i4;
            }
            this.signifiantStates[this.signifiantStates.length - 1][k2 + 1] = "" + this.shiftDecimal(this.orgNew.getSumSatisfaction(state), 1);
            ++k2;
        }
        k2 = 0;
        while (k2 < this.actorSignifiantStateNames.length) {
            int j5 = 0;
            while (j5 < this.aNames.length) {
                ActorNew aN = this.orgNew.getActorNew(this.aNames[j5]);
                SocialGameState state = null;
                switch (k2) {
                    case 0: {
                        state = aN.getStateMaxSatis().getRandomState();
                        break;
                    }
                    case 1: {
                        state = aN.getStateMinSatis().getRandomState();
                        break;
                    }
                    case 2: {
                        state = aN.getStateMaxSitCooperativePowerBrut().getRandomState();
                        break;
                    }
                    case 3: {
                        state = aN.getStateMinSitCooperativePowerBrut().getRandomState();
                        break;
                    }
                    case 4: {
                        state = aN.getStateMaxSitAbsolutePowerBrut().getRandomState();
                        break;
                    }
                    case 5: {
                        state = aN.getStateMinSitAbsolutePowerBrut().getRandomState();
                    }
                }
                i = 0;
                while (i < this.rNames.length) {
                    this.signifiantStates[i][this.signifiantStateNames.length + k2 * this.aNames.length + j5 + 1] = "" + this.shiftDecimal((Double)state.get(this.orgNew.getRelationNew(this.rNames[i])), 1);
                    ++i;
                }
                i = 0;
                while (i < this.aNames.length) {
                    this.signifiantStates[this.rNames.length + i][this.signifiantStateNames.length + k2 * this.aNames.length + j5 + 1] = "" + this.shiftDecimal(this.orgNew.getActorNew(this.aNames[i]).getSatisfaction(this.orgNew.getActorNew(this.aNames[i]), state), 1);
                    ++i;
                }
                this.signifiantStates[this.signifiantStates.length - 1][this.signifiantStateNames.length + k2 * this.aNames.length + j5 + 1] = "" + this.shiftDecimal(this.orgNew.getSumSatisfaction(state), 1);
                ++j5;
            }
            ++k2;
        }
    }

    private void initNames() {
        this.actorVariablesNames = new String[]{"AUTONOMY", "SUBORDINATION", "MAX_SATISFACTION", "MIN_SATISFACTION", "MAX_STRUCTURAL_POWER", "MIN_STRUCTURAL_POWER"};
        this.relationVariablesNames = new String[]{"MAX_POTENTIAL_STRENGTH", "ACCUMULATED_POTENTIAL_STRENGTH", "EFFECTIVE_MAX_STRENGTH", "ACCUMULATED_EFFECTIVE_STRENGTH", "RELEVANCE"};
        this.relationActorVariablesNames = new String[]{"IMPACT"};
        this.actorActorVariablesNames = new String[]{"STRUCTURAL_POWER", "RELATIVE_STRUCTURAL_POWER"};
        this.signifiantStateNames = new String[]{"MAX_GLOBAL_SATIS", "MIN_GLOBAL_SATIS"};
        this.actorSignifiantStateNames = new String[]{"MAX_SATIS", "MIN_SATIS", "MAX_COOP_POWER", "MIN_COOP_POWER", "MAX_ABS_POWER", "MIN_ABS_POWER"};
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }

    public String[] getrNames() {
        return this.rNames;
    }

    public void setrNames(String[] rNames) {
        this.rNames = rNames;
    }

    public String[] getaNames() {
        return this.aNames;
    }

    public void setaNames(String[] aNames) {
        this.aNames = aNames;
    }
}

