/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction.effectGuiComponents;

import SocLab.GUI.effectAction.EffectModellingGUI;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BoundsController
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSlider infSlide = new JSlider(0, -10, 10, -10);
    private JSlider supSlide = new JSlider(0, -10, 10, 10);
    private JLabel infLabel = new JLabel("borne inf.");
    private JLabel supLabel = new JLabel("borne sup.");
    private EffectModellingGUI effectSelector;

    BoundsController(EffectModellingGUI effectSelector) {
        this.effectSelector = effectSelector;
        this.setLayout(new GridBagLayout());
        this.infLabel.setText(SwitchLanguages.BoundsControllerLowerBound[SocLabToolkit.idLanguage]);
        this.supLabel.setText(SwitchLanguages.BoundsControllerUpperBound[SocLabToolkit.idLanguage]);
        this.init();
        this.updateValues();
    }

    private void init() {
        double inf = this.effectSelector.getEffectNew().getRelationNew().getRPNInitial().getLowerBound();
        double sup = this.effectSelector.getEffectNew().getRelationNew().getRPNInitial().getUpperBound();
        this.infSlide.setValue(new Double(inf).intValue());
        this.supSlide.setValue(new Double(sup).intValue());
        this.infSlide.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BoundsController.this.effectSelector.changeRelationBounds(BoundsController.this.infSlide.getValue(), BoundsController.this.supSlide.getValue());
            }
        });
        this.supSlide.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BoundsController.this.effectSelector.changeRelationBounds(BoundsController.this.infSlide.getValue(), BoundsController.this.supSlide.getValue());
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = -1;
        this.add((Component)this.infLabel, gbc);
        gbc.gridwidth = 0;
        this.add((Component)this.infSlide, gbc);
        gbc.gridwidth = -1;
        this.add((Component)this.supLabel, gbc);
        gbc.gridwidth = 0;
        this.add((Component)this.supSlide, gbc);
        this.setPreferredSize(new Dimension(120, 50));
    }

    void updateValues() {
        RelationNew r = this.effectSelector.getEffectNew().getRelationNew();
        this.infSlide.setValue(new Double(r.getRPNInitial().getLowerBound()).intValue());
        this.supSlide.setValue(new Double(r.getRPNInitial().getUpperBound()).intValue());
    }
}

