/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

class ActorDescEditor
extends JDialog {
    private static final String ACTOR_DESCRIPTION = "DESCRIPTION";
    private OrgNew orgNew;
    private String actorName;
    private JTextArea showDescEditor;
    private JTextArea editDescEditor;
    private boolean desc;

    ActorDescEditor(Frame owner, OrgNew orgNew, String actorName, boolean desc) {
        super(owner, String.valueOf(SwitchLanguages.ActorDescEditorTitle[SocLabToolkit.idLanguage]) + actorName, true);
        this.orgNew = orgNew;
        this.actorName = actorName;
        this.desc = desc;
        this.init();
    }

    private void init() {
        JTabbedPane tabPanel = new JTabbedPane();
        JPanel showPanel = new JPanel();
        this.showDescEditor = new JTextArea();
        JButton okButton = new JButton(SwitchLanguages.ActorDescEditorOkButton[SocLabToolkit.idLanguage], DesktopFrame.okIcon);
        JPanel editPanel = new JPanel();
        JTabbedPane editTabPanel = new JTabbedPane();
        this.editDescEditor = new JTextArea();
        JPanel buttonPanel = new JPanel();
        JButton saveButton = new JButton(SwitchLanguages.ActorDescEditorSaveButton[SocLabToolkit.idLanguage], DesktopFrame.saveModelIcon);
        JButton cancelButton = new JButton(SwitchLanguages.ActorDescEditorCancelButton[SocLabToolkit.idLanguage], DesktopFrame.cancelIcon);
        this.showDescEditor.setEditable(false);
        this.showDescEditor.setLineWrap(true);
        this.editDescEditor.setLineWrap(true);
        this.showDescEditor.setWrapStyleWord(true);
        this.editDescEditor.setWrapStyleWord(true);
        this.initValues();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorDescEditor.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorDescEditor.this.dispose();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorDescEditor.this.saveValues();
                ActorDescEditor.this.initValues();
                ActorDescEditor.this.dispose();
            }
        });
        editPanel.setLayout(new BorderLayout());
        showPanel.setLayout(new BorderLayout());
        buttonPanel.add(saveButton);
        buttonPanel.add(cancelButton);
        editTabPanel.add((Component)new JScrollPane(this.editDescEditor), ACTOR_DESCRIPTION);
        editPanel.add((Component)editTabPanel, "Center");
        editPanel.add((Component)buttonPanel, "South");
        showPanel.add((Component)new JScrollPane(this.showDescEditor), "Center");
        showPanel.add((Component)okButton, "South");
        tabPanel.add((Component)showPanel, "Description");
        tabPanel.add((Component)editPanel, "Edition");
        this.add(tabPanel);
        this.setSize(400, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setVisible(this.desc);
    }

    private void saveValues() {
        this.orgNew.getActorNew(this.actorName).setDescription(this.editDescEditor.getText());
    }

    public void initValues() {
        String showText = "";
        String desc = this.orgNew.getActorNew(this.actorName).getDescription();
        if (desc == null) {
            desc = "";
        }
        showText = "DESCRIPTION : \n\t" + desc + "\n\n";
        this.editDescEditor.setText(desc);
        this.showDescEditor.setText(showText);
    }
}

