/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class DescriptionParams
extends JPanel {
    private String text = "";
    private JToggleButton editButton;
    private JTextPane orgDescInput = new JTextPane();
    private JLabel descLabel;

    public DescriptionParams() {
        this.setLayout(null);
        JScrollPane scrollPane = new JScrollPane(this.orgDescInput);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        scrollPane.setMinimumSize(new Dimension(300, 200));
        this.orgDescInput.setEditorKit(new HTMLEditorKit());
        this.orgDescInput.setBackground(new Color(235, 235, 255));
        this.orgDescInput.setCaretColor(Color.BLACK);
        this.orgDescInput.setMargin(new Insets(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.descLabel = new JLabel("<html><font color=blue><b>MODEL DESCRIPTION</b></font></html>");
        this.descLabel.setHorizontalAlignment(0);
        this.editButton = new JToggleButton("Edit", DesktopFrame.editCancelIcon);
        this.editButton.setFocusable(false);
        this.editButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DescriptionParams.this.editButton.isSelected()) {
                    DescriptionParams.this.editButton.setIcon(DesktopFrame.editOkIcon);
                    DescriptionParams.this.orgDescInput.getCaret().setVisible(true);
                    DescriptionParams.this.orgDescInput.setEditorKit(new StyledEditorKit());
                    DescriptionParams.this.orgDescInput.setText(DescriptionParams.this.text);
                    DescriptionParams.this.orgDescInput.setEditable(true);
                    DescriptionParams.this.orgDescInput.setBackground(Color.WHITE);
                } else {
                    DescriptionParams.this.text = DescriptionParams.this.orgDescInput.getText();
                    DescriptionParams.this.editButton.setIcon(DesktopFrame.editCancelIcon);
                    DescriptionParams.this.orgDescInput.setEditorKit(new HTMLEditorKit());
                    DescriptionParams.this.orgDescInput.setText(DescriptionParams.this.text2HTML());
                    DescriptionParams.this.orgDescInput.setEditable(false);
                    DescriptionParams.this.orgDescInput.setBackground(new Color(235, 235, 255));
                    DescriptionParams.this.updateParams();
                }
            }
        });
        buttonPanel.add((Component)this.descLabel, "Center");
        buttonPanel.add((Component)this.editButton, "East");
        this.setPreferredSize(new Dimension(300, 200));
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonPanel, "North");
        this.initValues();
    }

    public void switchLanguage() {
        this.descLabel.setText("<html><font color=blue><b>" + SwitchLanguages.DescriptionParamsDescLabel[SocLabToolkit.idLanguage] + "</b></font></html>");
        this.editButton.setToolTipText(SwitchLanguages.DescriptionParamsEditButtonTips[SocLabToolkit.idLanguage]);
        this.editButton.setText(SwitchLanguages.DescriptionParamsEditButtonText[SocLabToolkit.idLanguage]);
    }

    public void initValues() {
        this.switchLanguage();
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew != null) {
            this.text = orgNew.getDescription();
            this.orgDescInput.setText(this.text2HTML());
        }
        this.repaint();
    }

    private void updateParams() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        this.text = this.text.replace('<', '_');
        this.text = this.text.replace('>', '_');
        this.text = this.text.replace('\"', '_');
        orgNew.setDescription(this.text);
    }

    private String text2HTML() {
        String result = "<html>";
        StringTokenizer token = new StringTokenizer(this.text, "\n");
        while (token.hasMoreTokens()) {
            String line = token.nextToken();
            result = this.isUpperCase(line) ? String.valueOf(result) + "<font color=blue><b><u>" + line + "</u></b></font>" + "<br>" : String.valueOf(result) + "<font size=-1>" + line + "</font>" + "<br>";
        }
        return String.valueOf(result) + "</html>";
    }

    private boolean isUpperCase(String text) {
        int i = 0;
        while (i < text.length()) {
            Character c = Character.valueOf(text.charAt(i));
            if (Character.isLetter(c.charValue()) && Character.isLowerCase(c.charValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

