/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels;

import SocLab.GUI.modelEditor.ParamsPanels.OrgTableModel;
import SocLab.GUI.modelEditor.ParamsPanels.renderers.CheckBoxEditor;
import SocLab.GUI.modelEditor.ParamsPanels.renderers.CheckBoxRender;
import SocLab.GUI.modelEditor.ParamsPanels.renderers.JBiComboBox;
import SocLab.GUI.modelEditor.ParamsPanels.renderers.MiniConstraintFunctionRender;
import SocLab.GUI.modelEditor.ParamsPanels.renderers.MiniEffectFunctionRenderer;
import SocLab.core.SocLabToolkit;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class OrgTable
extends JTable {
    private String param;
    private MiniEffectFunctionRenderer effectFunctionRenderer = new MiniEffectFunctionRenderer(null);
    private MiniConstraintFunctionRender effectConstraintFunctionRenderer = new MiniConstraintFunctionRender(null);
    private CheckBoxRender chechBoxRenderer = new CheckBoxRender();
    private CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
    private String[] frequenceChoices = new String[]{"0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1.0"};
    private String[] BminChoices = new String[]{"-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private String[] BmaxChoices = new String[]{"-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private String[] stakeChoices = new String[]{"0", "0.1", "0.2", "0.3", "0.5", "1", "1.5", "2", "2.5", "3", "3.5", "4", "4.5", "5", "5.5", "6", "6.5", "7", "7.5", "8", "8.5", "9", "9.5", "10"};
    private String[] solidarityChoices = new String[]{"-1", "-0.95", "-0.9", "-0.85", "-0.8", "-0.75", "-0.7", "-0.65", "-0.6", "-0.55", "-0.5", "-0.45", "-0.4", "-0.35", "-0.3", "-0.25", "-0.2", "-0.15", "-0.1", "-0.05", "0", "0.05", "0.1", "0.15", "0.2", "0.25", "0.3", "0.35", "0.4", "0.45", "0.5", "0.55", "0.6", "0.65", "0.7", "0.75", "0.8", "0.85", "0.9", "0.95", "1"};
    private JComboBox frequenceComboBox = new JComboBox<String>(this.frequenceChoices);
    private JComboBox BminComboBox = new JComboBox<String>(this.BminChoices);
    private JComboBox BmaxComboBox = new JComboBox<String>(this.BmaxChoices);
    private JComboBox stakeComboBox = new JComboBox<String>(this.stakeChoices);
    private JComboBox solidarityComboBox = new JComboBox<String>(this.solidarityChoices);
    private JBiComboBox stakeBiBoxRenderer = new JBiComboBox(this.stakeChoices);
    private JBiComboBox solidarityBiBoxRenderer = new JBiComboBox(this.solidarityChoices);

    OrgTable(String param) {
        super(new OrgTableModel(param));
        this.param = param;
        this.setShowGrid(false);
        int i = 0;
        while (i < this.getColumnCount()) {
            this.getColumnModel().getColumn(i).setResizable(false);
            ++i;
        }
        this.setAutoResizeMode(0);
        this.setFillsViewportHeight(true);
        this.stakeComboBox.setMaximumRowCount(30);
        this.frequenceComboBox.setMaximumRowCount(30);
        this.solidarityComboBox.setMaximumRowCount(30);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        if (this.param.equals("effect") && row > 0 && col > 0) {
            return this.effectFunctionRenderer;
        }
        if (this.param.equals("constraint") && row > 0 && col > 0) {
            return this.effectConstraintFunctionRenderer;
        }
        if (this.param.equals("control") && row > 0 && col > 0 && col < SocLabToolkit.currentOrgNew.getNbActorsNew() + 1) {
            return this.chechBoxRenderer;
        }
        if (this.param.equals("fuzzyStake") && row > 0 && col > 0) {
            return this.stakeBiBoxRenderer;
        }
        if (this.param.equals("fuzzyAltruism") && row > 0 && col > 0) {
            return this.solidarityBiBoxRenderer;
        }
        return super.getCellRenderer(row, col);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        if (this.param.equals("control")) {
            if (col == SocLabToolkit.currentOrgNew.getNbActorsNew() + 1 && row > 0) {
                return new DefaultCellEditor(this.frequenceComboBox);
            }
            if (col == SocLabToolkit.currentOrgNew.getNbActorsNew() + 2 && row > 0) {
                return new DefaultCellEditor(this.BminComboBox);
            }
            if (col == SocLabToolkit.currentOrgNew.getNbActorsNew() + 3 && row > 0) {
                return new DefaultCellEditor(this.BmaxComboBox);
            }
            if (row > 0 && col > 0) {
                return this.checkBoxEditor;
            }
        }
        if (this.param.equals("stake") && row > 0 && col > 0) {
            return new DefaultCellEditor(this.stakeComboBox);
        }
        if (this.param.equals("solidarity") && row > 0 && col > 0) {
            return new DefaultCellEditor(this.solidarityComboBox);
        }
        if (this.param.equals("fuzzyStake") && row > 0 && col > 0) {
            return this.stakeBiBoxRenderer;
        }
        if (this.param.equals("fuzzyAltruism") && row > 0 && col > 0) {
            return this.solidarityBiBoxRenderer;
        }
        return super.getCellEditor(row, col);
    }

    public void setEditMode(boolean b) {
        ((OrgTableModel)this.getModel()).setEditMode(b);
    }
}

