/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class JBiComboBox
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ItemListener {
    private JPanel panel = new JPanel();
    private JComboBox jcomboMin;
    private JComboBox jcomboMax;
    private JLabel label = new JLabel();

    public JBiComboBox(String[] choices) {
        this.jcomboMin = new JComboBox<String>(choices);
        this.jcomboMax = new JComboBox<String>(choices);
        this.panel.add(this.jcomboMin);
        this.panel.add(this.jcomboMax);
        this.jcomboMin.setMaximumRowCount(30);
        this.jcomboMax.setMaximumRowCount(30);
        this.label.setHorizontalAlignment(0);
        this.jcomboMin.addItemListener(this);
        this.jcomboMax.addItemListener(this);
    }

    public JComboBox getJcomboMax() {
        return this.jcomboMax;
    }

    public void setJcomboMax(JComboBox jcomboMax) {
        this.jcomboMax = jcomboMax;
    }

    public JComboBox getJcomboMin() {
        return this.jcomboMin;
    }

    public void setJcomboMin(JComboBox jcomboMin) {
        this.jcomboMin = jcomboMin;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        if (hasFocus) {
            this.label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        } else {
            this.label.setBorder(BorderFactory.createEmptyBorder());
        }
        if (row % 2 == 1) {
            this.label.setBackground(new Color(230, 230, 255));
        } else {
            this.label.setBackground(new Color(240, 240, 255));
        }
        if (object != null) {
            double[] interval = (double[])object;
            this.label.setText("[" + interval[0] + ";" + interval[1] + "]");
        }
        return this.label;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.jcomboMin)) {
            this.jcomboMin.nextFocus();
        } else {
            this.fireEditingStopped();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return new double[]{Double.parseDouble((String)this.jcomboMin.getSelectedItem()), Double.parseDouble((String)this.jcomboMax.getSelectedItem())};
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            System.out.println(value.getClass());
            this.jcomboMin.setSelectedItem(((double[])value)[0]);
            this.jcomboMax.setSelectedItem(((double[])value)[1]);
        } else {
            this.jcomboMin.setSelectedItem(0);
            this.jcomboMax.setSelectedItem(0);
        }
        return this.panel;
    }
}

