/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels.renderers;

import SocLab.core.EffectNew;
import SocLab.tools.functions.AbstractFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MiniEffectFunctionRenderer
extends JPanel
implements TableCellRenderer {
    private EffectNew effectNew;
    private boolean selected;

    public MiniEffectFunctionRenderer(EffectNew effectNew) {
        this.effectNew = effectNew;
    }

    private void drawDatas(Graphics g, AbstractFunction f, Color c) {
        g.setColor(c);
        double i = this.effectNew.getRelationNew().getRPNInitial().getLowerBound();
        while (i < this.effectNew.getRelationNew().getRPNInitial().getUpperBound()) {
            this.drawALine(g, i);
            i += 0.5;
        }
    }

    private void drawALine(Graphics g, double i) {
        double i2 = i + 0.5;
        double j = this.effectNew.getFunction().getF(i);
        double j2 = this.effectNew.getFunction().getF(i + 0.5);
        int x1 = new Double(Math.round((i + 10.0) * 2.0)).intValue();
        int y1 = new Double((10.0 - j) * 2.0).intValue();
        int x2 = new Double(Math.round((i2 + 10.0) * 2.0)).intValue();
        int y2 = new Double((10.0 - j2) * 2.0).intValue();
        g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paint(Graphics g) {
        this.drawBackground(g);
        if (this.effectNew != null && this.effectNew.getFunction() != null) {
            this.drawDatas(g, this.effectNew.getFunction(), Color.BLACK);
        }
        if (this.selected) {
            g.setColor(Color.blue);
            g.drawRect(0, 0, 40, 40);
        }
    }

    private void drawBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, 41, 41);
        g.setColor(Color.lightGray);
        int i = 0;
        while (i < 41) {
            g.fillRect(i, 0, 1, 1);
            g.fillRect(i, 20, 1, 1);
            g.fillRect(i, 40, 1, 1);
            ++i;
        }
        i = 0;
        while (i < 41) {
            int y1 = i++;
            g.fillRect(0, y1, 1, 1);
            g.fillRect(20, y1, 1, 1);
            g.fillRect(40, y1, 1, 1);
        }
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(41, 41, 1);
        Graphics2D g2d = image.createGraphics();
        this.paint(g2d);
        g2d.dispose();
        return image;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        this.effectNew = (EffectNew)object;
        this.selected = hasFocus;
        return this;
    }
}

