/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.sensiLauncher;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.sensiLauncher.MyThread;
import SocLab.GUI.sensiLauncher.paramsPanels.SensiParamTabbedPane;
import SocLab.GUI.sensiLauncher.paramsPanels.SensiParams;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.tools.RTFReports;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public class GraphicalSensiLauncher
extends JInternalFrame {
    private JComponent currentParamPanel = null;
    public SensiParams sensiParams = new SensiParams(this);
    private JDesktopPane desktop;
    private JPanel orgPanel = new JPanel();
    private JSplitPane listPanel;
    private JPanel controlPanel = new JPanel();
    private SensiParamTabbedPane sensiTabbedPane;
    private JPanel radioPanel = new JPanel(new GridBagLayout());
    private JButton openSensi = new JButton("Open Previous Sensitivity Analysis");
    private JButton runButton = new JButton("Run");
    private JButton viewButton = new JButton("View results");
    private JButton helpButton = new JButton("Help");
    private JButton reportButton = new JButton("Save report");
    private JButton clearReportButton = new JButton("Clear report");
    private JRadioButton firstButton;
    private JRadioButton secondButton;
    private JRadioButton thirdButton;
    private JRadioButton fourthButton;
    private JRadioButton fifthButton;
    private JRadioButton sixthButton;
    private JCheckBox withConstraints;
    private static String first = "Normal Stakes";
    private static String second = "Fuzzy Stakes";
    private static String third = "Normal Solidarities";
    private static String fourth = "Fuzzy Solidarities";
    private static String fifth = "Random parameter values";
    private static String sixth = "Regular parameter values";
    private static boolean isFuzzyStakes = false;
    private static boolean isFuzzySolidarities = false;
    private static boolean isRandom = false;
    private String choosedFilesensi;

    public GraphicalSensiLauncher(JDesktopPane desktop) {
        super("Sensitivity Analysis", true, true, true, true);
        this.setName("Sensitivity Analysis");
        this.setDefaultCloseOperation(1);
        this.setFrameIcon(DesktopFrame.runModelIcon);
        this.desktop = desktop;
        this.sensiTabbedPane = new SensiParamTabbedPane(this, desktop);
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        orgNew.minMaxAims(orgNew.getActorsNew());
        this.controlPanel.setPreferredSize(new Dimension(400, 400));
        this.controlPanel.setLayout(new BorderLayout());
        this.openSensi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.preSimFileChooser.init("Open a Previous Sensitivity Analysis ...", "Select", false);
                int returnVal = DesktopFrame.preSimFileChooser.showOpenDialog(GraphicalSensiLauncher.this.desktop);
                if (returnVal == 0) {
                    RTFReports.sensiSynImages.clear();
                    GraphicalSensiLauncher.this.openPreviousSensitivityAnalysis(DesktopFrame.preSimFileChooser.getSelectedFile());
                }
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.preSimFileChooser.init("choose the folder where you want to save the sensitivity analysis", "Select", true);
                int returnVal = DesktopFrame.preSimFileChooser.showOpenDialog(GraphicalSensiLauncher.this.desktop);
                if (returnVal == 0) {
                    RTFReports.sensiSynImages.clear();
                    GraphicalSensiLauncher.this.choosedFilesensi = DesktopFrame.preSimFileChooser.getSelectedFile().getPath();
                    File f1 = new File(GraphicalSensiLauncher.this.choosedFilesensi);
                    if (!f1.exists()) {
                        f1.mkdirs();
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd_HH.mm");
                    File f2 = new File(String.valueOf(GraphicalSensiLauncher.this.choosedFilesensi) + File.separatorChar + SocLabToolkit.currentOrgNew.getName() + "_Sensitivity_" + sdf.format(new Date()));
                    if (!f2.exists()) {
                        f2.mkdir();
                    }
                    GraphicalSensiLauncher.this.choosedFilesensi = f2.getPath();
                    SocLabToolkit.currentOrgNew.setCurrentSensitivityPath(GraphicalSensiLauncher.this.choosedFilesensi);
                    GraphicalSensiLauncher.this.prerun();
                    DesktopFrame.menuBar.updateMenuVisibility();
                }
            }
        });
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.viewSensitivityResults();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newHelpSensi();
            }
        });
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newSensiRtfReport();
                RTFReports.sensiSynImages.clear();
            }
        });
        this.clearReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RTFReports.sensiSynImages.clear();
            }
        });
        this.firstButton = new JRadioButton(first);
        this.secondButton = new JRadioButton(second);
        this.thirdButton = new JRadioButton(third);
        this.fourthButton = new JRadioButton(fourth);
        this.fifthButton = new JRadioButton(fifth);
        this.sixthButton = new JRadioButton(sixth);
        this.withConstraints = new JCheckBox("with Constraints");
        this.withConstraints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SocLabToolkit.currentOrgNew.setSimuWithConstraints(GraphicalSensiLauncher.this.withConstraints.isSelected());
                ((GraphicalSensiLauncher)GraphicalSensiLauncher.this).sensiTabbedPane.agentParams.calculDistance();
            }
        });
        this.firstButton.setActionCommand(first);
        this.secondButton.setActionCommand(second);
        this.thirdButton.setActionCommand(third);
        this.fourthButton.setActionCommand(fourth);
        this.fifthButton.setActionCommand(fifth);
        this.sixthButton.setActionCommand(sixth);
        this.firstButton.setSelected(true);
        this.thirdButton.setSelected(true);
        this.sixthButton.setSelected(true);
        this.runButton.setIcon(DesktopFrame.runModelIcon);
        this.viewButton.setIcon(DesktopFrame.synthesisIcon);
        this.openSensi.setToolTipText("Open previous Sensitivity Analysis");
        this.runButton.setToolTipText("Run Sensitivity Analysis");
        this.viewButton.setToolTipText("Synthesis of Sensitivity Analysis Results");
        this.fifthButton.setToolTipText("values of parameter are selected at random");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.firstButton);
        group1.add(this.secondButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.thirdButton);
        group2.add(this.fourthButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.fifthButton);
        group3.add(this.sixthButton);
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(first)) {
                    isFuzzyStakes = false;
                } else {
                    isFuzzyStakes = true;
                }
            }
        });
        this.secondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(second)) {
                    isFuzzyStakes = true;
                } else {
                    isFuzzyStakes = false;
                }
            }
        });
        this.thirdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(third)) {
                    isFuzzySolidarities = false;
                } else {
                    isFuzzySolidarities = true;
                }
            }
        });
        this.fourthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(fourth)) {
                    isFuzzySolidarities = true;
                } else {
                    isFuzzySolidarities = false;
                }
            }
        });
        this.fifthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(fifth)) {
                    isRandom = true;
                } else {
                    isRandom = false;
                }
            }
        });
        this.sixthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(sixth)) {
                    isRandom = false;
                } else {
                    isRandom = true;
                }
            }
        });
        JPanel p1 = new JPanel(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.fill = 2;
        cc.anchor = 10;
        cc.gridx = 0;
        cc.gridy = 0;
        p1.add((Component)this.firstButton, cc);
        ++cc.gridy;
        p1.add((Component)this.secondButton, cc);
        ++cc.gridy;
        p1.add((Component)this.thirdButton, cc);
        ++cc.gridy;
        p1.add((Component)this.fourthButton, cc);
        ++cc.gridy;
        p1.add((Component)this.fifthButton, cc);
        ++cc.gridy;
        p1.add((Component)this.sixthButton, cc);
        ++cc.gridy;
        p1.add((Component)this.withConstraints, cc);
        Border border = BorderFactory.createLineBorder(Color.gray, 3);
        p1.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 5, 10, 5);
        c.ipadx = 5;
        c.ipady = 5;
        this.radioPanel.add((Component)p1, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.sensiParams, c);
        ++c.gridy;
        c.insets = new Insets(1, 5, 1, 5);
        this.radioPanel.add((Component)this.openSensi, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.runButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.viewButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.helpButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.reportButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.clearReportButton, c);
        ++c.gridy;
        this.orgPanel.setLayout(new BorderLayout());
        this.orgPanel.add((Component)this.radioPanel, "North");
        this.listPanel = new JSplitPane(1, this.orgPanel, this.controlPanel);
        this.listPanel.setResizeWeight(0.5);
        this.listPanel.setOneTouchExpandable(true);
        this.listPanel.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.orgPanel, "West");
        this.add((Component)this.controlPanel, "Center");
        this.setSize(1150, 500);
    }

    private void openPreviousSensitivityAnalysis(File file) {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            String str = in.readLine();
            String[] tab = new String[9];
            tab = str.split("\t");
            if (tab[0].equals("true")) {
                this.firstButton.setSelected(true);
                this.secondButton.setSelected(false);
            } else {
                this.firstButton.setSelected(false);
                this.secondButton.setSelected(true);
            }
            if (tab[1].equals("true")) {
                this.thirdButton.setSelected(true);
                this.fourthButton.setSelected(false);
            } else {
                this.thirdButton.setSelected(false);
                this.fourthButton.setSelected(true);
            }
            if (tab[2].equals("true")) {
                orgNew.setSimuWithConstraints(true);
            } else {
                orgNew.setSimuWithConstraints(false);
            }
            orgNew.setNbSteps(Integer.parseInt(tab[3]));
            orgNew.setNbRuns(Integer.parseInt(tab[4]));
            orgNew.setNbExperiences(Integer.parseInt(tab[5]));
            int sensiParamsLength = Integer.parseInt(tab[6]);
            int nbActors = Integer.parseInt(tab[7]);
            int nbRelations = Integer.parseInt(tab[8]);
            if (orgNew.getNbActorsNew() == nbActors && orgNew.getNbRelationsNew() == nbRelations) {
                int j;
                boolean exist;
                boolean error = false;
                tab = new String[nbActors];
                str = in.readLine();
                str = in.readLine();
                tab = str.split("\t");
                int i = 0;
                while (i < nbActors) {
                    exist = false;
                    j = 0;
                    while (j < nbActors && !exist) {
                        if (tab[i].equals(orgNew.getActorsNewName()[j])) {
                            exist = true;
                        }
                        ++j;
                    }
                    error = !exist;
                    ++i;
                }
                tab = new String[nbRelations];
                str = in.readLine();
                str = in.readLine();
                tab = str.split("\t");
                if (!error) {
                    i = 0;
                    while (i < nbRelations) {
                        exist = false;
                        j = 0;
                        while (j < nbRelations && !exist) {
                            if (tab[i].equals(orgNew.getRelationsNewName()[j])) {
                                exist = true;
                            }
                            ++j;
                        }
                        error = !exist;
                        ++i;
                    }
                }
                if (!error) {
                    str = in.readLine();
                    str = in.readLine();
                    i = 0;
                    while (i < nbActors) {
                        str = in.readLine();
                        tab = new String[10];
                        tab = str.split("\t");
                        String actorName = tab[0];
                        ActorNew aN = orgNew.getActorNew(actorName);
                        aN.getAPNInitial().setOblivion(Double.valueOf(tab[1]));
                        aN.getAPNInitial().setReward(Double.valueOf(tab[2]));
                        aN.getAPNInitial().setScope(Double.valueOf(tab[3]));
                        aN.getAPNInitial().setTenacity(Double.valueOf(tab[4]));
                        aN.getAPNInitial().setReactivity(Double.valueOf(tab[4]));
                        aN.getAPNInitial().setMoralSensibility(Double.valueOf(tab[4]));
                        aN.getAPNInitial().setActionRange(Double.valueOf(tab[5]));
                        aN.getAPNInitial().setTypeOfRules(Double.valueOf(tab[7]));
                        aN.getAPNInitial().setRepartitionPourcentage(Double.valueOf(tab[8]));
                        ++i;
                    }
                    str = in.readLine();
                    str = in.readLine();
                    i = 0;
                    while (i < nbRelations) {
                        str = in.readLine();
                        tab = new String[4];
                        tab = str.split("\t");
                        String relationName = tab[0];
                        RelationNew rN = orgNew.getRelationNew(relationName);
                        rN.getRPNInitial().setState(Double.valueOf(tab[1]));
                        rN.getRPNInitial().setLowerBound(Double.valueOf(tab[2]));
                        rN.getRPNInitial().setUpperBound(Double.valueOf(tab[3]));
                        ++i;
                    }
                    str = in.readLine();
                    str = in.readLine();
                    String[] sensiParams = new String[sensiParamsLength];
                    int i2 = 0;
                    while (i2 < sensiParamsLength) {
                        ActorNew aN;
                        str = in.readLine();
                        tab = new String[3];
                        tab = str.split("\t");
                        sensiParams[i2] = tab[0];
                        char categorie = sensiParams[i2].charAt(0);
                        String temp = sensiParams[i2].substring(2);
                        String actorName = temp.substring(0, temp.indexOf("."));
                        String parametre = temp.substring(temp.indexOf(".") + 1);
                        if (categorie == '1') {
                            aN = actorName.equals("whole") ? orgNew.getActorNew(orgNew.getActorsNewName()[0]) : orgNew.getActorNew(actorName);
                            if (parametre.equals("Oblivion")) {
                                aN.getAPNCurrentMin().setOblivion(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setOblivion(Double.valueOf(tab[2]));
                            } else if (parametre.equals("Reward")) {
                                aN.getAPNCurrentMin().setReward(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setReward(Double.valueOf(tab[2]));
                            } else if (parametre.equals("Scope")) {
                                aN.getAPNCurrentMin().setScope(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setScope(Double.valueOf(tab[2]));
                            } else if (parametre.equals("Tenacity")) {
                                aN.getAPNCurrentMin().setTenacity(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setTenacity(Double.valueOf(tab[2]));
                            } else if (parametre.equals("Reactivity")) {
                                aN.getAPNCurrentMin().setReactivity(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setReactivity(Double.valueOf(tab[2]));
                            } else if (parametre.equals("GrouIdentif")) {
                                aN.getAPNCurrentMin().setMoralSensibility(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setMoralSensibility(Double.valueOf(tab[2]));
                            } else if (parametre.equals("ActionRange")) {
                                aN.getAPNCurrentMin().setActionRange(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setActionRange(Double.valueOf(tab[2]));
                            } else if (parametre.equals("Percentage")) {
                                aN.getAPNCurrentMin().setRepartitionPourcentage(Double.valueOf(tab[1]));
                                aN.getAPNCurrentMax().setRepartitionPourcentage(Double.valueOf(tab[2]));
                            }
                        } else if (categorie == '2') {
                            aN = orgNew.getActorNew(actorName);
                            RelationNew rN = orgNew.getRelationNew(parametre);
                            aN.getDepend(rN.getName()).setSensibilityAnalysisStakeMin(Double.valueOf(tab[1]));
                            aN.getDepend(rN.getName()).setSensibilityAnalysisStakeMax(Double.valueOf(tab[2]));
                        } else if (categorie == '3') {
                            aN = orgNew.getActorNew(actorName);
                            ActorNew aNt = orgNew.getActorNew(parametre);
                            aN.getTarget(aNt.getName()).setSensibilityAnalysisSolidarityMin(Double.valueOf(tab[1]));
                            aN.getTarget(aNt.getName()).setSensibilityAnalysisSolidarityMax(Double.valueOf(tab[2]));
                        }
                        ++i2;
                    }
                    str = in.readLine();
                    str = in.readLine();
                    String description = "";
                    while (!str.equals(" - - - - - - - - - - ")) {
                        description = String.valueOf(description) + str;
                        str = in.readLine();
                    }
                    orgNew.setSimuDescription(description);
                    orgNew.setCurrentSensitivityPath(file.getParent());
                    DesktopFrame.sensiLauncher.update();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prerun() {
        MyThread mt = new MyThread(this.desktop, isFuzzyStakes, isFuzzySolidarities, isRandom);
        mt.start();
    }

    private void switchPanel(JComponent component) {
        if (this.currentParamPanel != null) {
            this.controlPanel.remove(this.currentParamPanel);
        }
        this.currentParamPanel = component;
        this.controlPanel.add((Component)this.currentParamPanel, "Center");
        this.currentParamPanel.paintAll(this.currentParamPanel.getGraphics());
    }

    public void update() {
        this.sensiTabbedPane.initValues();
        if (SocLabToolkit.currentOrgNew != null) {
            OrgNew orgNew = SocLabToolkit.currentOrgNew;
            this.withConstraints.setSelected(SocLabToolkit.currentOrgNew.getSimuWithConstraints());
            this.setTitle("Model > " + orgNew.getName());
            this.switchPanel(this.sensiTabbedPane);
            this.switchLanguage();
        }
    }

    public void switchLanguage() {
        this.runButton.setText(SwitchLanguages.GraphicalSensiLauncherButtonRun[SocLabToolkit.idLanguage]);
        this.runButton.setToolTipText(SwitchLanguages.GraphicalSensiLauncherButtonRunTooltip[SocLabToolkit.idLanguage]);
        this.viewButton.setText(SwitchLanguages.GraphicalSensiLauncherButtonSynthesis[SocLabToolkit.idLanguage]);
        this.viewButton.setToolTipText(SwitchLanguages.GraphicalSensiLauncherButtonSynthesisTooltip[SocLabToolkit.idLanguage]);
        this.reportButton.setText(SwitchLanguages.GraphicalSensiLauncherButtonReport[SocLabToolkit.idLanguage]);
        this.firstButton.setText(SwitchLanguages.GraphicalSensiLauncherRadioButtonfirst[SocLabToolkit.idLanguage]);
        this.secondButton.setText(SwitchLanguages.GraphicalSensiLauncherRadioButtonsecond[SocLabToolkit.idLanguage]);
        this.thirdButton.setText(SwitchLanguages.GraphicalSensiLauncherRadioButtonthird[SocLabToolkit.idLanguage]);
        this.fourthButton.setText(SwitchLanguages.GraphicalSensiLauncherRadioButtonfourth[SocLabToolkit.idLanguage]);
        this.setTitle(SwitchLanguages.GraphicalSensiLauncherTitle[SocLabToolkit.idLanguage]);
        this.setName(SwitchLanguages.GraphicalSensiLauncherTitle[SocLabToolkit.idLanguage]);
        this.sensiTabbedPane.switchLanguage();
    }
}

