/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.sensiLauncher;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.sensiLauncher.SensitivityProgressBar;
import SocLab.GUI.simuLauncher.SimulationProgressBar;
import SocLab.GUI.simuLauncher.waitingWindows;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.Simu;
import SocLab.core.SocLabToolkit;
import SocLab.tools.arrayKit.ArrayKit;
import controller.sensitivity.ControllerImpl;
import input.WrongFormException;
import input.sensitivity.RawResultImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import org.apache.commons.math.stat.StatUtils;

class MyThread
extends Thread {
    private boolean isFuzzyStakes;
    private boolean isFuzzySolidarities;
    private boolean isRandom;
    private double[] savedMeanSAT;
    private double[] savedMeanINF;
    private double[] savedMeanAIM;
    private double[] savedMeanTE;
    private String tempSimuPath;

    MyThread(JDesktopPane desktop, boolean ifst, boolean ifso, boolean isrd) {
        this.isFuzzyStakes = ifst;
        this.isFuzzySolidarities = ifso;
        this.isRandom = isrd;
    }

    @Override
    public void run() {
        ActorNew aN;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        this.tempSimuPath = orgNew.getCurrentSimulationPath();
        int nb_exp = orgNew.getNbExperiences();
        String[] actors = orgNew.getActorsNewName();
        String plan = String.valueOf(orgNew.getCurrentSensitivityPath()) + File.separatorChar + "PlanExp_" + orgNew.getName() + "_" + ".txt";
        this.savePlanExp(orgNew, plan);
        this.saveSensitivityParameters(orgNew);
        int i = 0;
        while (i < orgNew.getNbActorsNew()) {
            aN = orgNew.getActorNew(actors[i]);
            int j = 0;
            while (j < aN.getNbDependRelations()) {
                aN.getDependRelations().elementAt((int)j).tempStake = aN.getDependRelations().elementAt(j).getStake();
                ++j;
            }
            j = 0;
            while (j < aN.getNbTargets()) {
                aN.getTargets().elementAt((int)j).tempSolidarity = aN.getTargets().elementAt(j).getSolidarity();
                ++j;
            }
            ++i;
        }
        if (DesktopFrame.spb == null) {
            DesktopFrame.spb = new SensitivityProgressBar();
            DesktopFrame.desktopPanel.add(DesktopFrame.spb);
        }
        DesktopFrame.spb.init(nb_exp);
        i = 0;
        while (i < DesktopFrame.getFrames().length) {
            DesktopFrame.getFrames()[i].setEnabled(false);
            ++i;
        }
        int exps = 0;
        while (exps < nb_exp) {
            DesktopFrame.spb.updateCurrentExp(exps);
            String[] params = orgNew.getSensitivityParameters();
            int j = 0;
            while (j < params.length) {
                double y;
                char categorie = params[j].charAt(0);
                String temp = params[j].substring(2);
                String actorName = temp.substring(0, temp.indexOf("."));
                String parametre = temp.substring(temp.indexOf(".") + 1);
                if (categorie == '1') {
                    double minV;
                    double maxV;
                    aN = actorName.equals("whole") ? orgNew.getActorNew(actors[0]) : orgNew.getActorNew(actorName);
                    if (parametre.equals("Oblivion")) {
                        maxV = aN.getAPNCurrentMax().getOblivion();
                        minV = aN.getAPNCurrentMin().getOblivion();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setOblivion(valueParam);
                    } else if (parametre.equals("Reward")) {
                        maxV = aN.getAPNCurrentMax().getReward();
                        minV = aN.getAPNCurrentMin().getReward();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setReward(valueParam);
                    } else if (parametre.equals("Scope")) {
                        maxV = aN.getAPNCurrentMax().getScope();
                        minV = aN.getAPNCurrentMin().getScope();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setScope(Math.round(valueParam));
                    } else if (parametre.equals("Tenacity")) {
                        maxV = aN.getAPNCurrentMax().getTenacity();
                        minV = aN.getAPNCurrentMin().getTenacity();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setTenacity(Math.round(valueParam));
                    } else if (parametre.equals("GroupIdentif")) {
                        maxV = aN.getAPNCurrentMax().getMoralSensibility();
                        minV = aN.getAPNCurrentMin().getMoralSensibility();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setMoralSensibility(valueParam);
                    } else if (parametre.equals("ActionRange")) {
                        maxV = aN.getAPNCurrentMax().getActionRange();
                        minV = aN.getAPNCurrentMin().getActionRange();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setActionRange(valueParam);
                    } else if (parametre.equals("Percentage")) {
                        maxV = aN.getAPNCurrentMax().getRepartitionPourcentage();
                        minV = aN.getAPNCurrentMin().getRepartitionPourcentage();
                        double valueParam = this.isRandom ? minV + (maxV - minV) * Math.random() : (maxV - minV) * (double)exps / (double)(nb_exp - 1) + minV;
                        aN.getAPNInitial().setRepartitionPourcentage(valueParam);
                    }
                    if (actorName.equals("whole")) {
                        ActorNew aN0 = aN;
                        int actID = 1;
                        while (actID < actors.length) {
                            aN = orgNew.getActorNew(actors[actID]);
                            if (parametre.equals("Oblivion")) {
                                aN.getAPNInitial().setOblivion(aN0.getAPNInitial().getOblivion());
                            } else if (parametre.equals("Reward")) {
                                aN.getAPNInitial().setReward(aN0.getAPNInitial().getReward());
                            } else if (parametre.equals("Scope")) {
                                aN.getAPNInitial().setScope(aN0.getAPNInitial().getScope());
                            } else if (parametre.equals("Tenacity")) {
                                aN.getAPNInitial().setTenacity(aN0.getAPNInitial().getTenacity());
                            } else if (parametre.equals("MoralSensibility")) {
                                aN.getAPNInitial().setMoralSensibility(aN0.getAPNInitial().getMoralSensibility());
                            } else if (parametre.equals("ActionRange")) {
                                aN.getAPNInitial().setActionRange(aN0.getAPNInitial().getActionRange());
                            } else if (parametre.equals("Percentage")) {
                                aN.getAPNInitial().setRepartitionPourcentage(aN0.getAPNInitial().getRepartitionPourcentage());
                            }
                            ++actID;
                        }
                    }
                } else if (categorie == '2') {
                    aN = orgNew.getActorNew(actorName);
                    RelationNew rN = orgNew.getRelationNew(parametre);
                    if (exps == 0) {
                        aN.getDepend(rN.getName()).setStake(aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMin());
                    } else if (exps == 1) {
                        aN.getDepend(rN.getName()).setStake(aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMax());
                    } else {
                        double x = aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMin();
                        y = aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMax();
                        double z = (y - x) * Math.random();
                        aN.getDepend(rN.getName()).setStake(Double.valueOf((int)((z + x) * 100.0)) / 100.0);
                    }
                    double variation = aN.getDepend((String)rN.getName()).tempStake - aN.getDepend(rN.getName()).getStake();
                    double sumStakes = 10.0 - aN.getDepend((String)rN.getName()).tempStake;
                    int i2 = 0;
                    while (i2 < orgNew.getNbRelationsNew()) {
                        RelationNew rN2 = orgNew.getRelationNew(orgNew.getRelationsNewName()[i2]);
                        if (!rN2.getName().equals(rN.getName())) {
                            double IS = aN.getDepend((String)rN2.getName()).tempStake;
                            aN.getDepend(rN2.getName()).setStake(IS + IS / sumStakes * variation);
                        }
                        ++i2;
                    }
                } else if (categorie == '3') {
                    aN = orgNew.getActorNew(actorName);
                    ActorNew aNt = orgNew.getActorNew(parametre);
                    if (exps == 0) {
                        aN.getTarget(aNt.getName()).setSolidarity(aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMin());
                    } else if (exps == 1) {
                        aN.getTarget(aNt.getName()).setSolidarity(aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMax());
                    } else {
                        double x = aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMin();
                        y = aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMax();
                        double z = (y - x) * Math.random();
                        aN.getTarget(aNt.getName()).setSolidarity(Double.valueOf((int)((z + x) * 100.0)) / 100.0);
                    }
                }
                ++j;
            }
            String param = String.valueOf(orgNew.getCurrentSensitivityPath()) + File.separatorChar + "param_exp" + exps + ".txt";
            this.saveExpExp(orgNew, param, exps);
            this.performOneExperiment(exps);
            param = String.valueOf(orgNew.getCurrentSensitivityPath()) + File.separatorChar + "results_exp" + exps + ".txt";
            this.saveResultsExpFile(orgNew, this.savedMeanSAT, this.savedMeanINF, this.savedMeanAIM, this.savedMeanTE, param);
            ++exps;
        }
        try {
            this.saveSensitivityResult();
        }
        catch (WrongFormException e) {
            e.printStackTrace();
        }
        i = 0;
        while (i < orgNew.getNbActorsNew()) {
            aN = orgNew.getActorNew(orgNew.getActorsNewName()[i]);
            int j = 0;
            while (j < aN.getNbDependRelations()) {
                aN.getDependRelations().elementAt(j).setStake(aN.getDependRelations().elementAt((int)j).tempStake);
                ++j;
            }
            j = 0;
            while (j < aN.getNbTargets()) {
                aN.getTargets().elementAt(j).setSolidarity(aN.getTargets().elementAt((int)j).tempSolidarity);
                ++j;
            }
            ++i;
        }
        orgNew.setCurrentSimulationPath(this.tempSimuPath);
        if (DesktopFrame.smb == null) {
            DesktopFrame.smb = new SimulationProgressBar();
            DesktopFrame.desktopPanel.add(DesktopFrame.smb);
        }
        DesktopFrame.spb.setVisible(false);
        DesktopFrame.smb.setVisible(false);
        i = 0;
        while (i < DesktopFrame.getFrames().length) {
            DesktopFrame.getFrames()[i].setEnabled(true);
            ++i;
        }
    }

    private void performOneExperiment(int exp) {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        orgNew.setCurrentSimulationPath(String.valueOf(orgNew.getCurrentSensitivityPath()) + File.separatorChar + String.valueOf(exp));
        if (DesktopFrame.ww == null) {
            DesktopFrame.ww = new waitingWindows();
            DesktopFrame.desktopPanel.add(DesktopFrame.ww);
        }
        orgNew.minMaxAims(orgNew.getActorsNew());
        int nb_runs = orgNew.getNbRuns();
        int nb_step = orgNew.getNbSteps();
        this.saveSimulationParameters(orgNew);
        boolean[] convergedSimulation = new boolean[nb_runs];
        double[][] savedFinalSAT = new double[orgNew.getNbActorsNew()][nb_runs];
        double[][] savedFinalINF = new double[orgNew.getNbActorsNew()][nb_runs];
        double[][] savedFinalAIM = new double[orgNew.getNbActorsNew()][nb_runs];
        double[][] savedFinalSeuilSAT = new double[orgNew.getNbActorsNew()][nb_runs];
        this.savedMeanSAT = new double[orgNew.getNbActorsNew()];
        this.savedMeanINF = new double[orgNew.getNbActorsNew()];
        this.savedMeanAIM = new double[orgNew.getNbActorsNew()];
        double[] savedMeanSeuilSAT = new double[orgNew.getNbActorsNew()];
        double[] savedStandevSAT = new double[orgNew.getNbActorsNew()];
        double[] savedStandevINF = new double[orgNew.getNbActorsNew()];
        double[] savedStandevAIM = new double[orgNew.getNbActorsNew()];
        double[] savedStandevSeuilSAT = new double[orgNew.getNbActorsNew()];
        double[][] savedFinalTE = new double[orgNew.getNbRelationsNew()][nb_runs];
        this.savedMeanTE = new double[orgNew.getNbRelationsNew()];
        double[] savedMedianTE = new double[orgNew.getNbRelationsNew()];
        double[] savedStandevTE = new double[orgNew.getNbRelationsNew()];
        double[] savedConv = new double[nb_runs];
        SocLabToolkit.currentOrgNew.nbStepConvergence = new String[nb_runs][3];
        SocLabToolkit.currentOrgNew.headNbEtapesNec = 0;
        if (DesktopFrame.smb == null) {
            DesktopFrame.smb = new SimulationProgressBar();
            DesktopFrame.desktopPanel.add(DesktopFrame.smb);
        }
        DesktopFrame.smb.init(nb_runs);
        int runs = 0;
        while (runs < nb_runs) {
            ActorNew aN;
            int i;
            String[] aNames;
            DesktopFrame.smb.updateCurrentRun(runs);
            Simu simu = new Simu(orgNew);
            orgNew.reset();
            if (this.isFuzzyStakes && orgNew != null) {
                aNames = orgNew.getActorsNewName();
                i = 0;
                while (i < aNames.length) {
                    aN = orgNew.getActorNew(aNames[i]);
                    orgNew.initStakesInFuzzyMode(aN);
                    ++i;
                }
            }
            if (this.isFuzzySolidarities && orgNew != null) {
                aNames = orgNew.getActorsNewName();
                i = 0;
                while (i < aNames.length) {
                    aN = orgNew.getActorNew(aNames[i]);
                    orgNew.initSolidaritiesInFuzzyMode(aN);
                    ++i;
                }
            }
            double[][] savedSAT = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] savedINF = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] savedAIM = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] savedSeuilSAT = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] effect_rules = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] savedTE = new double[orgNew.getNbRelationsNew()][nb_step + 1];
            int step = 0;
            SocLabToolkit.currentOrgNew.incoherent = false;
            step = 0;
            while (step < nb_step) {
                String[] aNames2 = orgNew.getActorsNewName();
                int actId = 0;
                while (actId < orgNew.getNbActorsNew()) {
                    savedSAT[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames2[actId]).getActualSatisfaction(), 1);
                    savedSeuilSAT[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames2[actId]).getAmbition(), 1);
                    savedINF[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames2[actId]).getAccumulatedActualInfluence(), 1);
                    savedAIM[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames2[actId]).getActualAim(), 1);
                    ++actId;
                }
                String[] rNames = orgNew.getRelationsNewName();
                int i2 = 0;
                while (i2 < rNames.length) {
                    RelationNew rN = orgNew.getRelationNew(rNames[i2]);
                    savedTE[i2][step] = rN.getRPNCurrent().getState();
                    ++i2;
                }
                if (orgNew.allActorSatisfied()) {
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][0] = new String(String.valueOf(runs));
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][1] = "Oui";
                    convergedSimulation[runs] = true;
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][2] = new String(String.valueOf(step));
                    ++SocLabToolkit.currentOrgNew.headNbEtapesNec;
                    break;
                }
                simu.step();
                if (orgNew.incoherent) {
                    DesktopFrame.statusBar.setText("Model incoherent, Simulation has been stopped ...");
                    step = nb_step;
                    break;
                }
                if (step == nb_step - 1) {
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][0] = new String(String.valueOf(runs));
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][1] = "Non";
                    convergedSimulation[runs] = false;
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][2] = new String(String.valueOf(nb_step));
                    ++SocLabToolkit.currentOrgNew.headNbEtapesNec;
                }
                ++step;
            }
            if (orgNew.incoherent) {
                runs = nb_runs;
                break;
            }
            if (step == nb_step) {
                String[] aNames3 = orgNew.getActorsNewName();
                int actId = 0;
                while (actId < orgNew.getNbActorsNew()) {
                    savedSAT[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames3[actId]).getActualSatisfaction(), 2);
                    savedINF[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames3[actId]).getAccumulatedActualInfluence(), 2);
                    savedAIM[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames3[actId]).getActualAim(), 2);
                    savedSeuilSAT[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames3[actId]).getAmbition(), 2);
                    ++actId;
                }
            }
            int actId = 0;
            while (actId < orgNew.getNbActorsNew()) {
                savedFinalSAT[actId][runs] = savedSAT[actId][step];
                savedFinalINF[actId][runs] = savedINF[actId][step];
                savedFinalAIM[actId][runs] = savedAIM[actId][step];
                savedFinalSeuilSAT[actId][runs] = savedSeuilSAT[actId][step];
                ++actId;
            }
            int relId = 0;
            while (relId < orgNew.getNbRelationsNew()) {
                savedFinalTE[relId][runs] = savedTE[relId][step];
                ++relId;
            }
            savedConv[runs] = step;
            savedTE = ArrayKit.reduce(savedTE, step + 1);
            savedSAT = ArrayKit.reduce(savedSAT, step + 1);
            savedINF = ArrayKit.reduce(savedINF, step + 1);
            savedAIM = ArrayKit.reduce(savedAIM, step + 1);
            savedSeuilSAT = ArrayKit.reduce(savedSeuilSAT, step + 1);
            effect_rules = ArrayKit.reduce(effect_rules, step);
            this.saveRawResults(orgNew, runs, step, savedSAT, savedSeuilSAT, savedINF, savedAIM, savedTE);
            ++runs;
        }
        int actId = 0;
        while (actId < orgNew.getNbActorsNew()) {
            this.savedMeanSAT[actId] = this.getMeanValueForConvergedSimulation(savedFinalSAT[actId], convergedSimulation);
            savedMeanSeuilSAT[actId] = this.getMeanValueForConvergedSimulation(savedFinalSeuilSAT[actId], convergedSimulation);
            this.savedMeanINF[actId] = this.getMeanValueForConvergedSimulation(savedFinalINF[actId], convergedSimulation);
            this.savedMeanAIM[actId] = this.getMeanValueForConvergedSimulation(savedFinalAIM[actId], convergedSimulation);
            savedStandevSAT[actId] = Math.sqrt(StatUtils.variance((double[])savedFinalSAT[actId]));
            savedStandevSeuilSAT[actId] = Math.sqrt(StatUtils.variance((double[])savedFinalSeuilSAT[actId]));
            savedStandevINF[actId] = Math.sqrt(StatUtils.variance((double[])savedFinalINF[actId]));
            savedStandevAIM[actId] = Math.sqrt(StatUtils.variance((double[])savedFinalAIM[actId]));
            ++actId;
        }
        int relId = 0;
        while (relId < orgNew.getNbRelationsNew()) {
            this.savedMeanTE[relId] = this.getMeanValueForConvergedSimulation(savedFinalTE[relId], convergedSimulation);
            savedMedianTE[relId] = StatUtils.percentile((double[])savedFinalTE[relId], (double)50.0);
            savedStandevTE[relId] = Math.sqrt(StatUtils.variance((double[])savedFinalTE[relId]));
            ++relId;
        }
        StatUtils.mean((double[])savedConv);
        StatUtils.variance((double[])savedConv);
        if (SocLabToolkit.currentOrgNew.incoherent) {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Model incoherent, Simulation has been stopped ...", "Error", -1);
        }
    }

    public double getMeanValueForConvergedSimulation(double[] arrayValue, boolean[] cS) {
        double somme = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < arrayValue.length) {
            if (cS[i]) {
                somme += arrayValue[i];
                count += 1.0;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return somme / count;
    }

    private void saveSensitivityParameters(OrgNew orgNew) {
        String path = SocLabToolkit.currentOrgNew.getCurrentSensitivityPath();
        File daPath = new File(path);
        if (!daPath.isDirectory()) {
            daPath.mkdirs();
        }
        String file = String.valueOf(path) + File.separatorChar + orgNew.getName() + "_SensitivityInitialParameters" + ".xls";
        String[] actorNames = orgNew.getActorsNewName();
        String[] relationNames = orgNew.getRelationsNewName();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            ostream.write(new String(String.valueOf(String.valueOf(!this.isFuzzyStakes)) + "\t").getBytes());
            ostream.write(new String(String.valueOf(String.valueOf(!this.isFuzzySolidarities)) + "\t").getBytes());
            ostream.write(new String(String.valueOf(String.valueOf(orgNew.getSimuWithConstraints())) + "\t").getBytes());
            ostream.write(new String(String.valueOf(orgNew.getNbSteps()) + "\t" + orgNew.getNbRuns() + "\t" + orgNew.getNbExperiences() + "\t" + orgNew.getSensitivityParameters().length + "\t" + orgNew.getNbActorsNew() + "\t" + orgNew.getNbRelationsNew() + "\n\n").getBytes());
            int i = 0;
            while (i < actorNames.length) {
                if (i < actorNames.length - 1) {
                    ostream.write(new String(String.valueOf(actorNames[i]) + "\t").getBytes());
                } else {
                    ostream.write(new String(String.valueOf(actorNames[i]) + "\n\n").getBytes());
                }
                ++i;
            }
            i = 0;
            while (i < relationNames.length) {
                if (i < relationNames.length - 1) {
                    ostream.write(new String(String.valueOf(relationNames[i]) + "\t").getBytes());
                } else {
                    ostream.write(new String(String.valueOf(relationNames[i]) + "\n\n").getBytes());
                }
                ++i;
            }
            ostream.write("Actors\t".getBytes());
            ostream.write("Oblivion\t".getBytes());
            ostream.write("Reward\t".getBytes());
            ostream.write("Scope\t".getBytes());
            ostream.write("Tenacity\t".getBytes());
            ostream.write("Reactivity\t".getBytes());
            ostream.write("MoralSensibility\t".getBytes());
            ostream.write("ActionRange\t".getBytes());
            ostream.write("Evaluation\t".getBytes());
            ostream.write("TypeOfRules\t".getBytes());
            ostream.write("Percentage\n".getBytes());
            i = 0;
            while (i < actorNames.length) {
                ActorNew aN = orgNew.getActorNew(actorNames[i]);
                ostream.write(actorNames[i].getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getOblivion()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getReward()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getScope()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getTenacity()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getReactivity()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getMoralSensibility()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getActionRange()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getEvaluationCriterium()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getTypeOfRules()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getRepartitionPourcentage()).getBytes());
                ostream.write("\n".getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write("Relations\t".getBytes());
            ostream.write("State\t".getBytes());
            ostream.write("LowerBound\t".getBytes());
            ostream.write("UpperBound\n".getBytes());
            i = 0;
            while (i < relationNames.length) {
                RelationNew rN = orgNew.getRelationNew(relationNames[i]);
                ostream.write(relationNames[i].getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getState()).getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getLowerBound()).getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getUpperBound()).getBytes());
                ostream.write("\n".getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write("Parameters\t".getBytes());
            ostream.write("Min\t".getBytes());
            ostream.write("Max\n".getBytes());
            i = 0;
            while (i < orgNew.getSensitivityParameters().length) {
                ActorNew aN;
                ostream.write(new String(String.valueOf(orgNew.getSensitivityParameters()[i]) + "\t").getBytes());
                char categorie = orgNew.getSensitivityParameters()[i].charAt(0);
                String temp = orgNew.getSensitivityParameters()[i].substring(2);
                String actorName = temp.substring(0, temp.indexOf("."));
                String parametre = temp.substring(temp.indexOf(".") + 1);
                if (categorie == '1') {
                    aN = actorName.equals("whole") ? orgNew.getActorNew(actorNames[0]) : orgNew.getActorNew(actorName);
                    if (parametre.equals("Oblivion")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getOblivion()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getOblivion()) + "\n").getBytes());
                    } else if (parametre.equals("Reward")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getReward()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getReward()) + "\n").getBytes());
                    } else if (parametre.equals("Scope")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getScope()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getScope()) + "\n").getBytes());
                    } else if (parametre.equals("Tenacity")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getTenacity()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getTenacity()) + "\n").getBytes());
                    } else if (parametre.equals("Reactivity")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getReactivity()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getReactivity()) + "\n").getBytes());
                    } else if (parametre.equals("MoralSensibility")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getMoralSensibility()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getMoralSensibility()) + "\n").getBytes());
                    } else if (parametre.equals("ActionRange")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getActionRange()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getActionRange()) + "\n").getBytes());
                    } else if (parametre.equals("Percentage")) {
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMin().getRepartitionPourcentage()) + "\t").getBytes());
                        ostream.write(new String(String.valueOf(aN.getAPNCurrentMax().getRepartitionPourcentage()) + "\n").getBytes());
                    }
                } else if (categorie == '2') {
                    aN = orgNew.getActorNew(actorName);
                    RelationNew rN = orgNew.getRelationNew(parametre);
                    ostream.write(new String(String.valueOf(aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMin()) + "\t").getBytes());
                    ostream.write(new String(String.valueOf(aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMax()) + "\n").getBytes());
                } else if (categorie == '3') {
                    aN = orgNew.getActorNew(actorName);
                    ActorNew aNt = orgNew.getActorNew(parametre);
                    ostream.write(new String(String.valueOf(aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMin()) + "\t").getBytes());
                    ostream.write(new String(String.valueOf(aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMax()) + "\n").getBytes());
                }
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write(orgNew.getSensiDescription().getBytes());
            ostream.write(" - - - - - - - - - - ".getBytes());
            ostream.flush();
            ostream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSimulationParameters(OrgNew orgNew) {
        String path = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        File daPath = new File(path);
        if (!daPath.isDirectory()) {
            daPath.mkdirs();
        }
        String file = String.valueOf(path) + File.separatorChar + orgNew.getName() + "_SimulationInitialParameters" + ".xls";
        String[] actorNames = orgNew.getActorsNewName();
        String[] relationNames = orgNew.getRelationsNewName();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            ostream.write(new String(String.valueOf(String.valueOf(!this.isFuzzyStakes)) + "\t").getBytes());
            ostream.write(new String(String.valueOf(String.valueOf(!this.isFuzzySolidarities)) + "\t").getBytes());
            ostream.write(new String(String.valueOf(String.valueOf(orgNew.getSimuWithConstraints())) + "\t").getBytes());
            ostream.write(new String(String.valueOf(orgNew.getNbSteps()) + "\t" + orgNew.getNbRuns() + "\t" + orgNew.getNbActorsNew() + "\t" + orgNew.getNbRelationsNew() + "\n\n").getBytes());
            int i = 0;
            while (i < actorNames.length) {
                if (i < actorNames.length - 1) {
                    ostream.write(new String(String.valueOf(actorNames[i]) + "\t").getBytes());
                } else {
                    ostream.write(new String(String.valueOf(actorNames[i]) + "\n\n").getBytes());
                }
                ++i;
            }
            i = 0;
            while (i < relationNames.length) {
                if (i < relationNames.length - 1) {
                    ostream.write(new String(String.valueOf(relationNames[i]) + "\t").getBytes());
                } else {
                    ostream.write(new String(String.valueOf(relationNames[i]) + "\n\n").getBytes());
                }
                ++i;
            }
            ostream.write("Actors\t".getBytes());
            ostream.write("Oblivion\t".getBytes());
            ostream.write("Reward\t".getBytes());
            ostream.write("Scope\t".getBytes());
            ostream.write("Tenacity\t".getBytes());
            ostream.write("Reactivity\t".getBytes());
            ostream.write("MoralSensibility\t".getBytes());
            ostream.write("ActionRange\t".getBytes());
            ostream.write("Evaluation\t".getBytes());
            ostream.write("TypeOfRules\t".getBytes());
            ostream.write("Percentage\n".getBytes());
            i = 0;
            while (i < actorNames.length) {
                ActorNew aN = orgNew.getActorNew(actorNames[i]);
                ostream.write(actorNames[i].getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getOblivion()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getReward()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getScope()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getTenacity()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getReactivity()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getMoralSensibility()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getActionRange()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getEvaluationCriterium()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getTypeOfRules()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getRepartitionPourcentage()).getBytes());
                ostream.write("\n".getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write("Relations\t".getBytes());
            ostream.write("State\t".getBytes());
            ostream.write("LowerBound\t".getBytes());
            ostream.write("UpperBound\n".getBytes());
            i = 0;
            while (i < relationNames.length) {
                RelationNew rN = orgNew.getRelationNew(relationNames[i]);
                ostream.write(relationNames[i].getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getState()).getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getLowerBound()).getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getUpperBound()).getBytes());
                ostream.write("\n".getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write(orgNew.getSimuDescription().getBytes());
            ostream.write(" - - - - - - - - - - ".getBytes());
            ostream.flush();
            ostream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveRawResults(OrgNew orgNew, int runId, int step, double[][] savedSAT, double[][] savedSeuilSAT, double[][] savedINF, double[][] savedAIM, double[][] savedTE) {
        String path = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        File daPath = new File(path);
        if (!daPath.isDirectory()) {
            daPath.mkdirs();
        }
        String file = String.valueOf(path) + File.separatorChar + "results_" + orgNew.getName() + "_" + runId + ".xls";
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            int i;
            boolean convergence;
            ostream.write(new String(String.valueOf(orgNew.getName()) + "\n\n").getBytes());
            ostream.write(new String(runId + "\n\n").getBytes());
            ostream.write(new String("1\t" + orgNew.getNbActorsNew() + "\t" + orgNew.getNbRelationsNew() + "\t" + 4 + "\t" + 1 + "\t" + 4 + "\t" + 1 + "\n\n").getBytes());
            ostream.write("nb_step\n".getBytes());
            ostream.write("\n".getBytes());
            int i2 = 0;
            while (i2 < orgNew.getNbActorsNew()) {
                ostream.write(new String(String.valueOf(orgNew.getActorsNewName()[i2]) + "\n").getBytes());
                ++i2;
            }
            ostream.write("\n".getBytes());
            i2 = 0;
            while (i2 < orgNew.getNbRelationsNew()) {
                ostream.write(new String(String.valueOf(orgNew.getRelationsNewName()[i2]) + "\n").getBytes());
                ++i2;
            }
            ostream.write("\n".getBytes());
            ostream.write("Satisfaction\n".getBytes());
            ostream.write("SeuilSatisfaction\n".getBytes());
            ostream.write("Influence\n".getBytes());
            ostream.write("Aim\n".getBytes());
            ostream.write("\n".getBytes());
            ostream.write("State\n".getBytes());
            ostream.write("\n".getBytes());
            ostream.write("Satisfaction_Step\n".getBytes());
            ostream.write("SeuilSatisfaction_Step\n".getBytes());
            ostream.write("Influence_Step\n".getBytes());
            ostream.write("Aim_Step\n".getBytes());
            ostream.write("\n".getBytes());
            ostream.write("State_Step\n".getBytes());
            ostream.write("\n".getBytes());
            boolean bl = convergence = step < SocLabToolkit.currentOrgNew.getNbSteps() - 1;
            if (convergence) {
                ostream.write("o".getBytes());
            } else {
                ostream.write("n".getBytes());
            }
            ostream.write("\n\n".getBytes());
            ostream.write(new String(step + "\n").getBytes());
            ostream.write("\n".getBytes());
            int i3 = 0;
            while (i3 < orgNew.getNbActorsNew()) {
                if (i3 < orgNew.getNbActorsNew() - 1) {
                    ostream.write(new String(String.valueOf(savedSAT[i3][step]) + "\t").getBytes());
                } else {
                    ostream.write(new String("" + savedSAT[i3][step]).getBytes());
                }
                ++i3;
            }
            ostream.write("\n\n".getBytes());
            i3 = 0;
            while (i3 < orgNew.getNbActorsNew()) {
                if (i3 < orgNew.getNbActorsNew() - 1) {
                    ostream.write(new String(String.valueOf(savedSeuilSAT[i3][step]) + "\t").getBytes());
                } else {
                    ostream.write(new String("" + savedSeuilSAT[i3][step]).getBytes());
                }
                ++i3;
            }
            ostream.write("\n\n".getBytes());
            i3 = 0;
            while (i3 < orgNew.getNbActorsNew()) {
                if (i3 < orgNew.getNbActorsNew() - 1) {
                    ostream.write(new String(String.valueOf(savedINF[i3][step]) + "\t").getBytes());
                } else {
                    ostream.write(new String("" + savedINF[i3][step]).getBytes());
                }
                ++i3;
            }
            ostream.write("\n\n".getBytes());
            i3 = 0;
            while (i3 < orgNew.getNbActorsNew()) {
                if (i3 < orgNew.getNbActorsNew() - 1) {
                    ostream.write(new String(String.valueOf(savedAIM[i3][step]) + "\t").getBytes());
                } else {
                    ostream.write(new String("" + savedAIM[i3][step]).getBytes());
                }
                ++i3;
            }
            ostream.write("\n\n".getBytes());
            i3 = 0;
            while (i3 < orgNew.getNbRelationsNew()) {
                if (i3 < orgNew.getNbRelationsNew() - 1) {
                    ostream.write(new String(String.valueOf(savedTE[i3][step]) + "\t").getBytes());
                } else {
                    ostream.write(new String("" + savedTE[i3][step]).getBytes());
                }
                ++i3;
            }
            ostream.write("\n\n".getBytes());
            int s = 0;
            while (s <= step) {
                i = 0;
                while (i < orgNew.getNbActorsNew()) {
                    if (i < orgNew.getNbActorsNew() - 1) {
                        ostream.write(new String(String.valueOf(savedSAT[i][s]) + "\t").getBytes());
                    } else {
                        ostream.write(new String("" + savedSAT[i][s]).getBytes());
                    }
                    ++i;
                }
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            s = 0;
            while (s <= step) {
                i = 0;
                while (i < orgNew.getNbActorsNew()) {
                    if (i < orgNew.getNbActorsNew() - 1) {
                        ostream.write(new String(String.valueOf(savedSeuilSAT[i][s]) + "\t").getBytes());
                    } else {
                        ostream.write(new String("" + savedSeuilSAT[i][s]).getBytes());
                    }
                    ++i;
                }
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            s = 0;
            while (s <= step) {
                i = 0;
                while (i < orgNew.getNbActorsNew()) {
                    if (i < orgNew.getNbActorsNew() - 1) {
                        ostream.write(new String(String.valueOf(savedINF[i][s]) + "\t").getBytes());
                    } else {
                        ostream.write(new String("" + savedINF[i][s]).getBytes());
                    }
                    ++i;
                }
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            s = 0;
            while (s <= step) {
                i = 0;
                while (i < orgNew.getNbActorsNew()) {
                    if (i < orgNew.getNbActorsNew() - 1) {
                        ostream.write(new String(String.valueOf(savedAIM[i][s]) + "\t").getBytes());
                    } else {
                        ostream.write(new String("" + savedAIM[i][s]).getBytes());
                    }
                    ++i;
                }
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            s = 0;
            while (s <= step) {
                i = 0;
                while (i < orgNew.getNbRelationsNew()) {
                    if (i < orgNew.getNbRelationsNew() - 1) {
                        ostream.write(new String(String.valueOf(savedTE[i][s]) + "\t").getBytes());
                    } else {
                        ostream.write(new String("" + savedTE[i][s]).getBytes());
                    }
                    ++i;
                }
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            ostream.flush();
            ostream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveResultsExpFile(OrgNew orgNew, double[] meanSAT, double[] meanINF, double[] meanAIM, double[] meanTE, String file) {
        FileOutputStream resulexp = null;
        try {
            resulexp = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            resulexp.write(new String(String.valueOf(orgNew.getName()) + "\n").getBytes());
            resulexp.write(new String(String.valueOf(orgNew.getNbActorsNew()) + "\n" + orgNew.getNbRelationsNew() + "\n" + "12" + "\n" + "10" + "\n").getBytes());
            int i = 0;
            while (i < orgNew.getNbActorsNew()) {
                resulexp.write(new String("satisfaction" + orgNew.getActorsNewName()[i] + "\n").getBytes());
                ++i;
            }
            i = 0;
            while (i < orgNew.getNbActorsNew()) {
                resulexp.write(new String("influence" + orgNew.getActorsNewName()[i] + "\n").getBytes());
                ++i;
            }
            i = 0;
            while (i < orgNew.getNbActorsNew()) {
                resulexp.write(new String("aim" + orgNew.getActorsNewName()[i] + "\n").getBytes());
                ++i;
            }
            i = 0;
            while (i < orgNew.getNbRelationsNew()) {
                resulexp.write(new String("stateRelation" + orgNew.getRelationsNewName()[i] + "\n").getBytes());
                ++i;
            }
            double sommesat = 0.0;
            int i2 = 0;
            while (i2 < orgNew.getNbActorsNew()) {
                resulexp.write(new String(String.valueOf(meanSAT[i2]) + "\n").getBytes());
                sommesat += meanSAT[i2];
                ++i2;
            }
            resulexp.write(new String(String.valueOf(sommesat / (double)orgNew.getNbActorsNew()) + "\n").getBytes());
            double sommeinf = 0.0;
            int i3 = 0;
            while (i3 < orgNew.getNbActorsNew()) {
                resulexp.write(new String(String.valueOf(meanINF[i3]) + "\n").getBytes());
                sommeinf += meanINF[i3];
                ++i3;
            }
            resulexp.write(new String(String.valueOf(sommeinf / (double)orgNew.getNbActorsNew()) + "\n").getBytes());
            double sommeaim = 0.0;
            int i4 = 0;
            while (i4 < orgNew.getNbActorsNew()) {
                resulexp.write(new String(String.valueOf(meanAIM[i4]) + "\n").getBytes());
                sommeaim += meanAIM[i4];
                ++i4;
            }
            resulexp.write(new String(String.valueOf(sommeaim / (double)orgNew.getNbActorsNew()) + "\n").getBytes());
            i4 = 0;
            while (i4 < orgNew.getNbRelationsNew()) {
                resulexp.write(new String(String.valueOf(meanTE[i4]) + "\n").getBytes());
                ++i4;
            }
            if (orgNew.headNbEtapesNec != 0) {
                double s = 0.0;
                int noC = 0;
                int i5 = 0;
                while (i5 < orgNew.headNbEtapesNec) {
                    if (!orgNew.nbStepConvergence[i5][2].equalsIgnoreCase("-")) {
                        s += Double.valueOf(orgNew.nbStepConvergence[i5][2]).doubleValue();
                    } else {
                        ++noC;
                    }
                    ++i5;
                }
                resulexp.write(new String(String.valueOf(Math.rint(s / (double)(orgNew.headNbEtapesNec - noC))) + "\n").getBytes());
            }
            resulexp.write("\n".getBytes());
            resulexp.flush();
            resulexp.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void savePlanExp(OrgNew orgNew, String file) {
        int nb_runs = orgNew.getNbRuns();
        int nb_step = orgNew.getNbSteps();
        String[] actors = orgNew.getActorsNewName();
        String[] relations = orgNew.getRelationsNewName();
        FileOutputStream planexp = null;
        try {
            planexp = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            ActorNew aN;
            planexp.write(new String(String.valueOf(orgNew.getName()) + "\n").getBytes());
            planexp.write(new String("Le nombre de runs \u00e0 r\u00e9aliser pour l'exp\u00e9riences: " + nb_runs + ".\n").getBytes());
            planexp.write(new String("Le nombre de pas max \u00e0 effectuer pour chaque r: " + nb_step + ".\n").getBytes());
            String[] tab = orgNew.getActorsNewName();
            planexp.write("La liste des acteurs:".getBytes());
            int actID = 0;
            while (actID < actors.length) {
                aN = orgNew.getActorNew(actors[actID]);
                planexp.write("\n".getBytes());
                planexp.write(new String(String.valueOf(tab[actID])).getBytes());
                planexp.write((" Oblivion:" + aN.getAPNInitial().getOblivion()).getBytes());
                planexp.write((" Scope:" + aN.getAPNInitial().getScope()).getBytes());
                planexp.write((" Reward:" + aN.getAPNInitial().getReward()).getBytes());
                planexp.write((" Tenacity:" + aN.getAPNInitial().getTenacity()).getBytes());
                planexp.write((" Reactivity:" + aN.getAPNInitial().getReactivity()).getBytes());
                planexp.write((" MoralSensibility:" + aN.getAPNInitial().getMoralSensibility()).getBytes());
                planexp.write((" ActionRange:" + aN.getAPNInitial().getActionRange()).getBytes());
                planexp.write((" Percentage:" + aN.getAPNInitial().getRepartitionPourcentage()).getBytes());
                ++actID;
            }
            planexp.write("\n\n".getBytes());
            planexp.write("Act/Rel".getBytes());
            int relID = 0;
            while (relID < relations.length) {
                planexp.write(new String("\t" + relations[relID]).getBytes());
                ++relID;
            }
            planexp.write("\n".getBytes());
            actID = 0;
            while (actID < actors.length) {
                aN = orgNew.getActorNew(actors[actID]);
                planexp.write(new String(actors[actID]).getBytes());
                int relID2 = 0;
                while (relID2 < relations.length) {
                    planexp.write(new String("\t" + aN.getDepend(relations[relID2]).getStake()).getBytes());
                    ++relID2;
                }
                planexp.write("\n".getBytes());
                ++actID;
            }
            planexp.write("\n".getBytes());
            planexp.write("Act/Act".getBytes());
            actID = 0;
            while (actID < actors.length) {
                planexp.write(new String("\t" + actors[actID]).getBytes());
                ++actID;
            }
            planexp.write("\n".getBytes());
            actID = 0;
            while (actID < actors.length) {
                aN = orgNew.getActorNew(actors[actID]);
                planexp.write(new String(actors[actID]).getBytes());
                int actID2 = 0;
                while (actID2 < actors.length) {
                    planexp.write(new String("\t" + aN.getTarget(actors[actID2]).getSolidarity()).getBytes());
                    ++actID2;
                }
                planexp.write("\n".getBytes());
                ++actID;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            planexp.flush();
            planexp.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void saveExpExp(OrgNew orgNew, String param, int noexp) {
        String[] actors = orgNew.getActorsNewName();
        String[] relations = orgNew.getRelationsNewName();
        int nb_runs = orgNew.getNbRuns();
        int nb_step = orgNew.getNbSteps();
        FileOutputStream exp = null;
        try {
            exp = new FileOutputStream(param);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            ActorNew aN;
            exp.write(new String(String.valueOf(orgNew.getName()) + "\n").getBytes());
            exp.write(new String("Parametres de l'exp\u00e9riences : " + noexp + ".\n").getBytes());
            String[] tab = orgNew.getActorsNewName();
            exp.write("La liste des acteurs:".getBytes());
            int actID = 0;
            while (actID < actors.length) {
                aN = orgNew.getActorNew(actors[actID]);
                exp.write("\n".getBytes());
                exp.write(new String(String.valueOf(tab[actID])).getBytes());
                exp.write(new String(" Oblivion:" + aN.getAPNInitial().getOblivion()).getBytes());
                exp.write(new String(" Scope:" + aN.getAPNInitial().getScope()).getBytes());
                exp.write(new String(" Reward:" + aN.getAPNInitial().getReward()).getBytes());
                exp.write(new String(" Tenacity:" + aN.getAPNInitial().getTenacity()).getBytes());
                exp.write(new String(" Reactivity:" + aN.getAPNInitial().getReactivity()).getBytes());
                exp.write(new String(" MoralSensibility:" + aN.getAPNInitial().getMoralSensibility()).getBytes());
                exp.write(new String(" ActionRange:" + aN.getAPNInitial().getActionRange()).getBytes());
                exp.write(new String(" Percentage:" + aN.getAPNInitial().getRepartitionPourcentage()).getBytes());
                ++actID;
            }
            exp.write("\n\n".getBytes());
            exp.write("Act/Rel".getBytes());
            int relID = 0;
            while (relID < relations.length) {
                exp.write(new String("\t" + relations[relID]).getBytes());
                ++relID;
            }
            exp.write("\n".getBytes());
            actID = 0;
            while (actID < actors.length) {
                aN = orgNew.getActorNew(actors[actID]);
                exp.write(new String(actors[actID]).getBytes());
                int relID2 = 0;
                while (relID2 < relations.length) {
                    exp.write(new String("\t" + aN.getDepend(relations[relID2]).getStake()).getBytes());
                    ++relID2;
                }
                exp.write("\n".getBytes());
                ++actID;
            }
            exp.write("\n".getBytes());
            exp.write("Act/Act".getBytes());
            actID = 0;
            while (actID < actors.length) {
                exp.write(new String("\t" + actors[actID]).getBytes());
                ++actID;
            }
            exp.write("\n".getBytes());
            actID = 0;
            while (actID < actors.length) {
                aN = orgNew.getActorNew(actors[actID]);
                exp.write(new String(actors[actID]).getBytes());
                int actID2 = 0;
                while (actID2 < actors.length) {
                    exp.write(new String("\t" + aN.getTarget(actors[actID2]).getSolidarity()).getBytes());
                    ++actID2;
                }
                exp.write("\n".getBytes());
                ++actID;
            }
            exp.flush();
            exp.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSensiResultExp(OrgNew orgNew, int exps, String result) {
        FileOutputStream results = null;
        String[] params = orgNew.getSensitivityParameters();
        String[] actors = orgNew.getActorsNewName();
        try {
            results = new FileOutputStream(result);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            results.write(new String(String.valueOf(exps) + "\t").getBytes());
            if (params != null) {
                int j = 0;
                while (j < params.length) {
                    results.write(new String(String.valueOf(params[j]) + "\t").getBytes());
                    ++j;
                }
            }
            double sommesat = 0.0;
            int i = 0;
            while (i < actors.length) {
                results.write(new String(String.valueOf(this.savedMeanSAT[i]) + "\t").getBytes());
                sommesat += this.savedMeanSAT[i];
                ++i;
            }
            double sommeinf = 0.0;
            int i2 = 0;
            while (i2 < actors.length) {
                results.write(new String(String.valueOf(this.savedMeanINF[i2]) + "\t").getBytes());
                sommeinf += this.savedMeanINF[i2];
                ++i2;
            }
            double sommeaim = 0.0;
            int i3 = 0;
            while (i3 < actors.length) {
                results.write(new String(String.valueOf(this.savedMeanAIM[i3]) + "\t").getBytes());
                sommeaim += this.savedMeanAIM[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < orgNew.getNbRelationsNew()) {
                results.write(new String(String.valueOf(this.savedMeanTE[i3]) + "\t").getBytes());
                ++i3;
            }
            results.write(new String(String.valueOf(sommesat / (double)actors.length) + "\t").getBytes());
            results.write(new String(String.valueOf(sommeinf / (double)actors.length) + "\t").getBytes());
            results.write(new String(String.valueOf(sommeaim / (double)actors.length) + "\t").getBytes());
            if (orgNew.headNbEtapesNec != 0) {
                double s = 0.0;
                int noC = 0;
                int i4 = 0;
                while (i4 < orgNew.headNbEtapesNec) {
                    if (!orgNew.nbStepConvergence[i4][2].equalsIgnoreCase("-")) {
                        s += Double.valueOf(orgNew.nbStepConvergence[i4][2]).doubleValue();
                    } else {
                        ++noC;
                    }
                    ++i4;
                }
                results.write(new String(String.valueOf(Math.rint(s / (double)(orgNew.headNbEtapesNec - noC))) + "\n").getBytes());
            }
            results.flush();
            results.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSensitivityResult() throws WrongFormException {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        ControllerImpl control = new ControllerImpl();
        control.loadResults(orgNew.getCurrentSensitivityPath());
        Collection<RawResultImpl> collRawResult = control.rawResult.values();
        Iterator<RawResultImpl> itRawResult = collRawResult.iterator();
        RawResultImpl result = itRawResult.next();
        String name = String.valueOf(orgNew.getCurrentSensitivityPath()) + File.separatorChar + "sensitivity result_" + orgNew.getName() + "_" + ".xls";
        FileOutputStream report = null;
        try {
            report = new FileOutputStream(name);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            report.write(new String("nb_step\t" + orgNew.getNbSteps() + "\n").getBytes());
            report.write(new String("nb_run\t" + orgNew.getNbRuns() + "\n").getBytes());
            report.write(new String("nb_experiences\t" + orgNew.getNbExperiences() + "\n").getBytes());
            if (orgNew.getSensitivityParameters() != null) {
                int j = 0;
                while (j < orgNew.getSensitivityParameters().length) {
                    ActorNew aN;
                    report.write(new String("param" + j + "\t" + orgNew.getSensitivityParameters()[j] + "\t").getBytes());
                    char categorie = orgNew.getSensitivityParameters()[j].charAt(0);
                    String temp = orgNew.getSensitivityParameters()[j].substring(2);
                    String actorName = temp.substring(0, temp.indexOf("."));
                    String param = temp.substring(temp.indexOf(".") + 1);
                    if (categorie == '1') {
                        if (temp.startsWith("whole")) {
                            ActorNew a = orgNew.getActorNew(orgNew.getActorsNewName()[0]);
                            if (temp.endsWith("Oblivion")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getOblivion()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getOblivion()) + "\n").getBytes());
                            }
                            if (temp.endsWith("Scope")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getScope()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getScope()) + "\n").getBytes());
                            }
                            if (temp.endsWith("Reward")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getReward()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getReward()) + "\n").getBytes());
                            }
                            if (temp.endsWith("Tenacity")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getTenacity()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getTenacity()) + "\n").getBytes());
                            }
                            if (temp.endsWith("GroupIdentif")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getMoralSensibility()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getMoralSensibility()) + "\n").getBytes());
                            }
                            if (temp.endsWith("ActionRange")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getActionRange()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getActionRange()) + "\n").getBytes());
                            }
                            if (temp.endsWith("Percentage")) {
                                report.write(new String(String.valueOf(a.getAPNCurrentMin().getRepartitionPourcentage()) + "\t").getBytes());
                                report.write(new String(String.valueOf(a.getAPNCurrentMax().getRepartitionPourcentage()) + "\n").getBytes());
                            }
                        } else {
                            int l = 0;
                            while (l < orgNew.getNbActorsNew()) {
                                ActorNew a = orgNew.getActorNew(orgNew.getActorsNewName()[l]);
                                if (temp.startsWith(a.getName())) {
                                    if (temp.endsWith("Oblivion")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getOblivion()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getOblivion()) + "\n").getBytes());
                                    }
                                    if (temp.endsWith("Scope")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getScope()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getScope()) + "\n").getBytes());
                                    }
                                    if (temp.endsWith("Reward")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getReward()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getReward()) + "\n").getBytes());
                                    }
                                    if (temp.endsWith("Tenacity")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getTenacity()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getTenacity()) + "\n").getBytes());
                                    }
                                    if (temp.endsWith("GroupIdentif")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getMoralSensibility()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getMoralSensibility()) + "\n").getBytes());
                                    }
                                    if (temp.endsWith("ActionRange")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getActionRange()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getActionRange()) + "\n").getBytes());
                                    }
                                    if (temp.endsWith("Percentage")) {
                                        report.write(new String(String.valueOf(a.getAPNCurrentMin().getRepartitionPourcentage()) + "\t").getBytes());
                                        report.write(new String(String.valueOf(a.getAPNCurrentMax().getRepartitionPourcentage()) + "\n").getBytes());
                                    }
                                }
                                ++l;
                            }
                        }
                    } else if (categorie == '2') {
                        aN = orgNew.getActorNew(actorName);
                        RelationNew rN = orgNew.getRelationNew(param);
                        report.write(new String(String.valueOf(aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMin()) + "\t").getBytes());
                        report.write(new String(String.valueOf(aN.getDepend(rN.getName()).getSensibilityAnalysisStakeMax()) + "\n").getBytes());
                    } else if (categorie == '3') {
                        aN = orgNew.getActorNew(actorName);
                        ActorNew aNt = orgNew.getActorNew(param);
                        report.write(new String(String.valueOf(aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMin()) + "\t").getBytes());
                        report.write(new String(String.valueOf(aN.getTarget(aNt.getName()).getSensibilityAnalysisSolidarityMax()) + "\n").getBytes());
                    }
                    ++j;
                }
            }
            report.write("\nnum_exp\t".getBytes());
            if (orgNew.getSensitivityParameters() != null) {
                int i = 0;
                while (i < orgNew.getSensitivityParameters().length) {
                    report.write(new String("param" + i + "\t").getBytes());
                    ++i;
                }
            }
            int i = 0;
            while (i < orgNew.getNbActorsNew()) {
                report.write(new String(String.valueOf(orgNew.getActorsNewName()[i]) + "_satis\t").getBytes());
                ++i;
            }
            i = 0;
            while (i < orgNew.getNbActorsNew()) {
                report.write(new String(String.valueOf(orgNew.getActorsNewName()[i]) + "_inf\t").getBytes());
                ++i;
            }
            i = 0;
            while (i < orgNew.getNbActorsNew()) {
                report.write(new String(String.valueOf(orgNew.getActorsNewName()[i]) + "_aim\t").getBytes());
                ++i;
            }
            i = 0;
            while (i < orgNew.getNbRelationsNew()) {
                report.write(new String(String.valueOf(orgNew.getRelationsNewName()[i]) + "_staterel\t").getBytes());
                ++i;
            }
            report.write("total_satis\ttotal_inf\ttotal_aim\tnb_step".getBytes());
            report.write("\n".getBytes());
            int k = 0;
            while (k < orgNew.getNbExperiences()) {
                report.write(new String(String.valueOf(k) + "\t").getBytes());
                while (result.indexfile != k) {
                    if (!itRawResult.hasNext()) {
                        itRawResult = collRawResult.iterator();
                    }
                    result = itRawResult.next();
                }
                if (orgNew.getSensitivityParameters() != null) {
                    int j = 0;
                    while (j < orgNew.getSensitivityParameters().length) {
                        char categorie = orgNew.getSensitivityParameters()[j].charAt(0);
                        String temp = orgNew.getSensitivityParameters()[j].substring(2);
                        String actorName = temp.substring(0, temp.indexOf("."));
                        String param = temp.substring(temp.indexOf(".") + 1);
                        int numActor = 0;
                        int numParam = 0;
                        double valParam = 0.0;
                        int i2 = 0;
                        while (i2 < orgNew.getNbActorsNew()) {
                            if (orgNew.getActorsNewName()[i2].equals(actorName)) {
                                numActor = i2;
                            }
                            ++i2;
                        }
                        if (categorie == '1') {
                            if (param.equals("Oblivion")) {
                                numParam = 0;
                            } else if (param.equals("Scope")) {
                                numParam = 1;
                            } else if (param.equals("Reward")) {
                                numParam = 2;
                            } else if (param.equals("Tenacity")) {
                                numParam = 3;
                            } else if (param.equals("Reactivity")) {
                                numParam = 4;
                            } else if (param.equals("GroupIdentif")) {
                                numParam = 5;
                            } else if (param.equals("ActionRange")) {
                                numParam = 6;
                            } else if (param.equals("Percentage")) {
                                numParam = 7;
                            }
                            valParam = (int)(result.tabactorsparam[numActor][numParam] * 100.0);
                        } else if (categorie == '2') {
                            i2 = 0;
                            while (i2 < orgNew.getNbRelationsNew()) {
                                if (orgNew.getRelationsNewName()[i2].equals(param)) {
                                    numParam = i2;
                                }
                                ++i2;
                            }
                            valParam = (int)(result.tabactorsrelations[numActor][numParam] * 100.0);
                        } else if (categorie == '3') {
                            i2 = 0;
                            while (i2 < orgNew.getNbActorsNew()) {
                                if (orgNew.getActorsNewName()[i2].equals(param)) {
                                    numParam = i2;
                                }
                                ++i2;
                            }
                            valParam = (int)(result.tabactorsactors[numActor][numParam] * 100.0);
                        }
                        report.write(new String(String.valueOf(valParam / 100.0) + "\t").getBytes());
                        ++j;
                    }
                }
                int i3 = 0;
                while (i3 < result.getNbActors()) {
                    double s = (int)(result.getmeansatisfaction()[i3] * 100.0);
                    report.write(new String(String.valueOf(s / 100.0) + "\t").getBytes());
                    ++i3;
                }
                i3 = 0;
                while (i3 < result.getNbActors()) {
                    double in = (int)(result.getmeaninfluence()[i3] * 100.0);
                    report.write(new String(String.valueOf(in / 100.0) + "\t").getBytes());
                    ++i3;
                }
                i3 = 0;
                while (i3 < result.getNbActors()) {
                    double a = (int)(result.getmeanaim()[i3] * 100.0);
                    report.write(new String(String.valueOf(a / 100.0) + "\t").getBytes());
                    ++i3;
                }
                i3 = 0;
                while (i3 < result.getNbRelations()) {
                    double r = (int)(result.getmeanstaterelation()[i3] * 100.0);
                    report.write(new String(String.valueOf(r / 100.0) + "\t").getBytes());
                    ++i3;
                }
                double t = (int)(result.gettotalsat() * 100.0);
                report.write(new String(String.valueOf(t / 100.0) + "\t").getBytes());
                double inf = (int)(result.gettotalinf() * 100.0);
                report.write(new String(String.valueOf(inf / 100.0) + "\t").getBytes());
                double a = (int)(result.gettotalaim() * 100.0);
                report.write(new String(String.valueOf(a / 100.0) + "\t").getBytes());
                report.write(new String(String.valueOf(result.getmeannbstepconv())).getBytes());
                report.write("\n".getBytes());
                ++k;
            }
            report.flush();
            report.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

