/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.sensiLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.sensiLauncher.GraphicalSensiLauncher;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SensiParams
extends JPanel {
    private JLabel simuNbExpLabel = new JLabel("nb experiences :");
    private JLabel simuNbRunLabel = new JLabel("nb runs :");
    private JLabel simuMaxStepLabel = new JLabel("nb step :");
    private JComboBox simuNbExpInput = new JComboBox<String>(new String[]{"1", "5", "10", "20", "30", "50", "100", "200", "500"});
    private JComboBox simuNbRunInput = new JComboBox<String>(new String[]{"1", "5", "10", "20", "30", "50", "100", "200", "500"});
    private JComboBox simuMaxStepInput = new JComboBox<String>(new String[]{"20", "50", "100", "200", "500", "1000", "2000", "3000", "5000", "10000", "20000", "100000"});
    private JButton validate = new JButton("Accept");

    public SensiParams(GraphicalSensiLauncher project) {
        this.simuMaxStepInput.setEditable(true);
        this.simuNbRunInput.setEditable(true);
        this.simuNbExpInput.setEditable(true);
        this.validate.setIcon(DesktopFrame.okIcon);
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensiParams.this.updateParams();
            }
        });
        this.setLayout(null);
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        p1.add(this.simuMaxStepLabel);
        p1.add(this.simuMaxStepInput);
        p2.add(this.simuNbRunLabel);
        p2.add(this.simuNbRunInput);
        p3.add(this.simuNbExpLabel);
        p3.add(this.simuNbExpInput);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)p1, c);
        ++c.gridy;
        this.add((Component)p2, c);
        ++c.gridy;
        this.add((Component)p3, c);
        ++c.gridy;
        this.add((Component)this.validate, c);
        this.initValues();
        Border border = BorderFactory.createLineBorder(Color.gray, 3);
        this.setBorder(border);
        this.repaint();
    }

    void initValues() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew != null) {
            this.simuMaxStepInput.setSelectedItem(Integer.toString(orgNew.getNbSteps()));
            this.simuNbRunInput.setSelectedItem(Integer.toString(orgNew.getNbRuns()));
            this.simuNbExpInput.setSelectedItem(Integer.toString(orgNew.getNbExperiences()));
        }
    }

    void updateParams() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        orgNew.setNbSteps(Integer.parseInt((String)this.simuMaxStepInput.getSelectedItem()));
        orgNew.setNbRuns(Integer.parseInt((String)this.simuNbRunInput.getSelectedItem()));
        orgNew.setNbExperiences(Integer.parseInt((String)this.simuNbExpInput.getSelectedItem()));
    }

    void switchLanguage() {
        this.validate.setText(SwitchLanguages.SensiParamsButtonValidate[SocLabToolkit.idLanguage]);
        this.simuNbExpLabel.setText(SwitchLanguages.SensiParamsLabelExperiences[SocLabToolkit.idLanguage]);
        this.simuNbRunLabel.setText(SwitchLanguages.SensiParamsLabelRuns[SocLabToolkit.idLanguage]);
        this.simuMaxStepLabel.setText(SwitchLanguages.SensiParamsLabelSteps[SocLabToolkit.idLanguage]);
    }
}

