/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.sensiLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;

class SensitivityDescEditor
extends JPanel {
    private String text = "";
    private JToggleButton editButton;
    private JLabel descLabel;
    private JTextPane orgDescInput = new JTextPane();

    public SensitivityDescEditor() {
        this.setLayout(null);
        JScrollPane scrollPane = new JScrollPane(this.orgDescInput);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        scrollPane.setMinimumSize(new Dimension(300, 200));
        this.orgDescInput.setEditorKit(new HTMLEditorKit());
        this.orgDescInput.setBackground(new Color(235, 235, 255));
        this.orgDescInput.setCaretColor(Color.BLACK);
        this.orgDescInput.setMargin(new Insets(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.descLabel = new JLabel("<html><font color=blue><b>SENSITIVITY DESCRIPTION</b></font></html>");
        this.descLabel.setHorizontalAlignment(0);
        this.editButton = new JToggleButton("Edit", DesktopFrame.editCancelIcon);
        this.editButton.setFocusable(false);
        this.editButton.setToolTipText("Edit the Sensitivity description.");
        this.editButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SensitivityDescEditor.this.editButton.isSelected()) {
                    SensitivityDescEditor.this.editButton.setIcon(DesktopFrame.editOkIcon);
                    SensitivityDescEditor.this.orgDescInput.getCaret().setVisible(true);
                    SensitivityDescEditor.this.orgDescInput.setEditorKit(new StyledEditorKit());
                    SensitivityDescEditor.this.orgDescInput.setText(SensitivityDescEditor.this.text);
                    SensitivityDescEditor.this.orgDescInput.setEditable(true);
                    SensitivityDescEditor.this.orgDescInput.setBackground(Color.WHITE);
                } else {
                    SensitivityDescEditor.this.text = SensitivityDescEditor.this.orgDescInput.getText();
                    SensitivityDescEditor.this.editButton.setIcon(DesktopFrame.editCancelIcon);
                    SensitivityDescEditor.this.orgDescInput.setEditorKit(new HTMLEditorKit());
                    SensitivityDescEditor.this.orgDescInput.setText(SensitivityDescEditor.this.text2HTML());
                    SensitivityDescEditor.this.orgDescInput.setEditable(false);
                    SensitivityDescEditor.this.orgDescInput.setBackground(new Color(235, 235, 255));
                }
            }
        });
        buttonPanel.add((Component)this.descLabel, "Center");
        buttonPanel.add((Component)this.editButton, "East");
        this.setPreferredSize(new Dimension(300, 200));
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonPanel, "North");
        this.initValues();
    }

    void initValues() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew != null) {
            this.text = orgNew.getSensiDescription();
            this.orgDescInput.setText(this.text2HTML());
        }
        this.repaint();
    }

    void updateParams() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        this.text = this.text.replace('<', '_');
        this.text = this.text.replace('>', '_');
        this.text = this.text.replace('\"', '_');
        orgNew.setSensiDescription(this.text);
    }

    private String text2HTML() {
        String result = "<html>";
        StringTokenizer token = new StringTokenizer(this.text, "\n");
        while (token.hasMoreTokens()) {
            String line = token.nextToken();
            result = this.isUpperCase(line) ? String.valueOf(result) + "<font color=blue><b><u>" + line + "</u></b></font>" + "<br>" : String.valueOf(result) + "<font size=-1>" + line + "</font>" + "<br>";
        }
        return String.valueOf(result) + "</html>";
    }

    private boolean isUpperCase(String text) {
        int i = 0;
        while (i < text.length()) {
            Character c = Character.valueOf(text.charAt(i));
            if (Character.isLetter(c.charValue()) && Character.isLowerCase(c.charValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void switchLanguage() {
        this.descLabel.setText("<html><font color=blue><b>" + SwitchLanguages.SensitivityDescEditorDescLabel[SocLabToolkit.idLanguage] + "</b></font></html>");
        this.editButton.setText(SwitchLanguages.SensitivityDescEditorButtonEdit[SocLabToolkit.idLanguage]);
        this.editButton.setToolTipText(SwitchLanguages.SensitivityDescEditorButtonEditTooltip[SocLabToolkit.idLanguage]);
    }
}

