/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.simuLauncher;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.simuLauncher.SimulationProgressBar;
import SocLab.GUI.simuLauncher.waitingWindows;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.Simu;
import SocLab.core.SocLabToolkit;
import SocLab.tools.arrayKit.ArrayKit;
import controller.simuSynthesis.AnyObservationIsConvergingException;
import controller.simuSynthesis.ControllerImpl;
import input.WrongFormException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import org.apache.commons.math.stat.StatUtils;

public class MyThread
extends Thread {
    private boolean isFuzzyStakes;
    private boolean isFuzzySolidarities;

    public MyThread(JDesktopPane desktop, boolean ifst, boolean ifso) {
        this.isFuzzyStakes = ifst;
        this.isFuzzySolidarities = ifso;
    }

    @Override
    public void run() {
        if (DesktopFrame.ww == null) {
            DesktopFrame.ww = new waitingWindows();
            DesktopFrame.desktopPanel.add(DesktopFrame.ww);
        }
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        orgNew.minMaxAims(orgNew.getActorsNew());
        this.saveSimulationParameters(orgNew);
        int nb_runs = SocLabToolkit.currentOrgNew.getNbRuns();
        int nb_step = SocLabToolkit.currentOrgNew.getNbSteps();
        double[][] savedFinalSAT = new double[orgNew.getNbActorsNew()][nb_runs];
        double[][] savedFinalAim = new double[orgNew.getNbActorsNew()][nb_runs];
        double[][] savedFinalInfluence = new double[orgNew.getNbActorsNew()][nb_runs];
        double[] savedMeanSAT = new double[orgNew.getNbActorsNew()];
        double[] savedMeanAim = new double[orgNew.getNbActorsNew()];
        double[] savedStandevSAT = new double[orgNew.getNbActorsNew()];
        double[] savedStandevAim = new double[orgNew.getNbActorsNew()];
        double[][] savedFinalState = new double[orgNew.getNbRelationsNew()][nb_runs];
        double[] savedMeanState = new double[orgNew.getNbRelationsNew()];
        double[] savedMedianState = new double[orgNew.getNbRelationsNew()];
        double[] savedStandevState = new double[orgNew.getNbRelationsNew()];
        double[] savedConv = new double[nb_runs];
        SocLabToolkit.currentOrgNew.nbStepConvergence = new String[nb_runs][3];
        SocLabToolkit.currentOrgNew.headNbEtapesNec = 0;
        if (DesktopFrame.smb == null) {
            DesktopFrame.smb = new SimulationProgressBar();
            DesktopFrame.desktopPanel.add(DesktopFrame.smb);
        }
        DesktopFrame.smb.init(nb_runs);
        int i = 0;
        while (i < DesktopFrame.getFrames().length) {
            DesktopFrame.getFrames()[i].setEnabled(false);
            ++i;
        }
        int runs = 0;
        while (runs < nb_runs) {
            ActorNew aN;
            int i2;
            String[] aNames;
            DesktopFrame.smb.updateCurrentRun(runs);
            Simu simu = new Simu(orgNew);
            orgNew.reset();
            if (this.isFuzzyStakes && orgNew != null) {
                aNames = orgNew.getActorsNewName();
                i2 = 0;
                while (i2 < aNames.length) {
                    aN = orgNew.getActorNew(aNames[i2]);
                    orgNew.initStakesInFuzzyMode(aN);
                    ++i2;
                }
            }
            if (this.isFuzzySolidarities && orgNew != null) {
                aNames = orgNew.getActorsNewName();
                i2 = 0;
                while (i2 < aNames.length) {
                    aN = orgNew.getActorNew(aNames[i2]);
                    orgNew.initSolidaritiesInFuzzyMode(aN);
                    ++i2;
                }
            }
            double[][] stepAmbition = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] stepAim = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] effect_rules = new double[orgNew.getNbActorsNew()][nb_step + 1];
            double[][] stepState = new double[orgNew.getNbRelationsNew()][nb_step + 1];
            orgNew.incoherent = false;
            int step = 0;
            while (step < nb_step) {
                simu.step();
                String[] aNames2 = orgNew.getActorsNewName();
                int actId = 0;
                while (actId < orgNew.getNbActorsNew()) {
                    stepAmbition[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames2[actId]).getAmbition(), 2);
                    stepAim[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames2[actId]).getActualAim(), 2);
                    ++actId;
                }
                String[] rNames = orgNew.getRelationsNewName();
                int i3 = 0;
                while (i3 < rNames.length) {
                    RelationNew rN = orgNew.getRelationNew(rNames[i3]);
                    stepState[i3][step] = this.shiftDecimal(rN.getRPNCurrent().getState(), 2);
                    ++i3;
                }
                if (orgNew.allActorSatisfied()) {
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][0] = new String(String.valueOf(runs));
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][1] = "Oui";
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][2] = new String(String.valueOf(step));
                    ++SocLabToolkit.currentOrgNew.headNbEtapesNec;
                    break;
                }
                if (step == nb_step - 1) {
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][0] = new String(String.valueOf(runs));
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][1] = "Non";
                    SocLabToolkit.currentOrgNew.nbStepConvergence[runs][2] = "-";
                    ++SocLabToolkit.currentOrgNew.headNbEtapesNec;
                }
                if (orgNew.incoherent) {
                    DesktopFrame.statusBar.setText("Model incoherent, Simulation has been stopped ...");
                    step = nb_step;
                    break;
                }
                ++step;
            }
            if (orgNew.incoherent) {
                runs = nb_runs;
                break;
            }
            if (step == nb_step) {
                String[] aNames3 = orgNew.getActorsNewName();
                int actId = 0;
                while (actId < orgNew.getNbActorsNew()) {
                    stepAmbition[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames3[actId]).getAmbition(), 2);
                    stepAim[actId][step] = this.shiftDecimal(orgNew.getActorNew(aNames3[actId]).getActualAim(), 2);
                    ++actId;
                }
            }
            int actId = 0;
            while (actId < orgNew.getNbActorsNew()) {
                savedFinalSAT[actId][runs] = this.shiftDecimal(orgNew.getActorsNew().elementAt(actId).getActualSatisfaction(), 2);
                savedFinalAim[actId][runs] = stepAim[actId][step];
                savedFinalInfluence[actId][runs] = this.shiftDecimal(orgNew.getActorsNew().elementAt(actId).getAccumulatedActualInfluence(), 2);
                ++actId;
            }
            int relId = 0;
            while (relId < orgNew.getNbRelationsNew()) {
                savedFinalState[relId][runs] = stepState[relId][step];
                ++relId;
            }
            savedConv[runs] = step;
            stepState = ArrayKit.reduce(stepState, step + 1);
            stepAmbition = ArrayKit.reduce(stepAmbition, step + 1);
            stepAim = ArrayKit.reduce(stepAim, step + 1);
            effect_rules = ArrayKit.reduce(effect_rules, step);
            this.saveRawResults(orgNew, runs, step, savedFinalSAT, savedFinalInfluence, stepAmbition, stepAim, stepState);
            ++runs;
        }
        int actId = 0;
        while (actId < orgNew.getNbActorsNew()) {
            savedMeanSAT[actId] = StatUtils.mean((double[])savedFinalSAT[actId]);
            savedMeanAim[actId] = StatUtils.mean((double[])savedFinalAim[actId]);
            savedStandevSAT[actId] = Math.sqrt(StatUtils.variance((double[])savedFinalSAT[actId]));
            savedStandevAim[actId] = Math.sqrt(StatUtils.variance((double[])savedFinalAim[actId]));
            ++actId;
        }
        int relId = 0;
        while (relId < orgNew.getNbRelationsNew()) {
            savedMeanState[relId] = StatUtils.mean((double[])savedFinalState[relId]);
            savedMedianState[relId] = StatUtils.percentile((double[])savedFinalState[relId], (double)50.0);
            savedStandevState[relId] = Math.sqrt(StatUtils.variance((double[])savedFinalState[relId]));
            ++relId;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        DesktopFrame.smb.setVisible(false);
        i = 0;
        while (i < DesktopFrame.getFrames().length) {
            DesktopFrame.getFrames()[i].setEnabled(true);
            ++i;
        }
        if (SocLabToolkit.currentOrgNew.incoherent) {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Model incoherent, Simulation has been stopped ...", "Error", -1);
        }
    }

    private void saveSimulationParameters(OrgNew orgNew) {
        String path = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        File daPath = new File(path);
        if (!daPath.isDirectory()) {
            daPath.mkdirs();
        }
        String file = String.valueOf(path) + File.separatorChar + SocLabToolkit.orgFileNew.getName() + "_SimulationInitialParameters" + ".txt";
        String[] actorNames = orgNew.getActorsNewName();
        String[] relationNames = orgNew.getRelationsNewName();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            ostream.write(new String(String.valueOf(String.valueOf(!this.isFuzzyStakes)) + "\t").getBytes());
            ostream.write(new String(String.valueOf(String.valueOf(!this.isFuzzySolidarities)) + "\t").getBytes());
            ostream.write(new String(String.valueOf(String.valueOf(orgNew.getSimuWithConstraints())) + "\t").getBytes());
            ostream.write(new String(String.valueOf(orgNew.getNbSteps()) + "\t" + orgNew.getNbRuns() + "\t" + orgNew.getNbActorsNew() + "\t" + orgNew.getNbRelationsNew() + "\n\n").getBytes());
            int i = 0;
            while (i < actorNames.length) {
                if (i < actorNames.length - 1) {
                    ostream.write(new String(String.valueOf(actorNames[i]) + "\t").getBytes());
                } else {
                    ostream.write(new String(String.valueOf(actorNames[i]) + "\n\n").getBytes());
                }
                ++i;
            }
            i = 0;
            while (i < relationNames.length) {
                if (i < relationNames.length - 1) {
                    ostream.write(new String(String.valueOf(relationNames[i]) + "\t").getBytes());
                } else {
                    ostream.write(new String(String.valueOf(relationNames[i]) + "\n\n").getBytes());
                }
                ++i;
            }
            ostream.write("Actors\t".getBytes());
            ostream.write("Oblivion\t".getBytes());
            ostream.write("Reward\t".getBytes());
            ostream.write("Scope\t".getBytes());
            ostream.write("Tenacity\t".getBytes());
            ostream.write("Reactivity\t".getBytes());
            ostream.write("MoralSensibility\t".getBytes());
            ostream.write("ActionRange\t".getBytes());
            ostream.write("Evaluation\t".getBytes());
            ostream.write("TypeOfRules\t".getBytes());
            ostream.write("Percentage\n".getBytes());
            i = 0;
            while (i < actorNames.length) {
                ActorNew aN = orgNew.getActorNew(actorNames[i]);
                ostream.write(actorNames[i].getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getOblivion()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getReward()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getScope()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getTenacity()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getReactivity()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getMoralSensibility()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getActionRange()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getEvaluationCriterium()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getTypeOfRules()).getBytes());
                ostream.write(new String("\t" + aN.getAPNInitial().getRepartitionPourcentage()).getBytes());
                ostream.write("\n".getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write("Relations\t".getBytes());
            ostream.write("State\t".getBytes());
            ostream.write("LowerBound\t".getBytes());
            ostream.write("UpperBound\n".getBytes());
            i = 0;
            while (i < relationNames.length) {
                RelationNew rN = orgNew.getRelationNew(relationNames[i]);
                ostream.write(relationNames[i].getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getState()).getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getLowerBound()).getBytes());
                ostream.write(new String("\t" + rN.getRPNInitial().getUpperBound()).getBytes());
                ostream.write("\n".getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write(orgNew.getSimuDescription().getBytes());
            ostream.write(" - - - - - - - - - - ".getBytes());
            ostream.flush();
            ostream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveRawResults(OrgNew orgNew, int runId, int nbStep, double[][] savedFinalSatis, double[][] savedFinalInfluence, double[][] stepAmbition, double[][] stepAim, double[][] stepRelState) {
        String path = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        File daPath = new File(path);
        if (!daPath.isDirectory()) {
            daPath.mkdirs();
        }
        String file = String.valueOf(path) + File.separatorChar + "results_" + SocLabToolkit.orgFileNew.getName() + "_" + runId + ".xls";
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        try {
            boolean convergence;
            ostream.write(new String(String.valueOf(orgNew.getName()) + "\n\n").getBytes());
            ostream.write(new String(runId + "\n\n").getBytes());
            ostream.write(new String("1\t" + orgNew.getNbActorsNew() + "\t" + orgNew.getNbRelationsNew() + "\t" + 3 + "\t" + 1 + "\t" + 2 + "\t" + 1 + "\n\n").getBytes());
            ostream.write("nb_step\n".getBytes());
            ostream.write("\n".getBytes());
            int i = 0;
            while (i < orgNew.getNbActorsNew()) {
                ostream.write(new String(String.valueOf(orgNew.getActorsNewName()[i]) + "\n").getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            i = 0;
            while (i < orgNew.getNbRelationsNew()) {
                ostream.write(new String(String.valueOf(orgNew.getRelationsNewName()[i]) + "\n").getBytes());
                ++i;
            }
            ostream.write("\n".getBytes());
            ostream.write("Satisfaction\n".getBytes());
            ostream.write("Influence\n".getBytes());
            ostream.write("Aim\n".getBytes());
            ostream.write("\n".getBytes());
            ostream.write("State\n".getBytes());
            ostream.write("\n".getBytes());
            ostream.write("Aim_Step\n".getBytes());
            ostream.write("Aspiration_Step\n".getBytes());
            ostream.write("\n".getBytes());
            ostream.write("State_Step\n".getBytes());
            ostream.write("\n".getBytes());
            boolean bl = convergence = nbStep < SocLabToolkit.currentOrgNew.getNbSteps() - 1;
            if (convergence) {
                ostream.write("o".getBytes());
            } else {
                ostream.write("n".getBytes());
            }
            ostream.write("\n\n".getBytes());
            ostream.write(new String(nbStep + "\n").getBytes());
            ostream.write("\n".getBytes());
            int i2 = 0;
            while (i2 < orgNew.getNbActorsNew() - 1) {
                ostream.write(new String(String.valueOf(savedFinalSatis[i2][runId]) + "\t").getBytes());
                ++i2;
            }
            ostream.write(new String("" + savedFinalSatis[i2][runId]).getBytes());
            ostream.write("\n\n".getBytes());
            i2 = 0;
            while (i2 < orgNew.getNbActorsNew() - 1) {
                ostream.write(new String(String.valueOf(savedFinalInfluence[i2][runId]) + "\t").getBytes());
                ++i2;
            }
            ostream.write(new String("" + savedFinalInfluence[i2][runId]).getBytes());
            ostream.write("\n\n".getBytes());
            i2 = 0;
            while (i2 < orgNew.getNbActorsNew() - 1) {
                ostream.write(new String(String.valueOf(stepAim[i2][nbStep]) + "\t").getBytes());
                ++i2;
            }
            ostream.write(new String("" + stepAim[i2][nbStep]).getBytes());
            ostream.write("\n\n".getBytes());
            i2 = 0;
            while (i2 < orgNew.getNbRelationsNew() - 1) {
                ostream.write(new String(String.valueOf(stepRelState[i2][nbStep]) + "\t").getBytes());
                ++i2;
            }
            ostream.write(new String("" + stepRelState[i2][nbStep]).getBytes());
            ostream.write("\n\n".getBytes());
            int s = 0;
            while (s <= nbStep) {
                i2 = 0;
                while (i2 < orgNew.getNbActorsNew() - 1) {
                    ostream.write(new String(String.valueOf(stepAim[i2][s]) + "\t").getBytes());
                    ++i2;
                }
                ostream.write(new String("" + stepAim[i2][s]).getBytes());
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            s = 0;
            while (s <= nbStep) {
                i2 = 0;
                while (i2 < orgNew.getNbActorsNew() - 1) {
                    ostream.write(new String(String.valueOf(stepAmbition[i2][s]) + "\t").getBytes());
                    ++i2;
                }
                ostream.write(new String("" + stepAmbition[i2][s]).getBytes());
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            s = 0;
            while (s <= nbStep) {
                i2 = 0;
                while (i2 < orgNew.getNbRelationsNew() - 1) {
                    ostream.write(new String(String.valueOf(stepRelState[i2][s]) + "\t").getBytes());
                    ++i2;
                }
                ostream.write(new String("" + stepRelState[i2][s]).getBytes());
                ostream.write("\n".getBytes());
                ++s;
            }
            ostream.write("\n".getBytes());
            ostream.flush();
            ostream.close();
            this.generateSummaryFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateSummaryFile() {
        String simulationsPath = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        ControllerImpl c = new ControllerImpl();
        if (simulationsPath != null && new File(simulationsPath).exists()) {
            try {
                c.loadResults(simulationsPath);
                c.createSummaryFiles(simulationsPath, "synthesis." + SocLabToolkit.orgFileNew.getName() + ".txt");
            }
            catch (WrongFormException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (AnyObservationIsConvergingException anyObservationIsConvergingException) {
                // empty catch block
            }
        }
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

