/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.simuLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.simuLauncher.GraphicalSimuLauncher;
import SocLab.GUI.simuLauncher.paramsPanels.AgentParams;
import SocLab.GUI.simuLauncher.paramsPanels.SimulationDescEditor;
import SocLab.GUI.simuLauncher.paramsPanels.TEParams;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SimuParamTabbedPane
extends JPanel {
    private GraphicalSimuLauncher project;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private TEParams teParams;
    public AgentParams agentParams;
    private SimulationDescEditor simuDescEditor;
    private JButton validate = new JButton("Accept");

    public SimuParamTabbedPane(GraphicalSimuLauncher project, JDesktopPane desktop) {
        this.project = project;
        this.validate.setIcon(DesktopFrame.okIcon);
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimuParamTabbedPane.this.updateParams();
            }
        });
        this.teParams = new TEParams();
        this.agentParams = new AgentParams();
        this.simuDescEditor = new SimulationDescEditor();
        this.tabbedPane.add((Component)this.teParams, "Initial State (terms of exchange)");
        this.tabbedPane.add((Component)this.agentParams, "Agent Parameters");
        this.tabbedPane.add((Component)this.simuDescEditor, "Simulation Description");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.validate, "South");
        this.setVisible(true);
    }

    private void updateParams() {
        this.project.simuParams.updateParams();
        this.teParams.updateParams();
        this.agentParams.updateParams();
        this.simuDescEditor.updateParams();
    }

    public void initValues() {
        this.project.simuParams.initValues();
        this.teParams.initValues(this.project.getGraphics());
        this.agentParams.initValues(this.project.getGraphics());
        this.simuDescEditor.initValues();
        this.switchLanguage();
    }

    public void switchLanguage() {
        this.validate.setText(SwitchLanguages.SensiParamsTabbedPaneButtonValidate[SocLabToolkit.idLanguage]);
        if (this.tabbedPane != null) {
            this.tabbedPane.setTitleAt(0, SwitchLanguages.SimuParamsTabbedPaneButtonTabbedPaneInitialState[SocLabToolkit.idLanguage]);
            this.tabbedPane.setTitleAt(1, SwitchLanguages.SimuParamsTabbedPaneButtonTabbedPaneAgentParameters[SocLabToolkit.idLanguage]);
            this.tabbedPane.setTitleAt(2, SwitchLanguages.SimuParamsTabbedPaneButtonTabbedPaneSensitivityDescription[SocLabToolkit.idLanguage]);
        }
        this.project.simuParams.switchLanguage();
        this.teParams.switchLanguage();
        this.agentParams.switchLanguage();
        this.simuDescEditor.switchLanguage();
    }
}

