/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.simuLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.simuLauncher.GraphicalSimuLauncher;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SimuParams
extends JPanel {
    private JLabel simuNbRunLabel = new JLabel("nb runs :");
    private JLabel simuMaxStepLabel = new JLabel("nb step :");
    private JComboBox simuNbRunInput = new JComboBox<String>(new String[]{"1", "5", "10", "20", "30", "50", "100", "200", "500"});
    private JComboBox simuMaxStepInput = new JComboBox<String>(new String[]{"30", "100", "400", "1000", "3000", "5000", "10000", "20000", "50000", "200000"});
    private JButton validate = new JButton("Accept");

    public SimuParams(GraphicalSimuLauncher project) {
        this.validate.setToolTipText("you need to accept the new values before they should take into account !");
        this.simuMaxStepInput.setEditable(true);
        this.simuNbRunInput.setEditable(true);
        this.validate.setIcon(DesktopFrame.okIcon);
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimuParams.this.updateParams();
            }
        });
        this.setLayout(null);
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        p1.add(this.simuMaxStepLabel);
        p1.add(this.simuMaxStepInput);
        p2.add(this.simuNbRunLabel);
        p2.add(this.simuNbRunInput);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)p1, c);
        ++c.gridy;
        this.add((Component)p2, c);
        ++c.gridy;
        this.add((Component)this.validate, c);
        this.initValues();
        Border border = BorderFactory.createLineBorder(Color.gray, 3);
        this.setBorder(border);
        this.repaint();
    }

    void initValues() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew != null) {
            this.simuMaxStepInput.setSelectedItem(Integer.toString(orgNew.getNbSteps()));
            this.simuNbRunInput.setSelectedItem(Integer.toString(orgNew.getNbRuns()));
        }
    }

    void updateParams() {
        try {
            OrgNew orgNew = SocLabToolkit.currentOrgNew;
            orgNew.setNbSteps(Integer.parseInt((String)this.simuMaxStepInput.getSelectedItem()));
            orgNew.setNbRuns(Integer.parseInt((String)this.simuNbRunInput.getSelectedItem()));
        }
        catch (NumberFormatException n) {
            JOptionPane.showMessageDialog(this, n.toString(), "Erreur de saisie", 0);
        }
    }

    void switchLanguage() {
        this.validate.setText(SwitchLanguages.SimuParamsButtonValidate[SocLabToolkit.idLanguage]);
        this.simuNbRunLabel.setText(SwitchLanguages.SimuParamsLabelRuns[SocLabToolkit.idLanguage]);
        this.simuMaxStepLabel.setText(SwitchLanguages.SimuParamsLabelSteps[SocLabToolkit.idLanguage]);
    }
}

