/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.stateInterpreter.tableModel;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.SocialGameState;
import javax.swing.table.AbstractTableModel;

public class SatisfactionInfluencePercentageTableModel
extends AbstractTableModel {
    private OrgNew orgNew;
    private SocialGameState state;

    public SatisfactionInfluencePercentageTableModel(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.state = new SocialGameState();
        this.state.initState(orgNew);
    }

    @Override
    public int getColumnCount() {
        return this.orgNew.getNbActorsNew() + 3;
    }

    @Override
    public int getRowCount() {
        return this.orgNew.getNbActorsNew() + 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int nbActors = this.orgNew.getNbActorsNew();
        String[] aNames = this.orgNew.getActorsNewName();
        if (col == 0) {
            if (row == nbActors) {
                return "INFLUENCE";
            }
            if (row == nbActors + 1) {
                return "ABSOLUTE INFLUENCE";
            }
            if (row == nbActors + 2) {
                return "AUTO INFLUENCE";
            }
            if (row < nbActors) {
                return aNames[row];
            }
        }
        if (row < nbActors && col == nbActors + 1) {
            ActorNew aN = this.orgNew.getActorNew(aNames[row]);
            double val = aN.getSatisfaction(aN, this.state);
            double max = aN.getMaxSatis();
            double min = aN.getMinSatis();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
        }
        if (row < nbActors && col == nbActors + 2) {
            ActorNew a = this.orgNew.getActorNew(aNames[row]);
            double val = a.getTarget(a.getName()).getActualInfluence(a, a, this.state);
            double min = a.getTarget(a.getName()).getMinActualInfluence();
            double sat = a.getSatisfaction(a, this.state);
            double minsat = a.getMinSatis();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (sat - minsat) * 100.0, 1))) + " %";
        }
        if (row == nbActors && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[col - 1]);
            double val = a.getAccumulatedActualInfluence(this.state);
            double max = a.getMaxSitInfluence();
            double min = a.getMinSitInfluence();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
        }
        if (row == nbActors + 1 && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[col - 1]);
            double val = 0.0;
            double max = 0.0;
            int i = 0;
            while (i < nbActors) {
                ActorNew b = this.orgNew.getActorNew(aNames[i]);
                double v = a.getTarget(b.getName()).getActualInfluence(a, b, this.state);
                if (v >= 0.0) {
                    val += v;
                    max += a.getTarget(b.getName()).getMaxActualInfluence();
                } else {
                    val -= v;
                    max -= a.getTarget(b.getName()).getMinActualInfluence();
                }
                ++i;
            }
            return String.valueOf(String.valueOf(this.shiftDecimal(val / max * 100.0, 1))) + " %";
        }
        if (row == nbActors + 2 && col < nbActors + 1) {
            double mininfl;
            ActorNew a = this.orgNew.getActorNew(aNames[col - 1]);
            double val = a.getTarget(a.getName()).getActualInfluence(a, a, this.state);
            double min = a.getTarget(a.getName()).getMinActualInfluence();
            double infl = a.getAccumulatedActualInfluence(this.state);
            if (infl > (mininfl = a.getMinSitInfluence())) {
                return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (infl - mininfl) * 100.0, 1))) + " %";
            }
            return "--";
        }
        if (row < nbActors && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[row]);
            ActorNew b = this.orgNew.getActorNew(aNames[col - 1]);
            double val = b.getTarget(a.getName()).getActualInfluence(b, a, this.state);
            double max = b.getTarget(a.getName()).getMaxActualInfluence();
            double min = b.getTarget(a.getName()).getMinActualInfluence();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        if (col == this.orgNew.getNbActorsNew() + 1) {
            return "SATISFACTION";
        }
        if (col == this.orgNew.getNbActorsNew() + 2) {
            return "AUTO SATISF";
        }
        return this.orgNew.getActorsNewName()[col - 1];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setState(SocialGameState state) {
        this.state = state;
        this.fireTableDataChanged();
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

