/*
 * Decompiled with CFR 0.152.
 */
package SocLab.core.structures;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;

class ActorRelation {
    public ActorNew actorNew;
    public RelationNew relationNew;
    private double strength;
    private double minStrength;
    private double maxStrength;
    private double individualStrength;
    private double minIndividualStrength;
    private double maxIndividualStrength;
    private double potentialStrength;
    private double minPotentialStrength;
    private double maxPotentialStrength;

    public ActorRelation() {
        this.actorNew = null;
        this.relationNew = null;
    }

    ActorRelation(ActorNew AN, RelationNew RN) {
        this.actorNew = AN;
        this.relationNew = RN;
    }

    public double getImpact(RelationNew rN, ActorNew aN, double s) {
        double res = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN2 = orgNew.getActorNew(aNames[i]);
            res += this.getImpactIndiv(rN, aN2, s) * aN.getTarget(aN2.getName()).getSolidarity();
            ++i;
        }
        return res;
    }

    public double getImpactIndiv(RelationNew rN, ActorNew aN, double s) {
        if (Double.isNaN(s)) {
            double effect = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF((rN.getRPNCurrent().getUpperBound() + rN.getRPNCurrent().getLowerBound()) / 2.0);
            double stake = rN.getDepend(aN.getName()).getStake();
            return effect * stake;
        }
        double effect = rN.getDepend(aN.getName()).getEffectNew().getFunction().getF(s);
        double stake = rN.getDepend(aN.getName()).getStake();
        return effect * stake;
    }

    public double getStrength(ActorNew aN, RelationNew rN) {
        double str = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN2 = orgNew.getActorNew(aNames[i]);
            str += this.getIndividualStrength(rN, aN2) * aN.getTarget(aN2.getName()).getSolidarity();
            ++i;
        }
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.strength = str;
        }
        return str;
    }

    double getIndividualStrength(RelationNew rN, ActorNew aN) {
        double indiv_strength = this.getPotentialStrength(rN, aN) * rN.getDepend(aN.getName()).getStake();
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.individualStrength = indiv_strength;
        }
        return indiv_strength;
    }

    public double getPotentialStrength(RelationNew rN, ActorNew aN) {
        double range = rN.getDepend(aN.getName()).getEffectNew().getFunction().getMax() - rN.getDepend(aN.getName()).getEffectNew().getFunction().getMin();
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.potentialStrength = range;
        }
        return range;
    }

    public double getStrengthMax(ActorNew aN, RelationNew rN) {
        double str = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN2 = orgNew.getActorNew(aNames[i]);
            str += this.getIndividualStrengthMax(rN, aN2) * aN.getTarget(aN2.getName()).getSolidarity();
            ++i;
        }
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.maxStrength = str;
        }
        return str;
    }

    double getIndividualStrengthMax(RelationNew rN, ActorNew aN) {
        double indiv_strength = this.getPotentialStrengthMax(rN, aN) * rN.getDepend(aN.getName()).getStake();
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.maxIndividualStrength = indiv_strength;
        }
        return indiv_strength;
    }

    public double getPotentialStrengthMax(RelationNew rN, ActorNew aN) {
        double max = rN.getDepend(aN.getName()).getEffectNew().getFunction().getMax();
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.maxPotentialStrength = max;
        }
        return max;
    }

    public double getStrengthMin(ActorNew aN, RelationNew rN) {
        double str = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < aNames.length) {
            ActorNew aN2 = orgNew.getActorNew(aNames[i]);
            str += this.getIndividualStrengthMin(rN, aN2) * aN.getTarget(aN2.getName()).getSolidarity();
            ++i;
        }
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.minStrength = str;
        }
        return str;
    }

    double getIndividualStrengthMin(RelationNew rN, ActorNew aN) {
        double indiv_strength = this.getPotentialStrengthMin(rN, aN) * rN.getDepend(aN.getName()).getStake();
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.minIndividualStrength = indiv_strength;
        }
        return indiv_strength;
    }

    public double getPotentialStrengthMin(RelationNew rN, ActorNew aN) {
        double min = rN.getDepend(aN.getName()).getEffectNew().getFunction().getMin();
        if (this.actorNew.getName().equals(aN.getName()) && this.relationNew.getName().equals(rN.getName())) {
            this.minPotentialStrength = min;
        }
        return min;
    }

    public double getStrength() {
        return this.strength;
    }

    public double getIndividualStrength() {
        return this.individualStrength;
    }

    public double getPotentialStrength() {
        return this.potentialStrength;
    }

    public ActorNew getActorNew() {
        return this.actorNew;
    }

    public void setActorNew(ActorNew AN) {
        this.actorNew = AN;
    }

    public RelationNew getRelationNew() {
        return this.relationNew;
    }

    public void setRelationNew(RelationNew RN) {
        this.relationNew = RN;
    }
}

