/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class GaussianFunction
extends AbstractFunction {
    private String type = "gaussian";

    public GaussianFunction(String name) {
        super(name);
        this.setType("gaussian");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("gaussian");
        this.paramNames = new String[]{"mu", "to", "a", "b"};
        this.setParam("mu", 0.0);
        this.setParam("to", 1.0);
        this.setParam("a", 5.0);
        this.setParam("b", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double puis;
        double mu = this.getParam("mu");
        double to = this.getParam("to");
        double a = this.getParam("a");
        double b = this.getParam("b");
        double co = 1.0 / (to * Math.sqrt(Math.PI * 2));
        double val = a * co * Math.pow(Math.E, puis = -Math.pow(x - mu, 2.0) / (2.0 * Math.pow(to, 2.0))) + b;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        double mu = this.getParam("mu");
        double to = this.getParam("to");
        double a = this.getParam("a");
        double b = this.getParam("b");
        return "f(x) = " + a + "*1/(" + to + "*(2\u0153\u00c4)^\u00ac\u03a9) * E^(-(x-" + mu + ")\u00ac\u2264/(2to\u00ac\u2264))+" + b;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

