/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class QuadraticFunction
extends AbstractFunction {
    private String type = "quadratic";

    public QuadraticFunction(String name) {
        super(name);
        this.setType("quadratic");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("quadratic");
        this.paramNames = new String[]{"a", "b", "c"};
        this.setParam("a", 1.0);
        this.setParam("b", 0.0);
        this.setParam("c", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double c;
        double b;
        double a = this.getParam("a") / 10.0;
        double val = a * x * x + (b = this.getParam("b") / 10.0) * x + (c = this.getParam("c"));
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        double a = this.getParam("a") / 10.0;
        double b = this.getParam("b") / 10.0;
        double c = this.getParam("c");
        return "f(x)=" + a + " * x^2 + " + b + " * x + " + c;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

