/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class Sigmoid2Function
extends AbstractFunction {
    private String type = "S2F";

    public Sigmoid2Function(String name) {
        super(name);
        this.setType("S2F");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("S2F");
        this.paramNames = new String[]{"a", "b", "c"};
        this.setParam("a", 1.0);
        this.setParam("b", 0.0);
        this.setParam("c", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double exp2;
        double a = this.getParam("a");
        double b = this.getParam("b");
        double c = this.getParam("c");
        double exp = Math.pow(Math.E, 2.0 * (x + c));
        double val = a * (1.0 / (1.0 + exp) - 1.0 / (1.0 + (exp2 = Math.pow(Math.E, -2.0 * (x + c))))) + b;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        double a = this.getParam("a");
        double b = this.getParam("b");
        double c = this.getParam("c");
        return "f(x) = " + a + "*(1/(1+E^2*(" + c + "+x)))-1/(1+E^-2*(" + c + "+x))) + " + b;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

