/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.interval.gui;

import SocLab.tools.interval.QualitativeScale;
import javax.swing.table.AbstractTableModel;

public class QualitativeScaleTableModel
extends AbstractTableModel {
    private QualitativeScale qualitativeScale;

    public QualitativeScaleTableModel(QualitativeScale qualitativeScale) {
        this.qualitativeScale = qualitativeScale;
    }

    @Override
    public int getColumnCount() {
        return this.qualitativeScale.getInterpretationsSize() + 1;
    }

    @Override
    public int getRowCount() {
        return this.qualitativeScale.getIntervalSerieSize();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.qualitativeScale.getIntervalAt(row).toString();
        }
        if (col == 1) {
            return this.qualitativeScale.getInterpretationAt(row);
        }
        return this.qualitativeScale.getNthInterpretationAt(col - 1, row);
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Interval";
        }
        if (col == 1) {
            return "Interpretation";
        }
        return "interpretation " + (col - 1);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.qualitativeScale.putNthInterpretation(col - 1, row, (String)value);
        this.fireTableCellUpdated(row, col);
    }
}

