/*
 * Decompiled with CFR 0.152.
 */
package controller.staticAnalysis;

import SocLab.GUI.desktop.DesktopFrame;
import controller.ControllerGenDoc;
import controller.staticAnalysis.Controller;
import graphGen.DependenceNetwork;
import gui.staticAnalysis.StaticResultsFrame;
import input.unmarshalling.UnmarshallException;
import input.unmarshalling.Unmarshaller;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import organization.Actor;
import organization.Organization;
import organization.Relation;
import staticParameters.MathLib;
import staticParameters.RelationAndExchangeTermPair;
import staticParameters.Satisfaction;
import staticParameters.StaticMath;

public class ControllerImpl
extends ControllerGenDoc
implements Controller {
    private HashMap<String, Actor> actorsHM;
    private HashMap<String, Relation> relationsHM;
    private Vector<String> actorsName;
    private Vector<String> relationsName;
    private Organization org;
    private String resultFile;
    private StaticResultsFrame guiStatic;
    private String resultName;
    private DesktopFrame desktopFrame;

    public ControllerImpl(DesktopFrame desktopFrame) {
        this.desktopFrame = desktopFrame;
        this.actorsHM = new HashMap();
        this.relationsHM = new HashMap();
        this.actorsName = new Vector();
        this.relationsName = new Vector();
    }

    @Override
    public void initialize(Organization organisation) {
        this.org = organisation;
        Collection<Actor> allActors = this.org.getActors();
        for (Actor actor : allActors) {
            this.actorsHM.put(actor.getName(), actor);
            this.actorsName.add(actor.getName());
        }
        Collection<Relation> allRelations = this.org.getRelations();
        for (Relation relation : allRelations) {
            this.relationsHM.put(relation.getName(), relation);
            this.relationsName.add(relation.getName());
        }
        this.addHeader("Organisation : " + this.org.getName());
    }

    @Override
    public Vector<String> getRelationsName() {
        return this.relationsName;
    }

    @Override
    public Vector<String> getRelationsNameInvolved(String actorName) {
        Actor actor = this.actorsHM.get(actorName);
        Collection<Relation> c = this.org.getRelationsInvolved(actor);
        Collection<Relation> rAll = this.org.getRelations();
        Vector<String> relationsNameInvolved = new Vector<String>(c.size());
        for (Relation r : rAll) {
            if (!c.contains(r)) continue;
            relationsNameInvolved.add(r.getName());
        }
        return relationsNameInvolved;
    }

    @Override
    public float getForceMax(String relationName) {
        Relation r = this.relationsHM.get(relationName);
        return StaticMath.forceMax(this.org, r, false);
    }

    @Override
    public float getForceMaxEffective(String relationName) {
        Relation r = this.relationsHM.get(relationName);
        return StaticMath.forceMax(this.org, r, true);
    }

    @Override
    public float getForceTotal(String relationName) {
        Relation r = this.relationsHM.get(relationName);
        return StaticMath.forceMax(this.org, r, false);
    }

    @Override
    public float getForceTotalEffective(String relationName) {
        Relation r = this.relationsHM.get(relationName);
        return StaticMath.forceMax(this.org, r, true);
    }

    @Override
    public float getRelevance(String relationName) {
        Relation r = this.relationsHM.get(relationName);
        return StaticMath.relevance(this.org, r);
    }

    @Override
    public Vector<String> getActorsName() {
        return this.actorsName;
    }

    @Override
    public float getAutonomy(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.autonomy(this.org, a);
    }

    @Override
    public float getSubordination(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.subordination(this.org, a);
    }

    @Override
    public float getSatisfactionMaxValue(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.satisfactionMax(this.org, a).getValue();
    }

    @Override
    public float getSatisfactionMinValue(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.satisfactionMin(this.org, a).getValue();
    }

    @Override
    public float getPower(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.power(this.org, a, false);
    }

    @Override
    public float getDependency(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.dependency(this.org, a);
    }

    @Override
    public float getSatisfaction(String actor, String relation, float te) {
        Actor a = this.actorsHM.get(actor);
        Relation r = this.relationsHM.get(relation);
        return StaticMath.satisfaction(this.org, a, r, te);
    }

    @Override
    public float getSatisfaction(String actor, Collection<Float> te) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.satisfaction(this.org, a, te);
    }

    @Override
    public Satisfaction getSatisfactionMin(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.satisfactionMin(this.org, a);
    }

    @Override
    public Satisfaction getSatisfactionMax(String actor) {
        Actor a = this.actorsHM.get(actor);
        return StaticMath.satisfactionMax(this.org, a);
    }

    @Override
    public Satisfaction getGlobalSatisfactionMin() {
        return StaticMath.satisfactionMinGlobal(this.org);
    }

    @Override
    public Satisfaction getGlobalSatisfactionMax() {
        return StaticMath.satisfactionMaxGlobal(this.org);
    }

    @Override
    public Collection<RelationAndExchangeTermPair> getNashBalance() {
        return StaticMath.nash(this.org);
    }

    @Override
    public Collection<RelationAndExchangeTermPair> getParetoOptimum() {
        return StaticMath.pareto(this.org);
    }

    @Override
    public Collection<Collection<Float>> sort(Collection<Collection<Float>> cc) {
        return MathLib.allConcatenations(cc);
    }

    @Override
    public JPanel getGraph() {
        DependenceNetwork dN = new DependenceNetwork(this.org);
        return dN.getPanelGraph(this);
    }

    @Override
    public float keepOnlyNDigits(float f, int nbDigits) {
        return MathLib.keepNDigits(f, nbDigits);
    }

    @Override
    public void loadResults(String orgXML, String paramXML, String resultsDir, String result) throws UnmarshallException {
        this.org = Unmarshaller.unmarshallOrgParam(orgXML, paramXML).getOrganization();
        this.initialize(this.org);
        this.resultFile = resultsDir;
        this.resultName = result;
        if (this.guiStatic != null) {
            this.guiStatic.dispose();
        }
        this.guiStatic = new StaticResultsFrame(this);
        this.desktopFrame.getDesktopPanel().add(this.guiStatic.getStaticOngletsJF());
    }

    @Override
    public String getCurrentDir() {
        return this.resultFile;
    }

    @Override
    public String getFileResultName() {
        return this.resultName;
    }
}

