/*
 * Decompiled with CFR 0.152.
 */
package graphGen;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import graphGen.actorSize.ActorSizeFunction;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSliderSizeActors
extends JSlider {
    private static final long serialVersionUID = 1L;
    private ActorSizeFunction asf;
    private VisualizationViewer vv;
    private float zoomMax;
    private float zoomMin;
    private static final int SLIDER_MAX = 100;
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MIDDLE = 50;

    public JSliderSizeActors(ActorSizeFunction asf, VisualizationViewer vv, float max, float min) throws Exception {
        super(0, 0, 100, 50);
        if (!(min < max && min <= 1.0f && max >= 1.0f && min > 0.0f && max > 0.0f)) {
            throw new Exception("min and max or not in the bounds");
        }
        this.zoomMax = max;
        this.zoomMin = min;
        this.asf = asf;
        this.vv = vv;
        this.addChangeListener(this.changeListener());
        float step = (max - min) / 100.0f;
        int middle = Math.round(new Float((1.0 - (double)min) / (double)step).floatValue());
        this.setMajorTickSpacing(middle);
        this.setValue(middle);
        this.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("x" + this.zoomMin));
        labelTable.put(new Integer(middle), new JLabel("x1"));
        labelTable.put(new Integer(100), new JLabel("x" + this.zoomMax));
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
    }

    protected float getZoom(float value) {
        return (this.zoomMax - this.zoomMin) * ((value - 0.0f) / 100.0f) + this.zoomMin;
    }

    public void setActorSizeFunction(ActorSizeFunction asf) {
        this.asf = asf;
    }

    private ChangeListener changeListener() {
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                float i = JSliderSizeActors.this.getValue();
                float coeff = JSliderSizeActors.this.getZoom(i);
                JSliderSizeActors.this.asf.setCoeffMult(coeff);
                JSliderSizeActors.this.vv.repaint();
            }
        };
        return cl;
    }
}

