/*
 * Decompiled with CFR 0.152.
 */
package graphGen;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import graphGen.DependenceNetwork;
import organization.Actor;
import organization.Organization;
import staticParameters.StaticMath;

public class VertexStringerLabel
implements VertexStringer {
    protected static final int NO_LABEL = 0;
    protected static final int LABEL_POWER = 1;
    protected static final int LABEL_DEPENDENCY = 2;
    protected static final int LABEL_AUTONOMY = 3;
    protected static final int LABEL_SUBORDINATION = 4;
    public static final int LABEL_SATIS_MAX = 5;
    public static final int LABEL_SATIS_MIN = 6;
    private int typeLabel = 0;
    private Organization org;

    public VertexStringerLabel(Organization o) {
        this.org = o;
    }

    public void setLabel(int type) {
        this.typeLabel = type;
    }

    public String getLabel(ArchetypeVertex v) {
        Actor a = (Actor)v.getUserDatum((Object)DependenceNetwork.actorKey);
        String label = a.getName();
        switch (this.typeLabel) {
            case 0: {
                break;
            }
            case 1: {
                label = String.valueOf(label) + " : " + StaticMath.power(this.org, a, false);
                break;
            }
            case 3: {
                label = String.valueOf(label) + " : " + StaticMath.autonomy(this.org, a);
                break;
            }
            case 4: {
                label = String.valueOf(label) + " : " + StaticMath.subordination(this.org, a);
                break;
            }
            case 2: {
                label = String.valueOf(label) + " : " + StaticMath.dependency(this.org, a);
                break;
            }
            case 5: {
                label = String.valueOf(label) + " : " + StaticMath.satisfactionMax(this.org, a).getValue();
                break;
            }
            case 6: {
                label = String.valueOf(label) + " : " + StaticMath.satisfactionMin(this.org, a).getValue();
                break;
            }
        }
        return label;
    }
}

