/*
 * Decompiled with CFR 0.152.
 */
package graphGen.actorSize;

import edu.uci.ics.jung.graph.Vertex;
import graphGen.DependenceNetwork;
import graphGen.actorSize.ActorSizeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import organization.Actor;
import organization.Organization;

public abstract class ActorSizeFunctionProp
extends ActorSizeFunction {
    protected boolean scale = true;
    private float max;
    private float min;
    protected Organization org;
    private static final float COEFF_MIN = 0.75f;
    private static final float COEFF_MAX = 1.75f;

    public ActorSizeFunctionProp(Organization o) {
        Collection<Actor> actors = o.getActors();
        this.org = o;
        ArrayList<Float> array = new ArrayList<Float>();
        for (Actor act : actors) {
            array.add(Float.valueOf(this.getValue(act)));
        }
        this.max = ((Float)Collections.max(array)).floatValue();
        this.min = ((Float)Collections.min(array)).floatValue();
    }

    protected abstract float getValue(Actor var1);

    public void unsetScaling() {
        this.scale = false;
    }

    public void setScaling(int scalingType) {
        this.scale = true;
    }

    @Override
    public int getSize(Vertex v) {
        if (this.scale && Double.compare(this.min, this.max) != 0) {
            Actor a = (Actor)v.getUserDatum((Object)DependenceNetwork.actorKey);
            float var = this.getValue(a);
            float coeff = (var - this.min) / (this.max - this.min) * 1.0f + 0.75f;
            int s = this.getSizeCoeff(20.0f * coeff);
            return s;
        }
        int s = this.getSizeCoeff(20.0f);
        return s;
    }
}

