/*
 * Decompiled with CFR 0.152.
 */
package gui.sensitiveness;

import gui.help.Help;
import gui.sensitiveness.GuiImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jdesktop.layout.GroupLayout;

public class DialogFormula
extends JDialog {
    private static final long serialVersionUID = 1L;
    GuiImpl parent = null;
    private JButton bouValidate;
    private JButton jButton1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList lstIsNotSelected;
    private JMenu menuHelp;
    private JMenuItem menuHelpFormula;
    private JTextPane txtFormula;

    public DialogFormula(GuiImpl parent, boolean modal, String[] vars, String formula) {
        super((Frame)((JFrame)parent.getDesktopPane().getRootPane().getParent()), modal);
        this.parent = parent;
        this.initComponents();
        this.initVar(vars);
        this.txtFormula.setText(formula);
    }

    private void initVar(String[] vars) {
        Vector<String> varSelected = new Vector<String>();
        String[] stringArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            varSelected.add(var);
            ++n2;
        }
        this.lstIsNotSelected.setListData(varSelected);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstIsNotSelected = new JList();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.bouValidate = new JButton();
        this.jButton1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.txtFormula = new JTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.menuHelp = new JMenu();
        this.menuHelpFormula = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Write a formula");
        this.setResizable(false);
        this.lstIsNotSelected.setEnabled(false);
        this.jScrollPane1.setViewportView(this.lstIsNotSelected);
        this.jLabel2.setText("Selected variables :");
        this.jLabel3.setText("Formula :");
        this.bouValidate.setText("Validate");
        this.bouValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFormula.this.bouValidateActionPerformed(evt);
            }
        });
        this.jButton1.setText("Check Formula");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFormula.this.jButton1ActionPerformed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.txtFormula);
        this.menuHelp.setText("?");
        this.menuHelpFormula.setText("Formula");
        this.menuHelpFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogFormula.this.menuHelpFormulaActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuHelpFormula);
        this.jMenuBar1.add(this.menuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add(238, 238, 238).add((Component)this.jButton1).add(6, 6, 6).add((Component)this.bouValidate)).add((GroupLayout.Group)layout.createSequentialGroup().add(124, 124, 124).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jScrollPane1, -2, 171, -2))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 408, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 176, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 79, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButton1).add((Component)this.bouValidate)).addContainerGap()));
        this.pack();
    }

    private void menuHelpFormulaActionPerformed(ActionEvent evt) {
        String txt = "Unary operators : + -\nBinary operators : ^ * / MOD + - (from the highest to the lowest priority)\nNo condition \nConstants : PI FALSE TRUE \nFunctions : LN LOG EXP SQR SQRT COS SIN TAN ACOS ASIN ATAN COSH SINH TANH \nINT ABS OPP\n\nThe parsed identifiers (name of a function and its parameters) may contain \nletters, digits, or the character _. The first character can't be a digit. \nThis syntax isn't case sensitive. ";
        new Help("Formula list", txt, this);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String form = this.txtFormula.getText();
        boolean isValid = this.parent.getController().validateFormula(form);
        if (!isValid) {
            JOptionPane.showConfirmDialog(this, "There is an error in the formula.", "Check formula", -1, 0);
            return;
        }
        JOptionPane.showConfirmDialog(this, "There is no error in the formula.", "Check formula", -1, 1);
    }

    private void bouValidateActionPerformed(ActionEvent evt) {
        String form = this.txtFormula.getText();
        if (form.trim().equals("")) {
            JOptionPane.showConfirmDialog(this, "The formula field is empty.", "Error", -1, 0);
            return;
        }
        boolean isValid = this.parent.getController().validateFormula(form);
        if (!isValid) {
            JOptionPane.showConfirmDialog(this, "There is an error in the formula.", "Error", -1, 0);
            return;
        }
        this.parent.setFormula(form);
        this.dispose();
    }
}

