/*
 * Decompiled with CFR 0.152.
 */
package gui.sensitiveness;

import controller.EmptyException;
import controller.sensitiveness.Controller;
import controller.sensitiveness.ImpossibleSlopeException;
import gui.help.Help;
import gui.sensitiveness.DialogFormula;
import gui.sensitiveness.DialogRenameVars;
import gui.sensitiveness.FileFilterByExt;
import gui.sensitiveness.Gui;
import input.WrongFormException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class GuiImpl
extends JInternalFrame
implements Gui {
    private static final long serialVersionUID = 1L;
    Controller control = null;
    private JButton bouGraphAddToDoc;
    private JButton bouGraphChoose;
    private JButton bouGraphDrawIt;
    private JCheckBox chkNormalize;
    private JMenuBar jMenuBar2;
    private JLabel labGraphGraph;
    private JLabel labGraphInput;
    private JLabel labGraphOutput;
    private JLabel labGraphTitle;
    private JLabel labelAddToDocG;
    private JLabel labelGraphComment;
    private JLabel labelTitleGraph;
    private JComboBox lstGraphGraph;
    private JComboBox lstGraphOutput;
    private JMenu menuExport;
    private JMenuItem menuExportFile;
    private JMenu menuFile1;
    private JMenu menuHelp;
    private JMenuItem menuHelpManual;
    private JMenuItem menuOpen1;
    private JPanel panelGraphStat;
    private JScrollPane scroolGraphComment;
    private JTextArea txtGraphComment;
    private JTextField txtGraphInput;
    private JTextField txtGraphTitle;
    public boolean update = false;

    public GuiImpl(Controller control) {
        this.control = control;
        this.initComponents();
        this.setEnabledComponent(false);
    }

    private void initComponents() {
        this.labGraphInput = new JLabel();
        this.txtGraphInput = new JTextField();
        this.bouGraphChoose = new JButton();
        this.labGraphOutput = new JLabel();
        this.lstGraphOutput = new JComboBox();
        this.labGraphGraph = new JLabel();
        this.lstGraphGraph = new JComboBox();
        this.bouGraphDrawIt = new JButton();
        this.panelGraphStat = new JPanel();
        this.labGraphTitle = new JLabel();
        this.labelGraphComment = new JLabel();
        this.txtGraphTitle = new JTextField();
        this.scroolGraphComment = new JScrollPane();
        this.txtGraphComment = new JTextArea();
        this.bouGraphAddToDoc = new JButton();
        this.labelAddToDocG = new JLabel();
        this.labelTitleGraph = new JLabel();
        this.chkNormalize = new JCheckBox();
        this.jMenuBar2 = new JMenuBar();
        this.menuFile1 = new JMenu();
        this.menuOpen1 = new JMenuItem();
        this.menuExport = new JMenu();
        this.menuExportFile = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuHelpManual = new JMenuItem();
        this.setTitle("Sensitiveness");
        this.labGraphInput.setText("Input :");
        this.txtGraphInput.setEnabled(false);
        this.bouGraphChoose.setText("Write...");
        this.bouGraphChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouGraphChooseActionPerformed(evt);
            }
        });
        this.labGraphOutput.setText("Output :");
        this.lstGraphOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.lstGraphOutputActionPerformed(evt);
            }
        });
        this.labGraphGraph.setText("Graph :");
        this.bouGraphDrawIt.setText("Draw it");
        this.bouGraphDrawIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouGraphDrawItActionPerformed(evt);
            }
        });
        this.panelGraphStat.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout panelGraphStatLayout = new GroupLayout((Container)this.panelGraphStat);
        this.panelGraphStat.setLayout((LayoutManager)panelGraphStatLayout);
        panelGraphStatLayout.setHorizontalGroup((GroupLayout.Group)panelGraphStatLayout.createParallelGroup(1).add(0, 550, Short.MAX_VALUE));
        panelGraphStatLayout.setVerticalGroup((GroupLayout.Group)panelGraphStatLayout.createParallelGroup(1).add(0, 243, Short.MAX_VALUE));
        this.labGraphTitle.setText("Title :");
        this.labelGraphComment.setText("Comment :");
        this.txtGraphComment.setColumns(20);
        this.txtGraphComment.setRows(5);
        this.scroolGraphComment.setViewportView(this.txtGraphComment);
        this.bouGraphAddToDoc.setText("Add to report");
        this.bouGraphAddToDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouGraphAddToDocActionPerformed(evt);
            }
        });
        this.labelAddToDocG.setForeground(Color.red);
        this.labelTitleGraph.setFont(new Font("Tahoma", 1, 12));
        this.labelTitleGraph.setForeground(Color.red);
        this.labelTitleGraph.setHorizontalAlignment(0);
        this.chkNormalize.setText("is normalized");
        this.chkNormalize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNormalize.setMargin(new Insets(0, 0, 0, 0));
        this.menuFile1.setText("File");
        this.menuOpen1.setText("Open");
        this.menuOpen1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuOpen1ActionPerformed(evt);
            }
        });
        this.menuFile1.add(this.menuOpen1);
        this.jMenuBar2.add(this.menuFile1);
        this.menuExport.setText("Export");
        this.menuExportFile.setText("Export into a file");
        this.menuExportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuExportFileActionPerformed(evt);
            }
        });
        this.menuExport.add(this.menuExportFile);
        this.jMenuBar2.add(this.menuExport);
        this.menuHelp.setText("?");
        this.menuHelpManual.setText("Help");
        this.menuHelpManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuHelpManualActionPerformed(evt);
            }
        });
        this.setJMenuBar(this.jMenuBar2);
        this.jMenuBar2.add(this.menuHelp);
        this.setJMenuBar(this.jMenuBar2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.labGraphTitle, -2, 60, -2).add((Component)this.labelGraphComment)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.scroolGraphComment, -1, 470, Short.MAX_VALUE).add((Component)this.txtGraphTitle, -1, 470, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.labelAddToDocG, -2, 415, -2).addPreferredGap(0).add((Component)this.bouGraphAddToDoc).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.chkNormalize).addPreferredGap(0, 388, Short.MAX_VALUE).add((Component)this.bouGraphDrawIt).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.labGraphOutput, -1, 41, Short.MAX_VALUE).add((Component)this.labGraphInput, -1, 41, Short.MAX_VALUE).add((Component)this.labGraphGraph, -1, 41, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.txtGraphInput, -1, 412, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bouGraphChoose)).add((Component)this.lstGraphGraph, 0, 489, Short.MAX_VALUE).add((Component)this.lstGraphOutput, 0, 489, Short.MAX_VALUE)).addContainerGap()).add((Component)this.panelGraphStat, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.labelTitleGraph, -2, 534, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bouGraphChoose).add((Component)this.labGraphInput).add((Component)this.txtGraphInput, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labGraphOutput).add((Component)this.lstGraphOutput, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labGraphGraph).add((Component)this.lstGraphGraph, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bouGraphDrawIt).add((Component)this.chkNormalize)).addPreferredGap(0).add((Component)this.labelTitleGraph, -2, 32, -2).addPreferredGap(0).add((Component)this.panelGraphStat, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labGraphTitle).add((Component)this.txtGraphTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.labelGraphComment).add(99, 99, 99)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.scroolGraphComment, -2, 107, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bouGraphAddToDoc).add((Component)this.labelAddToDocG, -2, 16, -2))));
        this.pack();
    }

    private void menuHelpManualActionPerformed(ActionEvent evt) {
        String txt = "1   Charger Le plan d\u00d4\u00f8\u03a9exp\u00d4\u00f8\u03a9rience \n================================ \n \nPour importer le plan d\u00d4\u00f8\u03a9exp\u00d4\u00f8\u03a9rience, il faut choisir le dossier o\u00d4\u00f8\u03a9 se trouvent ces r\u00d4\u00f8\u03a9sultats. Pour cela  \nil faut d\u00d4\u00f8\u03a9abord cliquer sur File, puis sur Open\u00d4\u00f8\u03a9 \nEnsuite, s\u00d4\u00f8\u03a9lectionnez le dossier des plans d\u00d4\u00f8\u03a9exp\u00d4\u00f8\u03a9rience, puis cliquez sur Select. \nAttention, il ne faut pas rentrer \u00d4\u00f8\u03a9 l\u00d4\u00f8\u03a9int\u00d4\u00f8\u03a9rieur du dossier, il suffit de cliquer sur ce dossier et  \nensuite de cliquer sur select. \n \n   \n2   Choix des param\u00d4\u00f8\u03a9tres de variation \n===================================== \n \nApres avoir s\u00d4\u00f8\u03a9lectionn\u00d4\u00f8\u03a9 le plan d\u00d4\u00f8\u03a9exp\u00d4\u00f8\u03a9rience, une fen\u00d4\u00f8\u03a9tre appara\u00d4\u00f8\u03a9t et vous pouvez d\u00d4\u00f8\u03a9terminer les  \nparam\u00d4\u00f8\u03a9tres qui ont vari\u00d4\u00f8\u03a9s lors de l\u00d4\u00f8\u03a9exp\u00d4\u00f8\u03a9rience. \nPour cela cliquez sur un des param\u00d4\u00f8\u03a9tres de l\u00d4\u00f8\u03a9organisation (encadr\u00d4\u00f8\u03a9 de gauche) puis sur la double fl\u00d4\u00f8\u03a9che  \ndroite. Il appara\u00d4\u00f8\u03a9t alors dans la liste de droite qui sera les param\u00d4\u00f8\u03a9tres de variation. R\u00d4\u00f8\u03a9p\u00d4\u00f8\u03a9ter l\u00d4\u00f8\u03a9op\u00d4\u00f8\u03a9ration  \nautant de fois que n\u00d4\u00f8\u03a9cessaire. \nIl est \u00d4\u00f8\u03a9 noter que les param\u00d4\u00f8\u03a9tres peuvent \u00d4\u00f8\u03a9tre renomm\u00d4\u00f8\u03a9s pour plus de commodit\u00d4\u00f8\u03a9. Pour cela, entrez le nouveau  \nnom dans l\u00d4\u00f8\u03a9encadr\u00d4\u00f8\u03a9 du milieu, puis cliquez sur la double fl\u00d4\u00f8\u03a9che droite. Le nouveau nom appara\u00d4\u00f8\u03a9tra \u00d4\u00f8\u03a9 droite  \navec le vrai nom du param\u00d4\u00f8\u03a9tre entre parenth\u00d4\u00f8\u03a9ses. \n \n \n3   Saisir une formule \n====================== \n \nLe module donne la possibilit\u00d4\u00f8\u03a9 de tracer le graphe de corr\u00d4\u00f8\u03a9lation pour une sortie de synth\u00d4\u00f8\u03a9se et une  \nformule compos\u00d4\u00f8\u03a9e de param\u00d4\u00f8\u03a9tres d\u00d4\u00f8\u03a9entr\u00d4\u00f8\u03a9e. Pour saisir cette formule, cliquer sur Write\u00d4\u00f8\u03a9 \nLa fen\u00d4\u00f8\u03a9tre suivante appara\u00d4\u00f8\u03a9t. Saisir la formule dans l\u00d4\u00f8\u03a9encadr\u00d4\u00f8\u03a9, les param\u00d4\u00f8\u03a9tres en entr\u00d4\u00f8\u03a9e sont rappel\u00d4\u00f8\u03a9s  \nen haut.  \nLa validit\u00d4\u00f8\u03a9 de la formule peut \u00d4\u00f8\u03a9tre v\u00d4\u00f8\u03a9rifi\u00d4\u00f8\u03a9e en cliquant sur Check Formula.  \nUne fois la formule correcte saisie, cliquer sur Validate. \n \n  \n4   G\u00d4\u00f8\u03a9n\u00d4\u00f8\u03a9rer un graphe \n===================== \n \nApr\u00d4\u00f8\u03a9s avoir s\u00d4\u00f8\u03a9lectionn\u00d4\u00f8\u03a9 une formule en entr\u00d4\u00f8\u03a9e, choisir le r\u00d4\u00f8\u03a9sultat de synth\u00d4\u00f8\u03a9se en Output avec lequel  \non veut \u00d4\u00f8\u03a9tudier la corr\u00d4\u00f8\u03a9lation.  \nChoisir dans Graph le graphe \u00d4\u00f8\u03a9 g\u00d4\u00f8\u03a9n\u00d4\u00f8\u03a9rer puis cliquer Draw it. \nLe graphe appara\u00d4\u00f8\u03a9t dans le panneau du milieu. \n \n \n5   Cr\u00d4\u00f8\u03a9ation du document RTF \n============================ \n \n5.1 Ajout d\u00d4\u00f8\u03a9un graphique au document \n------------------------------------ \n \nPour ajouter un graphique au document, ce graphique doit \u00d4\u00f8\u03a9tre visible dans la vue de gauche, ensuite  \nchoisissez un titre et un commentaire pour ce graphique, puis cliquez sur le bouton Add to report. \nLe nombre d\u00d4\u00f8\u03a9ajouts est illimit\u00d4\u00f8\u03a9. \n \n5.2 Edition du document  \n----------------------- \n \nUne fois que tous les onglets voulus sont ajout\u00d4\u00f8\u03a9s au document, cliquer sur Export, puis sur Export into  \na file.  \nUn document au format RTF est cr\u00d4\u00f8\u03a9\u00d4\u00f8\u03a9 et peut \u00d4\u00f8\u03a9tre lu avec Word et OpenOffice. \n";
        new Help("Help", txt, this);
    }

    private void menuExportFileActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.control.getCurrentDir()));
            chooser.setFileFilter(new FileFilterByExt("rtf"));
            int ret = chooser.showDialog(this, "Create");
            File file = chooser.getSelectedFile();
            if (ret != 1 && file != null) {
                String dirName = file.getParent();
                String fileName = file.getName();
                this.control.setDocName(dirName, fileName);
                String docName = this.control.createDoc();
                JOptionPane.showConfirmDialog(this, "A new file is generated\n" + docName, "New file", -1, 1);
            }
        }
        catch (EmptyException e) {
            e.printStackTrace();
            JOptionPane.showConfirmDialog(this, "The document is empty", "Error", -1, 0);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Error during the generation", "Error", -1, 0);
            return;
        }
    }

    private void lstGraphOutputActionPerformed(ActionEvent evt) {
        String input = this.txtGraphInput.getText();
        String output = (String)this.lstGraphOutput.getSelectedItem();
        this.updateList(this.lstGraphGraph, this.control.getCurvingNames(output, input));
    }

    private void menuOpen1ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int ret = chooser.showDialog(this, "Select");
        if (ret != 1 && chooser.getSelectedFile() != null) {
            try {
                this.control.loadResults(chooser.getSelectedFile().getAbsolutePath());
            }
            catch (WrongFormException wfEx) {
                JOptionPane.showConfirmDialog(this, "Error loading results:\n" + wfEx.getMessage(), "Error", -1, 0);
                return;
            }
            catch (IOException ioEx) {
                JOptionPane.showConfirmDialog(this, "Error reading results:\n" + ioEx.getMessage(), "Error", -1, 0);
                return;
            }
            this.setEnabledComponent(false);
            this.labGraphInput.setEnabled(true);
            this.bouGraphChoose.setEnabled(true);
            DialogRenameVars.initVar(this.control.getVariableNames());
            DialogRenameVars dialog = new DialogRenameVars(this, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.txtGraphInput.setText("");
        }
    }

    private void bouGraphChooseActionPerformed(ActionEvent evt) {
        DialogFormula diag = new DialogFormula(this, true, DialogRenameVars.getVarsChoosen(), this.txtGraphInput.getText());
        diag.setLocationRelativeTo(this);
        diag.setVisible(true);
    }

    private void bouGraphDrawItActionPerformed(ActionEvent evt) {
        String str;
        String input = this.txtGraphInput.getText();
        String output = (String)this.lstGraphOutput.getSelectedItem();
        String graph = (String)this.lstGraphGraph.getSelectedItem();
        boolean isNormalize = this.chkNormalize.isSelected();
        JPanel panel = new JPanel();
        try {
            panel = this.control.getGraph(output, input, graph, isNormalize);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Error during the graph generation", "Error", -1, 0);
            return;
        }
        this.panelGraphStat.removeAll();
        panel.setSize(this.panelGraphStat.getSize());
        this.panelGraphStat.add(panel);
        this.panelGraphStat.repaint();
        this.labelTitleGraph.setText(graph);
        this.txtGraphTitle.setText(graph);
        try {
            str = this.control.getComment(graph);
        }
        catch (ImpossibleSlopeException e) {
            JOptionPane.showConfirmDialog(this, e.getMessage(), "Error", -1, 0);
            return;
        }
        this.txtGraphComment.setText(str);
    }

    private void bouGraphAddToDocActionPerformed(ActionEvent evt) {
        if (this.panelGraphStat.getComponentCount() < 1) {
            return;
        }
        String title = this.txtGraphTitle.getText();
        if (title.equals("")) {
            title = this.labelTitleGraph.getText();
        }
        String comment = this.txtGraphComment.getText();
        JPanel panel = (JPanel)this.panelGraphStat.getComponent(0);
        this.control.addGraphToDoc(panel, title, comment);
        this.txtGraphComment.setText("");
        this.txtGraphTitle.setText("");
        this.labelAddToDocG.setText("The chart \"" + title + "\" is add to the future document");
    }

    private void updateList(JComboBox combo, String[] list) {
        if (this.update) {
            return;
        }
        this.update = true;
        combo.removeAllItems();
        this.update = false;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            combo.addItem(str);
            ++n2;
        }
    }

    public Controller getController() {
        return this.control;
    }

    public void setFormula(String f) {
        this.txtGraphInput.setText(f);
        this.updateList(this.lstGraphOutput, this.control.getOutputNames());
        this.setEnabledComponent(true);
    }

    private void setEnabledComponent(boolean enable) {
        Component[] components;
        Container c = this.getContentPane();
        Component[] componentArray = components = c.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setEnabled(enable);
            ++n2;
        }
        this.txtGraphComment.setEnabled(enable);
        this.menuExport.setEnabled(enable);
        this.txtGraphInput.setEnabled(false);
    }

    @Override
    public void launch() {
        this.setVisible(true);
    }
}

