/*
 * Decompiled with CFR 0.152.
 */
package gui.sensitivity;

import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import controller.sensitivity.Controller;
import gui.sensitivity.Gui;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jdesktop.layout.GroupLayout;

public class GuiImpl
extends JInternalFrame
implements Gui {
    private static final long serialVersionUID = 1L;
    OrgNew orgNew = SocLabToolkit.currentOrgNew;
    private Controller control;
    private JButton bouValidD;
    private JComboBox comboparamxD;
    private JComboBox comboTypeD;
    private JComboBox comboVariableD;
    private JLabel jLabelTitreGrapheD;
    private JLabel labelparamxD;
    private JLabel labelVariableD;
    private JPanel panelD;
    private JPanel panelStatD;
    private JRadioButton radioActorD;
    private ButtonGroup radioD;
    private JRadioButton radioRelationD;
    private JRadioButton radionbstepsD;
    private JButton bouAddToDocG;
    private JButton bouValidG;
    private JComboBox comboparamxG;
    private JComboBox comboTypeG;
    private JComboBox comboVariableG;
    private JLabel jLabelTitreGrapheG;
    private JMenuBar jMenuBar1;
    private JLabel labelCommentG;
    private JLabel labelparamxG;
    private JLabel labelTitleG;
    private JLabel labelVariableG;
    private JMenu menuFile;
    private JMenuItem menuOpen;
    private JPanel panelG;
    private JPanel panelStatG;
    private JRadioButton radioActorG;
    private ButtonGroup radioG;
    private JRadioButton radioRelationG;
    private JRadioButton radionbstepsG;
    private JScrollPane scrollCommentG;
    private JTextPane txtCommentG;
    private JTextField txtTitleG;
    int priorite = -1;

    public GuiImpl(Controller control_) {
        this.setName("GUI Sensitivity Synthesis");
        this.setDefaultCloseOperation(1);
        this.control = control_;
        this.initComponents();
        this.disableOption();
        this.disableSaisie();
    }

    public void setControl(Controller control_) {
        this.initComponents();
        this.disableOption();
        this.disableSaisie();
    }

    private void initComponents() {
        this.radioG = new ButtonGroup();
        this.radioD = new ButtonGroup();
        this.panelG = new JPanel();
        this.comboVariableG = new JComboBox();
        this.radioActorG = new JRadioButton();
        this.radioRelationG = new JRadioButton();
        this.radionbstepsG = new JRadioButton();
        this.labelVariableG = new JLabel();
        this.comboparamxG = new JComboBox();
        this.labelparamxG = new JLabel();
        this.bouValidG = new JButton();
        this.panelStatG = new JPanel();
        this.comboTypeG = new JComboBox();
        this.bouAddToDocG = new JButton();
        this.txtTitleG = new JTextField();
        this.labelTitleG = new JLabel();
        this.labelCommentG = new JLabel();
        this.scrollCommentG = new JScrollPane();
        this.txtCommentG = new JTextPane();
        this.jLabelTitreGrapheG = new JLabel();
        this.panelD = new JPanel();
        this.comboVariableD = new JComboBox();
        this.radioActorD = new JRadioButton();
        this.radioRelationD = new JRadioButton();
        this.radionbstepsD = new JRadioButton();
        this.labelVariableD = new JLabel();
        this.comboparamxD = new JComboBox();
        this.labelparamxD = new JLabel();
        this.bouValidD = new JButton();
        this.panelStatD = new JPanel();
        this.comboTypeD = new JComboBox();
        this.jLabelTitreGrapheD = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuOpen = new JMenuItem();
        this.getContentPane().setLayout(new GridLayout(1, 2));
        this.setTitle("Result analysis sensibility" + SocLabToolkit.currentOrgNew.getCurrentSensitivityPath());
        this.panelG.setBorder(BorderFactory.createEtchedBorder());
        this.radioG.add(this.radioActorG);
        this.radioActorG.setSelected(true);
        this.radioActorG.setText("Actor");
        this.radioActorG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioActorG.setMargin(new Insets(0, 0, 0, 0));
        this.radioActorG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioActorGActionPerformed(evt);
            }
        });
        this.radioG.add(this.radioRelationG);
        this.radioRelationG.setText("Relation");
        this.radioRelationG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioRelationG.setMargin(new Insets(0, 0, 0, 0));
        this.radioRelationG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioRelationGActionPerformed(evt);
            }
        });
        this.radioG.add(this.radionbstepsG);
        this.radionbstepsG.setText("nb steps");
        this.radionbstepsG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radionbstepsG.setMargin(new Insets(0, 0, 0, 0));
        this.radionbstepsG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radionbstepsGActionPerformed(evt);
            }
        });
        this.labelVariableG.setText("result (Y):");
        this.labelparamxG.setText("variable parameter (X):");
        if (this.orgNew.getSensitivityParameters() != null) {
            int i = 0;
            while (i < this.orgNew.getSensitivityParameters().length) {
                this.comboparamxG.addItem(this.orgNew.getSensitivityParameters()[i]);
                ++i;
            }
        }
        this.comboparamxG.addItem("num experience");
        this.comboparamxG.addItem("nb steps");
        this.bouValidG.setText("Draw it");
        this.bouValidG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouValidGActionPerformed(evt);
            }
        });
        this.panelStatG.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout panelStatGLayout = new GroupLayout((Container)this.panelStatG);
        this.panelStatG.setLayout((LayoutManager)panelStatGLayout);
        panelStatGLayout.setHorizontalGroup((GroupLayout.Group)panelStatGLayout.createParallelGroup(1).add(0, 439, Short.MAX_VALUE));
        panelStatGLayout.setVerticalGroup((GroupLayout.Group)panelStatGLayout.createParallelGroup(1).add(0, 184, Short.MAX_VALUE));
        this.comboTypeG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboTypeGActionPerformed(evt);
            }
        });
        this.bouAddToDocG.setText("Add to report");
        this.bouAddToDocG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouAddToDocGActionPerformed(evt);
            }
        });
        this.labelTitleG.setText("Title :");
        this.labelCommentG.setText("Comment :");
        this.scrollCommentG.setViewportView(this.txtCommentG);
        this.jLabelTitreGrapheG.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitreGrapheG.setForeground(Color.red);
        this.jLabelTitreGrapheG.setHorizontalAlignment(0);
        GroupLayout panelGLayout = new GroupLayout((Container)this.panelG);
        this.panelG.setLayout((LayoutManager)panelGLayout);
        panelGLayout.setHorizontalGroup((GroupLayout.Group)panelGLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panelGLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelGLayout.createParallelGroup(2).add(1, (Component)this.panelStatG, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelTitreGrapheG, -2, 443, -2).add(1, (GroupLayout.Group)panelGLayout.createSequentialGroup().add((GroupLayout.Group)panelGLayout.createParallelGroup(2, false).add((Component)this.labelparamxG, -1, -1, Short.MAX_VALUE).add((Component)this.labelVariableG, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(2).add((Component)this.comboparamxG, 0, 378, Short.MAX_VALUE).add((Component)this.comboVariableG, 0, 378, Short.MAX_VALUE).add(1, (GroupLayout.Group)panelGLayout.createSequentialGroup().add((Component)this.radioActorG).addPreferredGap(0).add((Component)this.radioRelationG).addPreferredGap(0).add((Component)this.radionbstepsG).addPreferredGap(0)).add((Component)this.comboTypeG, 0, 378, Short.MAX_VALUE))).add(1, (GroupLayout.Group)panelGLayout.createSequentialGroup().add((GroupLayout.Group)panelGLayout.createParallelGroup(2, false).add(1, (Component)this.labelCommentG, -1, -1, Short.MAX_VALUE).add(1, (Component)this.labelTitleG, -1, 60, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(1).add((Component)this.scrollCommentG, -1, 379, Short.MAX_VALUE).add((Component)this.txtTitleG, -1, 379, Short.MAX_VALUE))).add((GroupLayout.Group)panelGLayout.createSequentialGroup().addPreferredGap(0, 6, Short.MAX_VALUE).add((Component)this.bouAddToDocG)).add((Component)this.bouValidG)).addContainerGap()));
        panelGLayout.setVerticalGroup((GroupLayout.Group)panelGLayout.createParallelGroup(1).add((GroupLayout.Group)panelGLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.radioActorG).add((Component)this.radioRelationG).add((Component)this.radionbstepsG)).addPreferredGap(0).add((Component)this.comboTypeG, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.labelVariableG).add((Component)this.comboVariableG, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.labelparamxG).add((Component)this.comboparamxG, -2, -1, -2)).addPreferredGap(0).add((Component)this.bouValidG).addPreferredGap(0).add((Component)this.jLabelTitreGrapheG, -2, 30, -2).addPreferredGap(0).add((Component)this.panelStatG, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.txtTitleG, -2, -1, -2).add((Component)this.labelTitleG)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(1).add((GroupLayout.Group)panelGLayout.createSequentialGroup().add((Component)this.scrollCommentG, -2, 67, -2).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.bouAddToDocG))).add((Component)this.labelCommentG)).addContainerGap()));
        this.getContentPane().add(this.panelG);
        this.panelD.setBorder(BorderFactory.createEtchedBorder());
        this.radioD.add(this.radioActorD);
        this.radioActorD.setSelected(true);
        this.radioActorD.setText("Actor");
        this.radioActorD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioActorD.setMargin(new Insets(0, 0, 0, 0));
        this.radioActorD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioActorDActionPerformed(evt);
            }
        });
        this.radioD.add(this.radioRelationD);
        this.radioRelationD.setText("Relation");
        this.radioRelationD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioRelationD.setMargin(new Insets(0, 0, 0, 0));
        this.radioRelationD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioRelationDActionPerformed(evt);
            }
        });
        this.radioD.add(this.radionbstepsD);
        this.radionbstepsD.setText("nb steps");
        this.radionbstepsD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radionbstepsD.setMargin(new Insets(0, 0, 0, 0));
        this.radionbstepsD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radionbstepsDActionPerformed(evt);
            }
        });
        this.labelVariableD.setText("result (Y):");
        this.labelparamxD.setText("variable parameter (X):");
        if (this.orgNew.getSensitivityParameters() != null) {
            int i = 0;
            while (i < this.orgNew.getSensitivityParameters().length) {
                this.comboparamxD.addItem(this.orgNew.getSensitivityParameters()[i]);
                ++i;
            }
        }
        this.comboparamxD.addItem("num experience");
        this.comboparamxD.addItem("nb steps");
        this.bouValidD.setText("Draw it");
        this.bouValidD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouValidDActionPerformed(evt);
            }
        });
        this.panelStatD.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout panelStatDLayout = new GroupLayout((Container)this.panelStatD);
        this.panelStatD.setLayout((LayoutManager)panelStatDLayout);
        panelStatDLayout.setHorizontalGroup((GroupLayout.Group)panelStatDLayout.createParallelGroup(1).add(0, 439, Short.MAX_VALUE));
        panelStatDLayout.setVerticalGroup((GroupLayout.Group)panelStatDLayout.createParallelGroup(1).add(0, 184, Short.MAX_VALUE));
        this.comboTypeD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboTypeDActionPerformed(evt);
            }
        });
        this.jLabelTitreGrapheD.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitreGrapheD.setForeground(Color.red);
        this.jLabelTitreGrapheD.setHorizontalAlignment(0);
        GroupLayout panelDLayout = new GroupLayout((Container)this.panelD);
        this.panelD.setLayout((LayoutManager)panelDLayout);
        panelDLayout.setHorizontalGroup((GroupLayout.Group)panelDLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panelDLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelDLayout.createParallelGroup(2).add(1, (Component)this.panelStatD, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelTitreGrapheD, -2, 443, -2).add(1, (GroupLayout.Group)panelDLayout.createSequentialGroup().add((GroupLayout.Group)panelDLayout.createParallelGroup(2, false).add((Component)this.labelparamxD, -1, -1, Short.MAX_VALUE).add((Component)this.labelVariableD, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(2).add((Component)this.comboparamxD, 0, 378, Short.MAX_VALUE).add((Component)this.comboVariableD, 0, 378, Short.MAX_VALUE).add(1, (GroupLayout.Group)panelDLayout.createSequentialGroup().add((Component)this.radioActorD).addPreferredGap(0).add((Component)this.radioRelationD).addPreferredGap(0).add((Component)this.radionbstepsD).addPreferredGap(0)).add((Component)this.comboTypeD, 0, 378, Short.MAX_VALUE))).add(1, (GroupLayout.Group)panelDLayout.createSequentialGroup().add((GroupLayout.Group)panelDLayout.createParallelGroup(2, false)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(1))).add((GroupLayout.Group)panelDLayout.createSequentialGroup().addPreferredGap(0, 6, Short.MAX_VALUE)).add((Component)this.bouValidD)).addContainerGap()));
        panelDLayout.setVerticalGroup((GroupLayout.Group)panelDLayout.createParallelGroup(1).add((GroupLayout.Group)panelDLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.radioActorD).add((Component)this.radioRelationD).add((Component)this.radionbstepsD)).addPreferredGap(0).add((Component)this.comboTypeD, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.labelVariableD).add((Component)this.comboVariableD, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.labelparamxD).add((Component)this.comboparamxD, -2, -1, -2)).addPreferredGap(0).add((Component)this.bouValidD).addPreferredGap(0).add((Component)this.jLabelTitreGrapheD, -2, 30, -2).addPreferredGap(0).add((Component)this.panelStatD, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(1).add((GroupLayout.Group)panelDLayout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3)))).addContainerGap()));
        this.getContentPane().add(this.panelD);
        this.menuFile.setText("File");
        this.menuOpen.setText("Open...");
        this.menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuOpen);
        this.jMenuBar1.add(this.menuFile);
        this.pack();
    }

    private void bouAddToDocGActionPerformed(ActionEvent evt) {
        String title = this.txtTitleG.getText();
        String comment = this.txtCommentG.getText();
        JPanel panel = (JPanel)this.panelStatG.getComponent(0);
        if (title.equals("")) {
            title = this.jLabelTitreGrapheG.getText();
        }
        this.control.addGraphToReport(panel, title, comment);
        this.txtCommentG.setText("");
        this.txtTitleG.setText("");
    }

    private void comboTypeGActionPerformed(ActionEvent evt) {
        this.updateVariable(this.radioActorG, this.radioRelationG, this.radionbstepsG, this.comboTypeG, this.comboVariableG);
    }

    private void comboTypeDActionPerformed(ActionEvent evt) {
        this.updateVariable(this.radioActorD, this.radioRelationD, this.radionbstepsD, this.comboTypeD, this.comboVariableD);
    }

    private void menuOpenActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int ret = chooser.showDialog(this, "Select");
        if (ret != 1 && chooser.getSelectedFile() != null) {
            this.setTitle("Result analysis sensibility" + chooser.getSelectedFile());
            try {
                this.control.loadResults(chooser.getSelectedFile().getAbsolutePath());
                this.updateGUI();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showConfirmDialog(this, "Error", "Error", -1, 0);
                return;
            }
            this.enableOption();
            this.updateType(this.radioActorG, this.radioRelationG, this.comboTypeG);
        }
    }

    public void updateGUI() {
        this.enableOption();
        this.updateType(this.radioActorG, this.radioRelationG, this.comboTypeG);
        this.updateVariable(this.radioActorG, this.radioRelationG, this.radionbstepsG, this.comboTypeG, this.comboVariableG);
        this.updateType(this.radioActorD, this.radioRelationD, this.comboTypeD);
        this.updateVariable(this.radioActorD, this.radioRelationD, this.radionbstepsD, this.comboTypeD, this.comboVariableD);
    }

    private void bouValidGActionPerformed(ActionEvent evt) {
        this.updateGraphic(this.radioActorG, this.radioRelationG, this.radionbstepsG, this.comboTypeG, this.comboVariableG, this.comboparamxG, this.panelStatG, this.jLabelTitreGrapheG, this.txtTitleG);
    }

    private void radioRelationGActionPerformed(ActionEvent evt) {
        this.updateType(this.radioActorG, this.radioRelationG, this.comboTypeG);
        this.updateVariable(this.radioActorG, this.radioRelationG, this.radionbstepsG, this.comboTypeG, this.comboVariableG);
    }

    private void radioActorGActionPerformed(ActionEvent evt) {
        this.updateType(this.radioActorG, this.radioRelationG, this.comboTypeG);
        this.updateVariable(this.radioActorG, this.radioRelationG, this.radionbstepsG, this.comboTypeG, this.comboVariableG);
    }

    private void radionbstepsGActionPerformed(ActionEvent evt) {
        this.updateVariable(this.radioActorG, this.radioRelationG, this.radionbstepsG, this.comboTypeG, this.comboVariableG);
    }

    private void bouValidDActionPerformed(ActionEvent evt) {
        this.updateGraphic(this.radioActorD, this.radioRelationD, this.radionbstepsD, this.comboTypeD, this.comboVariableD, this.comboparamxD, this.panelStatD, this.jLabelTitreGrapheD, null);
    }

    private void radioRelationDActionPerformed(ActionEvent evt) {
        this.updateType(this.radioActorD, this.radioRelationD, this.comboTypeD);
        this.updateVariable(this.radioActorD, this.radioRelationD, this.radionbstepsD, this.comboTypeD, this.comboVariableD);
    }

    private void radioActorDActionPerformed(ActionEvent evt) {
        this.updateType(this.radioActorD, this.radioRelationD, this.comboTypeD);
        this.updateVariable(this.radioActorD, this.radioRelationD, this.radionbstepsD, this.comboTypeD, this.comboVariableD);
    }

    private void radionbstepsDActionPerformed(ActionEvent evt) {
        this.updateVariable(this.radioActorD, this.radioRelationD, this.radionbstepsD, this.comboTypeD, this.comboVariableD);
    }

    private void enableOption() {
        this.comboVariableG.setEnabled(true);
        this.comboTypeG.setEnabled(true);
        this.bouValidG.setEnabled(true);
        this.radioActorG.setEnabled(true);
        this.radioRelationG.setEnabled(true);
        this.radionbstepsG.setEnabled(true);
        this.labelVariableG.setEnabled(true);
        this.comboparamxG.setEnabled(true);
        this.labelparamxG.setEnabled(true);
        this.comboVariableD.setEnabled(true);
        this.comboTypeD.setEnabled(true);
        this.bouValidD.setEnabled(true);
        this.radioActorD.setEnabled(true);
        this.radioRelationD.setEnabled(true);
        this.radionbstepsD.setEnabled(true);
        this.labelVariableD.setEnabled(true);
        this.comboparamxD.setEnabled(true);
        this.labelparamxD.setEnabled(true);
    }

    private void disableOption() {
        this.comboVariableG.setEnabled(false);
        this.comboTypeG.setEnabled(false);
        this.bouValidG.setEnabled(false);
        this.radioActorG.setEnabled(false);
        this.radioRelationG.setEnabled(false);
        this.radionbstepsG.setEnabled(false);
        this.labelVariableG.setEnabled(false);
        this.comboparamxG.setEnabled(false);
        this.labelparamxG.setEnabled(false);
        this.comboVariableD.setEnabled(false);
        this.comboTypeD.setEnabled(false);
        this.bouValidD.setEnabled(false);
        this.radioActorD.setEnabled(false);
        this.radioRelationD.setEnabled(false);
        this.radionbstepsD.setEnabled(false);
        this.labelVariableD.setEnabled(false);
        this.comboparamxD.setEnabled(false);
        this.labelparamxD.setEnabled(false);
    }

    private void enableSaisie() {
        this.bouAddToDocG.setEnabled(true);
        this.labelTitleG.setEnabled(true);
        this.labelCommentG.setEnabled(true);
        this.scrollCommentG.setEnabled(true);
        this.txtCommentG.setEnabled(true);
        this.txtTitleG.setEnabled(true);
    }

    private void disableSaisie() {
        this.bouAddToDocG.setEnabled(false);
        this.labelTitleG.setEnabled(false);
        this.labelCommentG.setEnabled(false);
        this.txtCommentG.setEnabled(false);
        this.scrollCommentG.setEnabled(false);
        this.txtTitleG.setEnabled(false);
    }

    private void updateType(JRadioButton radioActor, JRadioButton radioRelation, JComboBox comboToUpdate) {
        int i;
        if (this.priorite > 2) {
            return;
        }
        this.priorite = 2;
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        }
        String[] exp = this.control.getNameCategory(type);
        String temp = null;
        if (comboToUpdate.getItemCount() > 0) {
            temp = comboToUpdate.getSelectedItem().toString();
        }
        comboToUpdate.removeAllItems();
        if (exp != null) {
            i = 0;
            while (i < exp.length) {
                comboToUpdate.addItem(exp[i]);
                ++i;
            }
        }
        if (temp != null) {
            i = 0;
            while (i < exp.length) {
                if (comboToUpdate.getItemAt(i).toString().equals(temp)) {
                    comboToUpdate.setSelectedIndex(i);
                }
                ++i;
            }
        }
        comboToUpdate.setEnabled(comboToUpdate.getItemCount() > 1);
        this.priorite = -1;
    }

    private void updateVariable(JRadioButton radioActor, JRadioButton radioRelation, JRadioButton radionbsteps, JComboBox comboType, JComboBox comboToUpdate) {
        if (this.priorite > 1) {
            return;
        }
        this.priorite = 1;
        String idType = null;
        if (comboType.getSelectedIndex() >= 0) {
            idType = (String)comboType.getSelectedItem();
        }
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        } else if (radionbsteps.isSelected()) {
            type = 3;
            comboType.removeAllItems();
            comboToUpdate.removeAllItems();
            comboType.setEnabled(false);
            comboToUpdate.setEnabled(false);
        }
        if (!radionbsteps.isSelected()) {
            int i;
            String[] exp = this.control.getVariables(type, idType);
            String temp = null;
            if (comboToUpdate.getItemCount() > 0) {
                temp = comboToUpdate.getSelectedItem().toString();
            }
            comboToUpdate.removeAllItems();
            if (exp != null) {
                i = 0;
                while (i < exp.length) {
                    comboToUpdate.addItem(exp[i]);
                    ++i;
                }
            }
            if (temp != null) {
                i = 0;
                while (i < exp.length) {
                    if (comboToUpdate.getItemAt(i).toString().equals(temp)) {
                        comboToUpdate.setSelectedIndex(i);
                    }
                    ++i;
                }
            }
            comboToUpdate.setEnabled(comboToUpdate.getItemCount() > 1);
        }
        this.priorite = -1;
    }

    private void updateGraphic(JRadioButton radioActor, JRadioButton radioRelation, JRadioButton radionbsteps, JComboBox comboType, JComboBox comboVar, JComboBox comboparamx, JPanel toShow, JLabel jLabelToTitle, JTextField title) {
        String idGraph = null;
        String idType = null;
        if (comboType.getSelectedIndex() >= 0) {
            idType = (String)comboType.getSelectedItem();
        }
        String idVar = null;
        idVar = comboVar.getSelectedIndex() >= 0 ? (String)comboVar.getSelectedItem() : "nb steps";
        String idEntree = null;
        if (comboparamx.getSelectedIndex() >= 0) {
            idEntree = (String)comboparamx.getSelectedItem();
        }
        if (idType != null) {
            if (idType.equals("moyenne")) {
                idGraph = "value of mean " + idVar + " according to " + idEntree;
            } else if (idVar.equals("satisfaction")) {
                idGraph = idType.equals("tous les acteurs") ? "value of " + idVar + " for all actors according to " + idEntree : "value of " + idVar + " for actor " + idType + " according to " + idEntree;
            } else if (idVar.equals("influence")) {
                idGraph = idType.equals("tous les acteurs") ? "value of " + idVar + " for all actors according to " + idEntree : "value of " + idVar + " for actor " + idType + " according to " + idEntree;
            } else if (idVar.equals("aim")) {
                idGraph = idType.equals("tous les acteurs") ? "value of " + idVar + " for all actors according to " + idEntree : "value of " + idVar + " for actor " + idType + " according to " + idEntree;
            } else if (idVar.equals("relation state")) {
                idGraph = idType.equals("toutes les relations") ? "value of " + idVar + " for all relations according to " + idEntree : "value of " + idVar + " for relation " + idType + " according to " + idEntree;
            }
        } else {
            idGraph = "value of " + idVar + " according to " + idEntree;
        }
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        } else if (radionbsteps.isSelected()) {
            type = 3;
            if (idEntree.equals("nb steps")) {
                idGraph = "choose another abcisse parameter";
            }
        }
        JPanel panel = this.control.getGraphic(type, idType, idVar, idGraph, idEntree);
        toShow.removeAll();
        panel.setSize(toShow.getSize());
        toShow.add(panel);
        toShow.repaint();
        jLabelToTitle.setText(idGraph);
        if (title != null) {
            title.setText(jLabelToTitle.getText());
        }
        this.enableSaisie();
    }

    @Override
    public void launch() {
        this.setVisible(true);
    }
}

