/*
 * Decompiled with CFR 0.152.
 */
package gui.staticAnalysis;

import controller.staticAnalysis.Controller;
import gui.staticAnalysis.TableModelCellNotEditable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ActorJPanel {
    private JTable actorTable;
    private JPanel actorPanel;
    private Controller controller;
    private int nbParameters = 6;

    public ActorJPanel(Controller controller_) {
        this.controller = controller_;
    }

    public void createActorJTable() {
        String[] actorParameters = new String[]{"Actor", "Autonomy", "Subordination", "Power", "Dependency", "Satisfaction max", "Satisfaction min"};
        Vector<String> actorsName = this.controller.getActorsName();
        String[][] actorData = new String[actorsName.size()][actorParameters.length];
        int i = 0;
        while (i < actorsName.size()) {
            String actorName;
            actorData[i][0] = actorName = actorsName.get(i);
            float autonomy = this.controller.getAutonomy(actorName);
            actorData[i][1] = Float.toString(autonomy);
            float subordination = this.controller.getSubordination(actorName);
            actorData[i][2] = Float.toString(subordination);
            float power = this.controller.getPower(actorName);
            actorData[i][3] = Float.toString(power);
            float dependency = this.controller.getDependency(actorName);
            actorData[i][4] = Float.toString(dependency);
            float satisfMax = this.controller.getSatisfactionMaxValue(actorName);
            actorData[i][5] = Float.toString(satisfMax);
            float satisfMin = this.controller.getSatisfactionMinValue(actorName);
            actorData[i][6] = Float.toString(satisfMin);
            ++i;
        }
        TableModelCellNotEditable dataModel = new TableModelCellNotEditable(actorData, actorParameters);
        this.actorTable = new JTable(dataModel);
    }

    public JPanel getActorJPanel() {
        if (this.actorPanel == null) {
            this.actorPanel = new JPanel();
            this.actorPanel.setLayout(new BorderLayout());
            TableColumn column = null;
            int i = 0;
            while (i <= this.nbParameters) {
                column = this.actorTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(100);
                ++i;
            }
            this.actorPanel.add((Component)this.actorTable.getTableHeader(), "North");
            this.actorPanel.add((Component)this.actorTable, "South");
        }
        return this.actorPanel;
    }
}

