/*
 * Decompiled with CFR 0.152.
 */
package gui.staticAnalysis;

import controller.EmptyException;
import controller.staticAnalysis.Controller;
import gui.staticAnalysis.ActorJPanel;
import gui.staticAnalysis.AddDocForResultsFrame;
import gui.staticAnalysis.ChooseXMLPanel;
import gui.staticAnalysis.ParametersFormula;
import gui.staticAnalysis.RelationJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class StaticResultsFrame {
    private JInternalFrame staticOngletsJF = null;
    private JPanel staticOngletsContainer = null;
    private JTabbedPane staticOngletsJTB = null;
    private JPanel graphJP = null;
    private JPanel actorJP = null;
    private JPanel relationJP = null;
    private JPanel jPAllActor = null;
    private JPanel jPAllRelation = null;
    private JPanel jPAllBalances = null;
    private Controller controler;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenu = null;
    private JMenuItem jMenuItemOpen = null;
    private JMenu jMenuExport = null;
    private JMenu jMenuHelp = null;
    private JMenuItem jMenuItemExport = null;
    private JMenuItem jMenuItemHelp = null;
    private JMenuItem jMenuItemQuit = null;

    public StaticResultsFrame(Controller control) {
        this.controler = control;
        this.initJF();
        this.staticOngletsJF.pack();
        this.staticOngletsJF.setVisible(true);
        this.staticOngletsJF.setSize(new Dimension(438, 335));
    }

    public void dispose() {
        this.staticOngletsJF.dispose();
    }

    private JInternalFrame initJF() {
        if (this.staticOngletsJF == null) {
            this.staticOngletsJF = new JInternalFrame("Static results", true, true, true, true);
            this.staticOngletsJF.setSize(new Dimension(438, 335));
            this.staticOngletsJF.setJMenuBar(this.getJJMenuBar());
            this.staticOngletsJF.setContentPane(this.getStaticOngletsContainer());
        }
        return this.staticOngletsJF;
    }

    public JInternalFrame getStaticOngletsJF() {
        return this.staticOngletsJF;
    }

    public void setStaticOngletsJF(JInternalFrame staticOngletsJF) {
        this.staticOngletsJF = staticOngletsJF;
    }

    private JPanel getStaticOngletsContainer() {
        if (this.staticOngletsContainer == null) {
            this.staticOngletsContainer = new JPanel();
            this.staticOngletsContainer.setLayout(new BoxLayout(this.getStaticOngletsContainer(), 1));
            this.staticOngletsContainer.add((Component)this.getStaticOngletsJTB(), null);
        }
        return this.staticOngletsContainer;
    }

    private JTabbedPane getStaticOngletsJTB() {
        if (this.staticOngletsJTB == null) {
            this.staticOngletsJTB = new JTabbedPane();
            JScrollPane jspActor = new JScrollPane(this.getActorJP());
            JScrollPane jspRelation = new JScrollPane(this.getRelationJP());
            this.staticOngletsJTB.addTab("Graph", null, this.getGraphJP(), null);
            this.staticOngletsJTB.addTab("Actor", null, jspActor, null);
            this.staticOngletsJTB.addTab("Relation", null, jspRelation, null);
            this.jPAllBalances = new JPanel();
            this.jPAllBalances.setLayout(new BorderLayout());
            JScrollPane jspm = new JScrollPane(this.jPAllBalances);
            this.staticOngletsJTB.addTab("Significant states", null, jspm, null);
        }
        return this.staticOngletsJTB;
    }

    private JPanel getGraphJP() {
        if (this.graphJP == null) {
            this.graphJP = this.controler.getGraph();
        }
        return this.graphJP;
    }

    private JPanel getActorJP() {
        if (this.actorJP == null) {
            ActorJPanel actorAJP = new ActorJPanel(this.controler);
            actorAJP.createActorJTable();
            this.actorJP = actorAJP.getActorJPanel();
            AddDocForResultsFrame jPAddDoc = new AddDocForResultsFrame(this.controler, "Actors", this.actorJP);
            jPAddDoc.setTitle("Actors Parameters");
            this.jPAllActor = new JPanel();
            this.jPAllActor.setLayout(new BorderLayout());
            this.jPAllActor.add((Component)this.actorJP, "North");
            this.jPAllActor.add((Component)jPAddDoc, "West");
        }
        return this.jPAllActor;
    }

    private JPanel getRelationJP() {
        if (this.relationJP == null) {
            RelationJPanel relationAJP = new RelationJPanel(this.controler);
            relationAJP.createRelationJTable();
            this.relationJP = relationAJP.getRelationJPanel();
            AddDocForResultsFrame jPAddDoc = new AddDocForResultsFrame(this.controler, "Relations", this.relationJP);
            jPAddDoc.setTitle("Relations Parameters");
            this.jPAllRelation = new JPanel();
            this.jPAllRelation.setLayout(new BorderLayout());
            this.jPAllRelation.add((Component)this.relationJP, "North");
            this.jPAllRelation.add((Component)jPAddDoc, "West");
        }
        return this.jPAllRelation;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getJMenu());
            this.jJMenuBar.add(this.getJMenuExport());
            this.jJMenuBar.add(this.getJMenuHelp());
        }
        return this.jJMenuBar;
    }

    private JMenu getJMenu() {
        if (this.jMenu == null) {
            this.jMenu = new JMenu();
            this.jMenu.setText("File");
            this.jMenu.add(this.getJMenuItemOpen());
            this.jMenu.add(this.getJMenuItemQuit());
        }
        return this.jMenu;
    }

    private JMenuItem getJMenuItemOpen() {
        if (this.jMenuItemOpen == null) {
            this.jMenuItemOpen = new JMenuItem("Open XML files");
            ActionListener listenerOpen = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ChooseXMLPanel(StaticResultsFrame.this.controler);
                }
            };
            this.jMenuItemOpen.addActionListener(listenerOpen);
        }
        return this.jMenuItemOpen;
    }

    private JMenu getJMenuExport() {
        if (this.jMenuExport == null) {
            this.jMenuExport = new JMenu();
            this.jMenuExport.setText("Export");
            this.jMenuExport.add(this.getJMenuItemExport());
        }
        return this.jMenuExport;
    }

    private JMenu getJMenuHelp() {
        if (this.jMenuHelp == null) {
            this.jMenuHelp = new JMenu();
            this.jMenuHelp.setText("?");
            this.jMenuHelp.add(this.getJMenuItemHelp());
        }
        return this.jMenuHelp;
    }

    private JMenuItem getJMenuItemHelp() {
        if (this.jMenuItemHelp == null) {
            this.jMenuItemHelp = new JMenuItem("Parameters formula");
            ActionListener listenerHelp = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ParametersFormula();
                }
            };
            this.jMenuItemHelp.addActionListener(listenerHelp);
        }
        return this.jMenuItemHelp;
    }

    private JMenuItem getJMenuItemExport() {
        if (this.jMenuItemExport == null) {
            this.jMenuItemExport = new JMenuItem("Export into a file");
            ActionListener listenerExport = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String docName = StaticResultsFrame.this.controler.createDoc();
                        JOptionPane.showConfirmDialog(StaticResultsFrame.this.staticOngletsJF, "A new file is generated\n" + docName, "New file", -1, 1);
                    }
                    catch (EmptyException ee) {
                        ee.printStackTrace();
                        JOptionPane.showConfirmDialog(StaticResultsFrame.this.staticOngletsJF, "The document is empty", "Error", -1, 0);
                        return;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        JOptionPane.showConfirmDialog(StaticResultsFrame.this.staticOngletsJF, "Error during the generation", "Error", -1, 0);
                        return;
                    }
                }
            };
            this.jMenuItemExport.addActionListener(listenerExport);
        }
        return this.jMenuItemExport;
    }

    private JMenuItem getJMenuItemQuit() {
        if (this.jMenuItemQuit == null) {
            this.jMenuItemQuit = new JMenuItem("Quit");
            ActionListener listenerExport = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int res = JOptionPane.showConfirmDialog(StaticResultsFrame.this.staticOngletsJF, "Are you sure you want to quit?", "Error", 0, 3);
                    switch (res) {
                        case 0: {
                            StaticResultsFrame.this.staticOngletsJF.dispose();
                            break;
                        }
                    }
                }
            };
            this.jMenuItemQuit.addActionListener(listenerExport);
        }
        return this.jMenuItemQuit;
    }
}

