/*
 * Decompiled with CFR 0.152.
 */
package input.sensitiveness;

import input.WrongFormException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Experiment {
    private String organization = "";
    private int nbConv = 0;
    private double percentConv = 0.0;
    private int nbVarSimulation = 0;
    private int nbActors = 0;
    private int nbRelations = 0;
    private int nbVarActor = 0;
    private int nbVarRelation = 0;
    private HashMap<String, Double> experiment = new HashMap();
    private String[] nameVar;
    private BufferedReader experimentFileReader;

    public Experiment(String file) throws FileNotFoundException {
        this.experimentFileReader = new BufferedReader(new FileReader(file));
    }

    public HashMap<String, Double> getExperiment() {
        return this.experiment;
    }

    public double getOutputValue(String output) throws Exception {
        Double value = this.experiment.get(output);
        if (value != null) {
            return value;
        }
        throw new Exception(String.valueOf(output) + " is not an output variable name");
    }

    public String getOrganization() {
        return this.organization;
    }

    public int getNbConv() {
        return this.nbConv;
    }

    public double getPercentConv() {
        return this.percentConv;
    }

    public int getNbVarSimulation() {
        return this.nbVarSimulation;
    }

    public int getNbActors() {
        return this.nbActors;
    }

    public int getNbRelations() {
        return this.nbRelations;
    }

    public void getDatas() throws WrongFormException, IOException {
        String datas = null;
        String ligne = null;
        while ((ligne = this.experimentFileReader.readLine()) != null) {
            datas = String.valueOf(datas) + ligne + "\n";
        }
        this.experimentFileReader.close();
        StringTokenizer token = new StringTokenizer(datas, "\t\n");
        try {
            int j;
            int index;
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("the file is empty");
            }
            this.organization = token.nextToken().substring(4);
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of simulation variable would be wrote after organisation");
            }
            this.nbVarSimulation = Integer.parseInt(token.nextToken());
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of actors would be wrote after number of simulation variable");
            }
            this.nbActors = Integer.parseInt(token.nextToken());
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of relations would be wrote after number of actors");
            }
            this.nbRelations = Integer.parseInt(token.nextToken());
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of actors variable would be wrote after number of relations");
            }
            this.nbVarActor = Integer.parseInt(token.nextToken());
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of relation variable would be wrote after number of actor variable");
            }
            this.nbVarRelation = Integer.parseInt(token.nextToken());
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of converging observations would be wrote after number of relation variable");
            }
            this.nbConv = Integer.parseInt(token.nextToken());
            this.experiment.put("nbConv", new Double(this.nbConv));
            if (!token.hasMoreTokens()) {
                throw new WrongFormException("number of percentage of converging observations would be wrote after number of converging variable");
            }
            this.percentConv = Integer.parseInt(token.nextToken());
            this.experiment.put("percentConv", this.percentConv);
            this.initArray();
            int nbVar = this.nbVarSimulation + this.nbActors + this.nbRelations + this.nbVarActor * this.nbActors + this.nbVarRelation * this.nbRelations;
            for (index = 0; index < nbVar; ++index) {
                if (token.hasMoreTokens()) {
                    this.nameVar[index] = token.nextToken();
                    continue;
                }
                throw new WrongFormException("there is not enough variable name");
            }
            index = 0;
            int i = 0;
            while (i < this.nbVarSimulation) {
                if (!token.hasMoreTokens()) {
                    throw new WrongFormException("there is not enough mean value of simulation variable");
                }
                this.experiment.put("mean" + this.nameVar[index], new Double(token.nextToken()));
                if (!token.hasMoreTokens()) {
                    throw new WrongFormException("there is not enough deviation value of simulation variable");
                }
                this.experiment.put("deviation" + this.nameVar[index], new Double(token.nextToken()));
                ++index;
                ++i;
            }
            i = 0;
            while (i < this.nbActors) {
                if (!token.hasMoreTokens()) {
                    throw new WrongFormException("there is not enough mean value of satisfaction");
                }
                this.experiment.put("mean" + this.nameVar[index], new Double(token.nextToken()));
                if (!token.hasMoreTokens()) {
                    throw new WrongFormException("there is not enough deviation value of satisfaction");
                }
                this.experiment.put("deviation" + this.nameVar[index], new Double(token.nextToken()));
                ++index;
                ++i;
            }
            i = 0;
            while (i < this.nbRelations) {
                if (!token.hasMoreTokens()) {
                    throw new WrongFormException("there is not enough mean value of relation state");
                }
                this.experiment.put("mean" + this.nameVar[index], new Double(token.nextToken()));
                if (!token.hasMoreTokens()) {
                    throw new WrongFormException("there is not enough deviation value of relation state");
                }
                this.experiment.put("deviation" + this.nameVar[index], new Double(token.nextToken()));
                ++index;
                ++i;
            }
            i = 0;
            while (i < this.nbVarActor) {
                j = 0;
                while (j < this.nbActors) {
                    if (!token.hasMoreTokens()) {
                        throw new WrongFormException("there is not enough mean value of actor variable");
                    }
                    this.experiment.put("mean" + this.nameVar[index], new Double(token.nextToken()));
                    if (!token.hasMoreTokens()) {
                        throw new WrongFormException("there is not enough deviation value of actor variable");
                    }
                    this.experiment.put("deviation" + this.nameVar[index], new Double(token.nextToken()));
                    ++index;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.nbVarRelation) {
                j = 0;
                while (j < this.nbRelations) {
                    if (!token.hasMoreTokens()) {
                        throw new WrongFormException("there is not enough mean value of relation variable");
                    }
                    this.experiment.put("mean" + this.nameVar[index], new Double(token.nextToken()));
                    if (!token.hasMoreTokens()) {
                        throw new WrongFormException("there is not enough deviation value of relation variable");
                    }
                    this.experiment.put("deviation" + this.nameVar[index], new Double(token.nextToken()));
                    ++index;
                    ++j;
                }
                ++i;
            }
        }
        catch (WrongFormException w) {
            throw w;
        }
        catch (Exception e) {
            throw new WrongFormException("a variable don't have the good type");
        }
    }

    private void initArray() {
        int nbElement = this.nbVarSimulation + this.nbActors + this.nbRelations + this.nbVarActor * this.nbActors + this.nbVarRelation * this.nbRelations;
        this.nameVar = new String[nbElement];
    }
}

