/*
 * Decompiled with CFR 0.152.
 */
package interpretFormula;

import com.eteks.parser.CompiledFunction;
import com.eteks.parser.FunctionParser;
import interpretFormula.Interpretation;
import java.util.HashMap;

public class InterpretationImpl
implements Interpretation {
    @Override
    public boolean isValid(String function) {
        FunctionParser parser = new FunctionParser();
        try {
            parser.compileFunction(function);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isTransformableIntoFunction(String formula, String[] varPossible) {
        StringBuffer function = new StringBuffer("f(");
        int i = 0;
        while (i < varPossible.length) {
            function = function.append(varPossible[i]);
            if (i != varPossible.length - 1) {
                function = function.append(',');
            }
            ++i;
        }
        function = function.append(")=");
        FunctionParser parser = new FunctionParser();
        try {
            parser.compileFunction(String.valueOf(function.toString()) + formula);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String transformIntoFunction(String formula, String[] varPossible) throws Exception {
        StringBuffer function = new StringBuffer("f(");
        int i = 0;
        while (i < varPossible.length) {
            function = function.append(varPossible[i]);
            if (i != varPossible.length - 1) {
                function = function.append(',');
            }
            ++i;
        }
        function = function.append(")=");
        FunctionParser parser = new FunctionParser();
        try {
            parser.compileFunction(String.valueOf(function.toString()) + formula);
            return String.valueOf(function.toString()) + formula;
        }
        catch (Exception e) {
            throw new Exception("getFunctionValue_FunctionInterpreter: non valid formula/parameters combination");
        }
    }

    @Override
    public double interpretFormula(String f, double[] parameters) throws Exception {
        CompiledFunction cF = null;
        try {
            FunctionParser parser = new FunctionParser();
            cF = parser.compileFunction(f);
        }
        catch (Exception e) {
            throw new Exception("getFunctionValue_FunctionInterpreter: non valid function or parameters number");
        }
        double result = cF.computeFunction(parameters);
        Double res = new Double(result);
        if (res.toString().equals("NaN")) {
            throw new Exception("getFunctionValue_FunctionInterpreter:NaN, maybe a division by zero");
        }
        return result;
    }

    @Override
    public double interpretFormula(String f, HashMap<String, Double> parameters) throws Exception {
        CompiledFunction cF = null;
        try {
            FunctionParser parser = new FunctionParser();
            cF = parser.compileFunction(f);
        }
        catch (Exception e) {
            throw new Exception("getFunctionValue_FunctionInterpreter: non valid function");
        }
        String[] params = cF.getParameters();
        double[] paramsValue = new double[params.length];
        int i = 0;
        while (i < params.length) {
            Double d = parameters.get(params[i]);
            if (d == null) {
                throw new Exception("getFunctionValue_FunctionInterpreter: non valid parameters (number or name)");
            }
            paramsValue[i] = d;
            ++i;
        }
        double result = cF.computeFunction(paramsValue);
        Double res = new Double(result);
        if (res.toString().equals("NaN")) {
            throw new Exception("getFunctionValue_FunctionInterpreter:NaN, maybe a division by zero");
        }
        return result;
    }
}

