/*
 * Decompiled with CFR 0.152.
 */
package organization;

import java.util.Collection;
import java.util.Vector;
import organization.Actor;
import organization.Effect;
import organization.Organization;
import organization.Relation;
import organization.Solidarity;
import organization.Stake;

public class OrganizationImpl
implements Organization {
    private String name;
    private String description;
    private int nbActors;
    private int nbRelations;
    private float bonus;
    private float discrimination;
    private float initialStrength;
    private Vector<Relation> relations;
    private Vector<Actor> actors;
    private Vector<Stake> stakes;
    private Vector<Solidarity> solidarities;

    public OrganizationImpl(String name_, String description_, int nbActors_, int nbRelations_, float bonus_, float discrimination_, float initialStrength_, Vector<Relation> relations_, Vector<Actor> actors_, Vector<Stake> stakes_, Vector<Solidarity> solidarities_) {
        this.name = name_;
        this.description = description_;
        this.nbActors = nbActors_;
        this.nbRelations = nbRelations_;
        this.bonus = bonus_;
        this.discrimination = discrimination_;
        this.initialStrength = initialStrength_;
        this.relations = relations_;
        this.actors = actors_;
        this.stakes = stakes_;
        this.solidarities = solidarities_;
    }

    public OrganizationImpl(String name_, String description_, int nbActors_, int nbRelations_, int bonus_, int discrimination_, int initialStrength_, Vector<Relation> relations_, Vector<Actor> actors_, Vector<Stake> stakes_, Vector<Solidarity> solidarities_) {
        this(name_, description_, nbActors_, nbRelations_, (float)bonus_, (float)discrimination_, (float)initialStrength_, relations_, actors_, stakes_, solidarities_);
    }

    public OrganizationImpl(String name_, String description_, int nbActors_, int nbRelations_, Vector<Relation> relations_, Vector<Actor> actors_, Vector<Stake> stakes_, Vector<Solidarity> solidarities_) {
        this(name_, description_, nbActors_, nbRelations_, 0.0f, 0.0f, 0.0f, relations_, actors_, stakes_, solidarities_);
    }

    public OrganizationImpl(String name_, String description_, int nbActors_, int nbRelations_, Vector<Relation> relations_, Vector<Actor> actors_) {
        this(name_, description_, nbActors_, nbRelations_, 0.0f, 0.0f, 0.0f, relations_, actors_, new Vector<Stake>(), new Vector<Solidarity>());
    }

    public OrganizationImpl() {
        this("", "", 0, 0, 0.0f, 0.0f, 0.0f, new Vector<Relation>(), new Vector<Actor>(), new Vector<Stake>(), new Vector<Solidarity>());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getNbActors() {
        return this.nbActors;
    }

    @Override
    public int getNbRelations() {
        return this.nbRelations;
    }

    @Override
    public float getBonus() {
        return this.bonus;
    }

    @Override
    public float getDiscrimination() {
        return this.discrimination;
    }

    @Override
    public float getInitialStrength() {
        return this.initialStrength;
    }

    public Vector<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public Collection<Relation> getRelationsControledBy(Actor a) {
        Vector<Relation> relContByA = new Vector<Relation>();
        for (Relation rel : this.relations) {
            if (!rel.getActorController().equals(a)) continue;
            relContByA.add(rel);
        }
        return relContByA;
    }

    public Vector<Relation> getRelationsSufferedBy(Actor a) {
        Vector<Relation> relSuffByA = new Vector<Relation>();
        for (Relation rel : this.relations) {
            boolean isInvolved = false;
            for (Effect eff : rel.getEffects()) {
                if (!eff.getActor().equals(a)) continue;
                isInvolved = true;
            }
            if (!isInvolved || rel.getActorController().equals(a)) continue;
            relSuffByA.add(rel);
        }
        return relSuffByA;
    }

    @Override
    public Collection<Relation> getRelationsInvolved(Actor a) {
        Collection relSuffByA = this.getRelationsSufferedBy(a);
        Collection<Relation> relContByA = this.getRelationsControledBy(a);
        relContByA.addAll(relSuffByA);
        return relContByA;
    }

    @Override
    public Relation getRelation(int i) {
        return this.relations.get(i);
    }

    @Override
    public Relation getRelation(String name) {
        Relation relation = null;
        for (Relation rel : this.relations) {
            if (!rel.getName().equals(name)) continue;
            relation = rel;
        }
        return relation;
    }

    public Vector<Actor> getActors() {
        return this.actors;
    }

    @Override
    public Actor getActor(int i) {
        return this.actors.get(i);
    }

    @Override
    public Actor getActor(String name) {
        Actor actor = null;
        for (Actor act : this.actors) {
            if (!act.getName().equals(name)) continue;
            actor = act;
        }
        return actor;
    }

    @Override
    public Collection<Solidarity> getSolidarities() {
        return this.solidarities;
    }

    public Vector<Solidarity> getSolidaritiesWithActor(Actor a) {
        Vector<Solidarity> solidarWithA = new Vector<Solidarity>();
        for (Solidarity solidar : this.solidarities) {
            if (!solidar.getActorFrom().equals(a) && !solidar.getActorTo().equals(a)) continue;
            solidarWithA.add(solidar);
        }
        return solidarWithA;
    }

    @Override
    public Solidarity getSolidarity(int i) {
        return this.solidarities.get(i);
    }

    @Override
    public Collection<Stake> getStakes() {
        return this.stakes;
    }

    public Vector<Stake> getStakesWithRelation(Relation r) {
        Vector<Stake> stakesWithR = new Vector<Stake>();
        for (Stake stak : this.stakes) {
            if (!stak.getRelation().equals(r)) continue;
            stakesWithR.add(stak);
        }
        return stakesWithR;
    }

    public Vector<Stake> getStakesWithActor(Actor a) {
        Vector<Stake> stakesWithA = new Vector<Stake>();
        for (Stake stak : this.stakes) {
            if (!stak.getActor().equals(a)) continue;
            stakesWithA.add(stak);
        }
        return stakesWithA;
    }

    @Override
    public Stake getStakeWithRelationAndActor(Actor a, Relation r) {
        Stake stake = null;
        for (Stake stak : this.stakes) {
            if (!stak.getActor().equals(a) || !stak.getRelation().equals(r)) continue;
            stake = stak;
        }
        return stake;
    }

    @Override
    public Stake getStake(int i) {
        return this.stakes.get(i);
    }

    public void setBonus(float bonus) {
        this.bonus = bonus;
    }

    public void setDiscrimination(float discrimination) {
        this.discrimination = discrimination;
    }

    public void setInitialStrength(float initialStrength) {
        this.initialStrength = initialStrength;
    }

    public void setSolidarities(Vector<Solidarity> solidarities) {
        this.solidarities = solidarities;
    }

    public void setStakes(Vector<Stake> stakes) {
        this.stakes = stakes;
    }
}

