/*
 * Decompiled with CFR 0.152.
 */
package staticParameters;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import organization.Actor;
import organization.Effect;
import organization.Organization;
import organization.Relation;
import organization.Stake;
import staticParameters.MathLib;
import staticParameters.RelationAndExchangeTermPair;
import staticParameters.Satisfaction;
import staticParameters.SatisfactionByRelation;

public class StaticMath {
    protected static final float ERROR = -1.0f;
    protected static final int NBDIGITS = 2;

    public static float relevance(Organization org, Relation relation) {
        Collection<Stake> stakes = org.getStakesWithRelation(relation);
        float somme = 0.0f;
        for (Stake stk : stakes) {
            somme += stk.getValue();
        }
        return MathLib.keepNDigits(somme, 2);
    }

    public static float autonomy(Organization org, Actor act) {
        Collection<Relation> relations = org.getRelationsControledBy(act);
        float somme = 0.0f;
        for (Relation rel : relations) {
            float stk = 0.0f;
            Stake stake = org.getStakeWithRelationAndActor(act, rel);
            if (stake != null) {
                stk = stake.getValue();
            }
            somme += stk;
        }
        return MathLib.keepNDigits(somme, 2);
    }

    public static float subordination(Organization org, Actor act) {
        Collection<Relation> relations = org.getRelationsSufferedBy(act);
        float somme = 0.0f;
        for (Relation rel : relations) {
            float stk = 0.0f;
            Stake stake = org.getStakeWithRelationAndActor(act, rel);
            if (stake != null) {
                stk = stake.getValue();
            }
            somme += stk;
        }
        return MathLib.keepNDigits(somme, 2);
    }

    public static float force(Organization org, Relation rel, Actor act, boolean bounds) {
        float upperBound;
        float lowerBound;
        if (bounds) {
            lowerBound = rel.getLowerBound();
            upperBound = rel.getUpperBound();
        } else {
            lowerBound = -1.0f;
            upperBound = 1.0f;
        }
        Collection<Effect> effects = rel.getEffects();
        Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
        if (effect == null) {
            return 0.0f;
        }
        String effectParameters = effect.getFormula();
        float step = effect.getStep();
        float max = MathLib.functionValue(effectParameters, lowerBound);
        float min = MathLib.functionValue(effectParameters, lowerBound);
        float x = lowerBound + step;
        while (MathLib.keepNDigits(x, 2) <= upperBound) {
            float valueForX = MathLib.functionValue(effectParameters, x);
            if (valueForX < min) {
                min = valueForX;
            } else if (valueForX > max) {
                max = valueForX;
            }
            x += step;
        }
        return max - min;
    }

    public static float forceMax(Organization org, Relation rel, boolean bounds) {
        Collection<Actor> actors = org.getActors();
        float forceMax = 0.0f;
        for (Actor actor : actors) {
            float forceActor = StaticMath.force(org, rel, actor, bounds);
            if (!(forceMax < forceActor)) continue;
            forceMax = forceActor;
        }
        return MathLib.keepNDigits(forceMax, 2);
    }

    public static float forceTotal(Organization org, Relation r, boolean bounds) {
        Collection<Actor> actors = org.getActors();
        float forceTotal = 0.0f;
        for (Actor actor : actors) {
            float forceActor = StaticMath.force(org, r, actor, bounds);
            forceTotal += forceActor;
        }
        return MathLib.keepNDigits(forceTotal, 2);
    }

    private static Effect seekEffectWithActor(Collection<Effect> effects, String actorName) {
        boolean nonTrouve = true;
        Effect result = null;
        Iterator<Effect> itE = effects.iterator();
        while (nonTrouve && itE.hasNext()) {
            Effect effect = itE.next();
            String effActName = effect.getActor().getName();
            if (!effActName.equals(actorName)) continue;
            nonTrouve = false;
            result = effect;
        }
        return result;
    }

    public static float controlForce(Organization org, Relation rel, Actor act, boolean bounds) {
        float upperBound;
        float lowerBound;
        if (bounds) {
            lowerBound = rel.getLowerBound();
            upperBound = rel.getUpperBound();
        } else {
            lowerBound = -1.0f;
            upperBound = 1.0f;
        }
        Collection<Effect> effects = rel.getEffects();
        Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
        if (effect == null) {
            return 0.0f;
        }
        String effectParameters = effect.getFormula();
        float step = effect.getStep();
        float max = MathLib.functionValue(effectParameters, lowerBound);
        float min = MathLib.functionValue(effectParameters, lowerBound);
        float x = lowerBound + step;
        while (MathLib.keepNDigits(x, 2) <= upperBound) {
            float valueForX = MathLib.functionValue(effectParameters, x);
            if (valueForX < min) {
                min = valueForX;
            } else if (valueForX > max) {
                max = valueForX;
            }
            x += step;
        }
        return max - min;
    }

    public static float controlForce(Organization org, Relation rel, boolean bounds) {
        Collection<Actor> actors = org.getActors();
        Iterator<Actor> it = actors.iterator();
        float controlForceMax = 0.0f;
        while (it.hasNext()) {
            Actor actor = it.next();
            float controlForceActor = StaticMath.controlForce(org, rel, actor, bounds);
            if (!(controlForceMax < controlForceActor)) continue;
            controlForceMax = controlForceActor;
        }
        return controlForceMax;
    }

    public static float dependenceForce(Organization org, Relation rel, Actor act, boolean bounds) {
        float stk = 0.0f;
        Stake stake = org.getStakeWithRelationAndActor(act, rel);
        if (stake != null) {
            stk = stake.getValue();
        }
        float force = StaticMath.force(org, rel, act, bounds);
        return stk * force;
    }

    public static float realForce(Organization org, Relation rel, Actor act, boolean bounds) {
        float stk = 0.0f;
        Stake stake = org.getStakeWithRelationAndActor(act, rel);
        if (stake != null) {
            stk = stake.getValue();
        }
        float controlForce = StaticMath.controlForce(org, rel, act, bounds);
        return stk * controlForce;
    }

    public static float power(Organization org, Actor actorA, Actor actorB, boolean bounds) {
        Collection<Relation> rels = org.getRelationsControledBy(actorA);
        float somme = 0.0f;
        for (Relation rel : rels) {
            somme += StaticMath.realForce(org, rel, actorB, bounds);
        }
        return somme;
    }

    public static float power(Organization org, Actor act, boolean bounds) {
        Collection<Actor> actors = org.getActors();
        float sommePower = 0.0f;
        for (Actor actor : actors) {
            if (actor.getName().equals(act.getName())) continue;
            sommePower += StaticMath.power(org, act, actor, bounds);
        }
        return MathLib.keepNDigits(sommePower - StaticMath.power(org, act, act, bounds), 2);
    }

    public static float dependency(Organization org, Actor act) {
        Collection<Actor> actors = org.getActors();
        float sommePower = 0.0f;
        for (Actor actor : actors) {
            if (actor.getName().equals(act.getName())) continue;
            sommePower += StaticMath.power(org, actor, act, false);
        }
        return MathLib.keepNDigits(sommePower - StaticMath.power(org, act, act, false), 2);
    }

    public static float satisfaction(Organization org, Actor act, Relation rel, float exchTerm) {
        Stake enjeu = org.getStakeWithRelationAndActor(act, rel);
        Collection<Effect> effects = rel.getEffects();
        Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
        if (effect == null) {
            return 0.0f;
        }
        String effectParameters = effect.getFormula();
        float value = MathLib.functionValue(effectParameters, exchTerm);
        return MathLib.keepNDigits(value * enjeu.getValue(), 2);
    }

    public static float satisfaction(Organization org, Actor act, Collection<Float> exchTerm) {
        Collection<Relation> relations = org.getRelations();
        Iterator<Relation> itR = relations.iterator();
        Iterator<Float> itT = exchTerm.iterator();
        float somme = 0.0f;
        while (itR.hasNext()) {
            Relation r = itR.next();
            float tei = itT.next().floatValue();
            somme += StaticMath.satisfaction(org, act, r, tei);
        }
        return MathLib.keepNDigits(somme, 2);
    }

    public static SatisfactionByRelation satisfactionMinRelation(Organization org, Actor act, Relation rel) {
        float lowerBound = rel.getLowerBound();
        float upperBound = rel.getUpperBound();
        Stake stake = org.getStakeWithRelationAndActor(act, rel);
        Collection<Effect> effects = rel.getEffects();
        Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
        if (effect == null) {
            return null;
        }
        float step = effect.getStep();
        String effectParameters = effect.getFormula();
        Vector<Float> indexMinEffect = MathLib.indexMinFunctionValue(effectParameters, lowerBound, upperBound, step);
        float minEffectValue = MathLib.functionValue(effectParameters, indexMinEffect.get(0).floatValue());
        SatisfactionByRelation minSatisfaction = new SatisfactionByRelation(act, rel, indexMinEffect, MathLib.keepNDigits(stake.getValue() * minEffectValue, 2));
        return minSatisfaction;
    }

    public static SatisfactionByRelation satisfactionMaxRelation(Organization org, Actor act, Relation rel) {
        float lowerBound = rel.getLowerBound();
        float upperBound = rel.getUpperBound();
        Stake enjeu = org.getStakeWithRelationAndActor(act, rel);
        Collection<Effect> effects = rel.getEffects();
        Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
        if (effect == null) {
            return null;
        }
        float step = effect.getStep();
        String effectParameters = effect.getFormula();
        Vector<Float> indexMaxEffect = MathLib.indexMaxFunctionValue(effectParameters, lowerBound, upperBound, step);
        float maxEffectValue = MathLib.functionValue(effectParameters, indexMaxEffect.get(0).floatValue());
        SatisfactionByRelation maxSatisfaction = new SatisfactionByRelation(act, rel, indexMaxEffect, MathLib.keepNDigits(enjeu.getValue() * maxEffectValue, 2));
        return maxSatisfaction;
    }

    public static Satisfaction satisfactionMax(Organization org, Actor act) {
        Collection<Relation> relations = org.getRelations();
        Collection<Relation> relationsInv = org.getRelationsInvolved(act);
        Satisfaction satMax = new Satisfaction();
        for (Relation rel : relations) {
            if (!relationsInv.contains(rel)) continue;
            SatisfactionByRelation satMaxLocal = StaticMath.satisfactionMaxRelation(org, act, rel);
            float localValue = satMaxLocal.getValue();
            satMax.addSatisfaction(satMaxLocal);
            float satisfactionValue = satMax.getValue();
            satMax.setValue(MathLib.keepNDigits(satisfactionValue + localValue, 2));
        }
        return satMax;
    }

    public static Satisfaction satisfactionMin(Organization org, Actor act) {
        Collection<Relation> relations = org.getRelations();
        Collection<Relation> relationsInv = org.getRelationsInvolved(act);
        Satisfaction satMin = new Satisfaction();
        for (Relation rel : relations) {
            if (!relationsInv.contains(rel)) continue;
            SatisfactionByRelation satMinLocal = StaticMath.satisfactionMinRelation(org, act, rel);
            float localValue = satMinLocal.getValue();
            satMin.addSatisfaction(satMinLocal);
            float satisfactionValue = satMin.getValue();
            satMin.setValue(MathLib.keepNDigits(satisfactionValue + localValue, 2));
        }
        return satMin;
    }

    public static Satisfaction satisfactionMinGlobal(Organization org) {
        Satisfaction satResult = new Satisfaction();
        Collection<Relation> relations = org.getRelations();
        for (Relation rel : relations) {
            Collection<Effect> effects = rel.getEffects();
            float lowerBound = rel.getLowerBound();
            float upperBound = rel.getUpperBound();
            float maxStep = 0.0f;
            Collection<Actor> actors = org.getActors();
            for (Actor act : actors) {
                float step;
                Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
                if (effect == null || !((step = effect.getStep()) > maxStep)) continue;
                maxStep = step;
            }
            float totalSatisf = 0.0f;
            Vector<Float> indexTotalSatMins = new Vector<Float>();
            for (Actor act : actors) {
                float satisfactionParActeur = StaticMath.satisfaction(org, act, rel, lowerBound);
                totalSatisf += satisfactionParActeur;
            }
            float totalSatMin = totalSatisf;
            indexTotalSatMins.add(Float.valueOf(MathLib.keepNDigits(lowerBound, 2)));
            float x = lowerBound + maxStep;
            while (MathLib.keepNDigits(x, 2) <= upperBound) {
                totalSatisf = 0.0f;
                for (Actor act : actors) {
                    float satisfactionParActeur = StaticMath.satisfaction(org, act, rel, x);
                    totalSatisf += satisfactionParActeur;
                }
                if (totalSatisf < totalSatMin) {
                    totalSatMin = totalSatisf;
                    indexTotalSatMins.removeAllElements();
                    indexTotalSatMins.add(Float.valueOf(MathLib.keepNDigits(x, 2)));
                } else if (Double.compare(totalSatisf, totalSatMin) == 0) {
                    indexTotalSatMins.add(Float.valueOf(MathLib.keepNDigits(x, 2)));
                }
                x += maxStep;
            }
            SatisfactionByRelation satMinByRelation = new SatisfactionByRelation(rel, indexTotalSatMins, MathLib.keepNDigits(totalSatMin, 2));
            satResult.addSatisfaction(satMinByRelation);
            float globalSatisfValue = satResult.getValue();
            satResult.setValue(MathLib.keepNDigits(globalSatisfValue + totalSatMin, 2));
        }
        return satResult;
    }

    public static Satisfaction satisfactionMaxGlobal(Organization org) {
        Satisfaction satResult = new Satisfaction();
        Collection<Relation> relations = org.getRelations();
        for (Relation rel : relations) {
            Collection<Effect> effects = rel.getEffects();
            float lowerBound = rel.getLowerBound();
            float upperBound = rel.getUpperBound();
            float maxStep = 0.0f;
            Collection<Actor> actors = org.getActors();
            for (Actor act : actors) {
                float step;
                Effect effect = StaticMath.seekEffectWithActor(effects, act.getName());
                if (effect == null || !((step = effect.getStep()) > maxStep)) continue;
                maxStep = step;
            }
            float totalSatisf = 0.0f;
            Vector<Float> indexTotalSatMaxs = new Vector<Float>();
            for (Actor act : actors) {
                float satisfactionParActeur = StaticMath.satisfaction(org, act, rel, lowerBound);
                totalSatisf += satisfactionParActeur;
            }
            float totalSatMax = totalSatisf;
            indexTotalSatMaxs.add(Float.valueOf(lowerBound));
            float x = lowerBound + maxStep;
            while (MathLib.keepNDigits(x, 2) <= upperBound) {
                totalSatisf = 0.0f;
                for (Actor act : actors) {
                    float satisfactionParActeur = StaticMath.satisfaction(org, act, rel, x);
                    totalSatisf += satisfactionParActeur;
                }
                if (totalSatisf > totalSatMax) {
                    totalSatMax = totalSatisf;
                    indexTotalSatMaxs.removeAllElements();
                    indexTotalSatMaxs.add(Float.valueOf(MathLib.keepNDigits(x, 2)));
                } else if (Double.compare(totalSatisf, totalSatMax) == 0) {
                    indexTotalSatMaxs.add(Float.valueOf(MathLib.keepNDigits(x, 2)));
                }
                x += maxStep;
            }
            SatisfactionByRelation satMaxByRelation = new SatisfactionByRelation(rel, indexTotalSatMaxs, MathLib.keepNDigits(totalSatMax, 2));
            satResult.addSatisfaction(satMaxByRelation);
            float globalSatisfValue = satResult.getValue();
            satResult.setValue(MathLib.keepNDigits(globalSatisfValue + totalSatMax, 2));
        }
        return satResult;
    }

    public static Collection<RelationAndExchangeTermPair> nash(Organization org) {
        Vector<RelationAndExchangeTermPair> listRAEP = new Vector<RelationAndExchangeTermPair>();
        Collection<Relation> relations = org.getRelations();
        for (Relation rel : relations) {
            Actor actorControler = rel.getActorController();
            SatisfactionByRelation satByRelMax = StaticMath.satisfactionMaxRelation(org, actorControler, rel);
            Vector<Float> exchangeTerms = satByRelMax.getExchangeTerm();
            RelationAndExchangeTermPair rAEP = new RelationAndExchangeTermPair(exchangeTerms, rel);
            listRAEP.add(rAEP);
        }
        return listRAEP;
    }

    public static Collection<RelationAndExchangeTermPair> pareto(Organization org) {
        Vector<RelationAndExchangeTermPair> listRAEP = new Vector<RelationAndExchangeTermPair>();
        Collection<Relation> relations = org.getRelations();
        for (Relation rel : relations) {
            Actor actorControler = rel.getActorController();
            Collection<Float> exchangeTerms = null;
            Collection<Actor> actors = org.getActors();
            for (Actor otherActor : actors) {
                SatisfactionByRelation satByRelMax;
                if (otherActor.getName().equals(actorControler.getName()) || (satByRelMax = StaticMath.satisfactionMaxRelation(org, otherActor, rel)) == null) continue;
                Vector<Float> exchangeTermsLocal = satByRelMax.getExchangeTerm();
                if (exchangeTerms == null) {
                    exchangeTerms = exchangeTermsLocal;
                    continue;
                }
                if ((exchangeTerms = MathLib.intersection(exchangeTerms, exchangeTermsLocal)).size() != 0) continue;
                return new Vector<RelationAndExchangeTermPair>();
            }
            if (exchangeTerms == null) {
                SatisfactionByRelation satByRelMax = StaticMath.satisfactionMaxRelation(org, actorControler, rel);
                exchangeTerms = satByRelMax.getExchangeTerm();
            }
            RelationAndExchangeTermPair rAEP = new RelationAndExchangeTermPair(exchangeTerms, rel);
            listRAEP.add(rAEP);
        }
        return listRAEP;
    }
}

