/*
 * Decompiled with CFR 0.152.
 */
package contrib.ch.randelshofer.quaqua.colorchooser;

import contrib.ch.randelshofer.quaqua.colorchooser.PaletteEntry;
import contrib.ch.randelshofer.quaqua.colorchooser.PaletteListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;

public class PaletteEntryCellRenderer
extends DefaultListCellRenderer {
    private Color closestMarker1 = new Color(0xE6E6E6);
    private Color closestMarker2 = new Color(0xEDEDED);
    private Color closestMarker3 = new Color(0xF0F0F0);
    private ColorIcon icon = new ColorIcon();
    private boolean isClosestColor;

    public PaletteEntryCellRenderer() {
        this.setIcon(this.icon);
        this.setOpaque(false);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(UIManager.getColor("ColorChooser.listSelectionBackground"));
            this.setForeground(UIManager.getColor("ColorChooser.listSelectionForeground"));
            this.isClosestColor = false;
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            PaletteListModel model = (PaletteListModel)list.getModel();
            this.isClosestColor = model.getClosestIndex() == index;
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        PaletteEntry entry = (PaletteEntry)value;
        this.icon.setColor(entry.getColor());
        this.setText(entry.getName());
        return this;
    }

    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        if (this.isClosestColor) {
            g.setColor(this.closestMarker1);
            g.fillRect(0, 0, width, 2);
            g.fillRect(0, height - 2, width, 2);
            g.setColor(this.closestMarker2);
            g.fillRect(0, 2, width, 1);
            g.fillRect(0, height - 3, width, 1);
            g.setColor(this.closestMarker3);
            g.fillRect(0, 3, width, 1);
            g.fillRect(0, height - 4, width, 1);
        }
        super.paintComponent(g);
    }

    static class ColorIcon
    implements Icon {
        private Color color = Color.black;

        ColorIcon() {
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconHeight() {
            return 15;
        }

        public int getIconWidth() {
            return 25;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.getColor());
            g.fillRect(x + 1, y + 1, this.getIconWidth() - 2, this.getIconHeight() - 2);
            g.setColor(this.getColor().darker());
            g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

