/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import org.jvnet.lafwidget.utils.FadeTracker;

public class SubstanceFadeUtilities {
    public static Component getTracked(FadeTracker.FadeKind fadeKind, Component ... comps) {
        FadeTracker tracker = FadeTracker.getInstance();
        Component result = null;
        float highest = -1.0f;
        for (Component comp : comps) {
            float fade10;
            if (!tracker.isTracked(comp, fadeKind) || !((fade10 = tracker.getFade10(comp, fadeKind)) > highest)) continue;
            result = comp;
            highest = fade10;
        }
        return result;
    }

    public static FadeTracker.FadeState getFadeStateWithHighestFadeCycle(FadeTracker.FadeKind fadeKind, Component ... comps) {
        FadeTracker tracker = FadeTracker.getInstance();
        FadeTracker.FadeState result = null;
        float highest = -1.0f;
        for (Component comp : comps) {
            FadeTracker.FadeState curr = tracker.getFadeState(comp, fadeKind);
            if (curr == null || !(curr.fadePosition > highest)) continue;
            result = curr;
            highest = curr.fadePosition;
        }
        return result;
    }

    public static FadeTracker.FadeState getFadeState(Component comp, FadeTracker.FadeKind ... fadeKinds) {
        FadeTracker tracker = FadeTracker.getInstance();
        for (FadeTracker.FadeKind fadeKind : fadeKinds) {
            FadeTracker.FadeState result = tracker.getFadeState(comp, fadeKind);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static FadeTracker.FadeState getFadeState(Component comp, Comparable comparable, FadeTracker.FadeKind ... fadeKinds) {
        FadeTracker tracker = FadeTracker.getInstance();
        for (FadeTracker.FadeKind fadeKind : fadeKinds) {
            FadeTracker.FadeState result = tracker.getFadeState(comp, comparable, fadeKind);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

