/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Insets;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.FontSet;

public class SubstanceSizeUtils {
    private static int controlFontSize = -1;

    public static void setControlFontSize(int size) {
        controlFontSize = size;
    }

    public static int getControlFontSize() {
        if (controlFontSize > 0) {
            return controlFontSize;
        }
        FontPolicy fPolicy = SubstanceLookAndFeel.getFontPolicy();
        FontSet fSet = fPolicy.getFontSet("Substance", null);
        controlFontSize = fSet.getControlFont().getSize();
        return controlFontSize;
    }

    public static int getAdjustedSize(int baseSize, int forEachBase, int toAdjustBy, boolean toRoundAsEven) {
        int delta = SubstanceSizeUtils.getControlFontSize() - 11;
        if (delta <= 0) {
            return baseSize;
        }
        int result = baseSize + delta * toAdjustBy / forEachBase;
        if (toRoundAsEven && result % 2 == 1) {
            --result;
        }
        return result;
    }

    public static int getAdjustedSize(int baseSize, int forEachBase, boolean toRoundAsEven) {
        return SubstanceSizeUtils.getAdjustedSize(baseSize, forEachBase, 1, toRoundAsEven);
    }

    public static int getAdjustedSize(int baseSize, int forEachBase, int toAdjustBy) {
        return SubstanceSizeUtils.getAdjustedSize(baseSize, forEachBase, toAdjustBy, false);
    }

    public static int getAdjustedSize(int baseSize, int forEachBase) {
        return SubstanceSizeUtils.getAdjustedSize(baseSize, forEachBase, 1, false);
    }

    public static int getScrollBarWidth() {
        return SubstanceSizeUtils.getControlFontSize() + 4;
    }

    public static int getArrowIconWidth() {
        int result = SubstanceSizeUtils.getControlFontSize() - 2;
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getArrowIconHeight() {
        return 6 + (SubstanceSizeUtils.getControlFontSize() - 11) / 2;
    }

    public static int getTabCloseIconSize() {
        return 8 + (SubstanceSizeUtils.getControlFontSize() - 6) / 2;
    }

    public static int getTitlePaneIconSize() {
        return 5 + SubstanceSizeUtils.getControlFontSize();
    }

    public static int getSliderIconSize() {
        int result = SubstanceSizeUtils.getControlFontSize() + 5;
        if (result % 2 == 1) {
            --result;
        }
        return result;
    }

    public static int getMenuCheckMarkSize() {
        int result = SubstanceSizeUtils.getControlFontSize() - 2;
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getCheckBoxMarkSize() {
        return 5 + SubstanceSizeUtils.getControlFontSize();
    }

    public static int getRadioButtonMarkSize() {
        int result = SubstanceSizeUtils.getControlFontSize();
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getSliderTrackSize() {
        return Math.max(4, 5 + (SubstanceSizeUtils.getControlFontSize() - 11) / 2);
    }

    public static float getArrowStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 6.0f;
    }

    public static float getDoubleArrowStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 8.0f;
    }

    public static float getTabCloseButtonStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 10.0f;
    }

    public static int getSpinnerButtonWidth() {
        return SubstanceSizeUtils.getArrowIconWidth() * 3 / 2;
    }

    public static int getPasswordDotDiameter() {
        int result = SubstanceSizeUtils.getControlFontSize() - 5;
        if (result % 2 == 0) {
            ++result;
        }
        return result;
    }

    public static int getPasswordDotGap() {
        return (SubstanceSizeUtils.getControlFontSize() - 6) / 3;
    }

    public static int getMinButtonWidth() {
        return (int)(3.5 * (double)SubstanceSizeUtils.getMinButtonHeight());
    }

    public static int getMinButtonHeight() {
        return 11 + (SubstanceSizeUtils.getControlFontSize() - 5) * 3 / 2;
    }

    public static int getExtraPadding() {
        int cfs = SubstanceSizeUtils.getControlFontSize();
        if (cfs < 14) {
            return 0;
        }
        return (cfs - 11) / 3;
    }

    public static int getExtraPadding(int baseSize) {
        int cfs = SubstanceSizeUtils.getControlFontSize();
        if (cfs < 14) {
            return 0;
        }
        return (cfs - 11) / (6 - baseSize);
    }

    public static Insets getTextBorderInsets() {
        int tbInset = SubstanceSizeUtils.getAdjustedSize(3, 3);
        int lrInset = SubstanceSizeUtils.getAdjustedSize(4, 3);
        return new Insets(tbInset, lrInset, tbInset, lrInset);
    }

    public static Insets getComboBorderInsets() {
        int tbInset = SubstanceSizeUtils.getAdjustedSize(1, 3);
        int lrInset = SubstanceSizeUtils.getAdjustedSize(2, 3);
        return new Insets(tbInset, lrInset, tbInset, lrInset);
    }

    public static Insets getSpinnerArrowButtonInsets() {
        int tbrInset = SubstanceSizeUtils.getAdjustedSize(2, 3);
        int lInset = SubstanceSizeUtils.getAdjustedSize(0, 3);
        return new Insets(tbrInset, lInset, tbrInset, tbrInset);
    }

    public static Insets getSpinnerBorderInsets() {
        int tlbrInset = SubstanceSizeUtils.getAdjustedSize(3, 3);
        return new Insets(tlbrInset, tlbrInset, tlbrInset, tlbrInset);
    }

    public static float getFocusStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 10.0f;
    }
}

