/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceSliderUI;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.Trackable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceIconFactory {
    private static Map<Integer, Icon> checkBoxMenuItemIcons = new HashMap<Integer, Icon>();
    private static Map<Integer, Icon> radioButtonMenuItemIcons = new HashMap<Integer, Icon>();
    private static Map<String, Icon> sliderHorizontalIcons = new HashMap<String, Icon>();
    private static Map<String, Icon> sliderRoundIcons = new HashMap<String, Icon>();
    private static Map<String, Icon> sliderVerticalIcons = new HashMap<String, Icon>();
    private static final Map<IconKind, Map<SubstanceTheme, Icon>> titlePaneIcons = SubstanceIconFactory.createTitlePaneIcons();

    public static synchronized void reset() {
        checkBoxMenuItemIcons.clear();
        radioButtonMenuItemIcons.clear();
        sliderHorizontalIcons.clear();
        sliderRoundIcons.clear();
        sliderVerticalIcons.clear();
        titlePaneIcons.get((Object)IconKind.CLOSE).clear();
        titlePaneIcons.get((Object)IconKind.MINIMIZE).clear();
        titlePaneIcons.get((Object)IconKind.MAXIMIZE).clear();
        titlePaneIcons.get((Object)IconKind.RESTORE).clear();
    }

    public static synchronized Icon getCheckBoxMenuItemIcon(int size) {
        if (checkBoxMenuItemIcons.get(size) == null) {
            CheckBoxMenuItemIcon icon = new CheckBoxMenuItemIcon(size);
            checkBoxMenuItemIcons.put(size, icon);
        }
        return checkBoxMenuItemIcons.get(size);
    }

    public static Icon getRadioButtonMenuItemIcon(int size) {
        if (radioButtonMenuItemIcons.get(size) == null) {
            RadioButtonMenuItemIcon icon = new RadioButtonMenuItemIcon(size);
            radioButtonMenuItemIcons.put(size, icon);
        }
        return radioButtonMenuItemIcons.get(size);
    }

    public static Icon getSliderHorizontalIcon(int size, boolean isMirrorred) {
        String key = size + ":" + isMirrorred;
        if (sliderHorizontalIcons.get(key) == null) {
            SliderHorizontalIcon icon = new SliderHorizontalIcon(size, isMirrorred);
            sliderHorizontalIcons.put(key, icon);
        }
        return sliderHorizontalIcons.get(key);
    }

    public static Icon getSliderRoundIcon(int size) {
        String key = "" + size;
        if (sliderRoundIcons.get(key) == null) {
            SliderRoundIcon icon = new SliderRoundIcon(size);
            sliderRoundIcons.put(key, icon);
        }
        return sliderRoundIcons.get(key);
    }

    public static Icon getSliderVerticalIcon(int size, boolean isMirrorred) {
        String key = size + ":" + isMirrorred;
        if (sliderVerticalIcons.get(key) == null) {
            SliderVerticalIcon icon = new SliderVerticalIcon(size, isMirrorred);
            sliderVerticalIcons.put(key, icon);
        }
        return sliderVerticalIcons.get(key);
    }

    private static Map<IconKind, Map<SubstanceTheme, Icon>> createTitlePaneIcons() {
        HashMap<IconKind, Map<SubstanceTheme, Icon>> result = new HashMap<IconKind, Map<SubstanceTheme, Icon>>();
        result.put(IconKind.CLOSE, new HashMap());
        result.put(IconKind.MINIMIZE, new HashMap());
        result.put(IconKind.MAXIMIZE, new HashMap());
        result.put(IconKind.RESTORE, new HashMap());
        return result;
    }

    public static synchronized Icon getTitlePaneIcon(IconKind iconKind, SubstanceTheme theme) {
        Map<SubstanceTheme, Icon> kindMap = titlePaneIcons.get((Object)iconKind);
        Icon result = kindMap.get(theme);
        if (result != null) {
            return result;
        }
        switch (iconKind) {
            case CLOSE: {
                result = SubstanceImageCreator.getCloseIcon(theme);
                break;
            }
            case MINIMIZE: {
                result = SubstanceImageCreator.getMinimizeIcon(theme);
                break;
            }
            case MAXIMIZE: {
                result = SubstanceImageCreator.getMaximizeIcon(theme);
                break;
            }
            case RESTORE: {
                result = SubstanceImageCreator.getRestoreIcon(theme);
            }
        }
        kindMap.put(theme, result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IconKind {
        CLOSE,
        MINIMIZE,
        MAXIMIZE,
        RESTORE;

    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private static Map<String, Icon> icons = new HashMap<String, Icon>();
        private int size;
        private boolean isMirrorred;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderVerticalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private static synchronized Icon getIcon(ComponentState state, ComponentState prevState, JSlider slider, SliderVerticalIcon sliderIcon) {
            float cyclePos = state.getCycleCount();
            ColorScheme colorScheme = SubstanceCoreUtilities.getTheme((Component)slider, state, true, false).getColorScheme();
            ColorScheme colorScheme2 = SubstanceCoreUtilities.getTheme((Component)slider, prevState, true, false).getColorScheme();
            FadeTracker fadeTracker = FadeTracker.getInstance();
            int height = 2 * sliderIcon.size / 3;
            if (fadeTracker.isTracked(slider, FadeTracker.FadeKind.ROLLOVER)) {
                cyclePos = fadeTracker.getFade10(slider, FadeTracker.FadeKind.ROLLOVER);
                if (fadeTracker.isFadeIn(slider, FadeTracker.FadeKind.ROLLOVER)) {
                    cyclePos = 10.0f - cyclePos;
                }
                height = (int)((double)sliderIcon.size * (2.0 + (double)fadeTracker.getFade10(slider, FadeTracker.FadeKind.ROLLOVER) / 10.0) / 3.0);
            } else if (fadeTracker.isTracked(slider, FadeTracker.FadeKind.PRESS)) {
                cyclePos = fadeTracker.getFade10(slider, FadeTracker.FadeKind.PRESS);
                if (fadeTracker.isFadeIn(slider, FadeTracker.FadeKind.PRESS)) {
                    cyclePos = 10.0f - cyclePos;
                }
                height = sliderIcon.size;
            } else {
                switch (state) {
                    case ROLLOVER_UNSELECTED: 
                    case ROLLOVER_SELECTED: 
                    case ACTIVE: 
                    case PRESSED_SELECTED: 
                    case PRESSED_UNSELECTED: {
                        height = sliderIcon.size;
                    }
                }
            }
            height = Math.min(height, sliderIcon.size - 2);
            int delta = (sliderIcon.size - height) / 2 - 1;
            String key = sliderIcon.size + ":" + height + ":" + slider.getComponentOrientation() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos;
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
            BufferedImage stateImage = painter.getContourBackground(height, sliderIcon.size, BaseButtonShaper.getTriangleButtonOutline(height, sliderIcon.size, 2.0f), false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage biResult = SubstanceCoreUtilities.getBlankImage(sliderIcon.size - 1, sliderIcon.size - 1);
            Graphics2D bg2d = (Graphics2D)biResult.getGraphics();
            bg2d.drawImage((Image)stateImage, delta, 0, null);
            biResult = sliderIcon.isMirrorred ? SubstanceImageCreator.getRotated(biResult, 1) : SubstanceImageCreator.getRotated(biResult, 3);
            if (!slider.getComponentOrientation().isLeftToRight()) {
                biResult = SubstanceImageCreator.getRotated(biResult, 2);
            }
            result = new ImageIcon(biResult);
            icons.put(key, result);
            return result;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    buttonModel.setEnabled(slider.isEnabled());
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(slider);
            Icon iconToDraw = SliderVerticalIcon.getIcon(state, prevState, slider, this);
            iconToDraw.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.size - 1;
        }

        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderRoundIcon
    implements Icon,
    UIResource {
        private static Map<String, Icon> icons = new HashMap<String, Icon>();
        private int size;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderRoundIcon(int size) {
            this.size = size;
        }

        private static synchronized Icon getIcon(ComponentState state, ComponentState prevState, JSlider slider, SliderRoundIcon sliderIcon) {
            float cyclePos = state.getCycleCount();
            ColorScheme colorScheme = SubstanceCoreUtilities.getTheme((Component)slider, state, true, false).getColorScheme();
            ColorScheme colorScheme2 = SubstanceCoreUtilities.getTheme((Component)slider, prevState, true, false).getColorScheme();
            FadeTracker fadeTracker = FadeTracker.getInstance();
            int width = 2 * sliderIcon.size / 3;
            if (fadeTracker.isTracked(slider, FadeTracker.FadeKind.ROLLOVER)) {
                cyclePos = fadeTracker.getFade10(slider, FadeTracker.FadeKind.ROLLOVER);
                if (fadeTracker.isFadeIn(slider, FadeTracker.FadeKind.ROLLOVER)) {
                    cyclePos = 10.0f - cyclePos;
                }
                width = (int)((double)sliderIcon.size * (2.0 + (double)fadeTracker.getFade10(slider, FadeTracker.FadeKind.ROLLOVER) / 10.0) / 3.0);
            } else if (fadeTracker.isTracked(slider, FadeTracker.FadeKind.PRESS)) {
                cyclePos = fadeTracker.getFade10(slider, FadeTracker.FadeKind.PRESS);
                if (fadeTracker.isFadeIn(slider, FadeTracker.FadeKind.PRESS)) {
                    cyclePos = 10.0f - cyclePos;
                }
                width = sliderIcon.size;
            } else {
                switch (state) {
                    case ROLLOVER_UNSELECTED: 
                    case ROLLOVER_SELECTED: 
                    case ACTIVE: 
                    case PRESSED_SELECTED: 
                    case PRESSED_UNSELECTED: {
                        width = sliderIcon.size;
                    }
                }
            }
            width = Math.min(width, sliderIcon.size - 2);
            if (width % 2 == 0) {
                --width;
            }
            int delta = (sliderIcon.size - width) / 2;
            String key = sliderIcon.size + ":" + width + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos;
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
            BufferedImage stateImage = painter.getContourBackground(width, sliderIcon.size - 1, new Ellipse2D.Float(0.0f, 0.0f, width - 1, width - 1), false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage biResult = SubstanceCoreUtilities.getBlankImage(sliderIcon.size - 1, sliderIcon.size - 1);
            Graphics2D bg2d = (Graphics2D)biResult.getGraphics();
            bg2d.drawImage((Image)stateImage, delta, delta, null);
            result = new ImageIcon(biResult);
            icons.put(key, result);
            return result;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    buttonModel.setEnabled(slider.isEnabled());
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(slider);
            Icon iconToDraw = SliderRoundIcon.getIcon(state, prevState, slider, this);
            iconToDraw.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.size - 1;
        }

        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private static Map<String, Icon> icons = new HashMap<String, Icon>();
        private int size;
        private boolean isMirrorred;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderHorizontalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private static synchronized Icon getIcon(ComponentState state, ComponentState prevState, JSlider slider, SliderHorizontalIcon sliderIcon) {
            float cyclePos = state.getCycleCount();
            ColorScheme colorScheme = SubstanceCoreUtilities.getTheme((Component)slider, state, true, false).getColorScheme();
            ColorScheme colorScheme2 = SubstanceCoreUtilities.getTheme((Component)slider, prevState, true, false).getColorScheme();
            FadeTracker fadeTracker = FadeTracker.getInstance();
            int width = 2 * sliderIcon.size / 3;
            if (fadeTracker.isTracked(slider, FadeTracker.FadeKind.ROLLOVER)) {
                cyclePos = fadeTracker.getFade10(slider, FadeTracker.FadeKind.ROLLOVER);
                if (fadeTracker.isFadeIn(slider, FadeTracker.FadeKind.ROLLOVER)) {
                    cyclePos = 10.0f - cyclePos;
                }
                width = (int)((double)sliderIcon.size * (2.0 + (double)fadeTracker.getFade10(slider, FadeTracker.FadeKind.ROLLOVER) / 10.0) / 3.0);
            } else if (fadeTracker.isTracked(slider, FadeTracker.FadeKind.PRESS)) {
                cyclePos = fadeTracker.getFade10(slider, FadeTracker.FadeKind.PRESS);
                if (fadeTracker.isFadeIn(slider, FadeTracker.FadeKind.PRESS)) {
                    cyclePos = 10.0f - cyclePos;
                }
                width = sliderIcon.size;
            } else {
                switch (state) {
                    case ROLLOVER_UNSELECTED: 
                    case ROLLOVER_SELECTED: 
                    case ACTIVE: 
                    case PRESSED_SELECTED: 
                    case PRESSED_UNSELECTED: {
                        width = sliderIcon.size;
                    }
                }
            }
            width = Math.min(width, sliderIcon.size - 2);
            int delta = (sliderIcon.size - width) / 2;
            String key = sliderIcon.size + ":" + width + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos;
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
            BufferedImage stateImage = painter.getContourBackground(width, sliderIcon.size - 1, BaseButtonShaper.getTriangleButtonOutline(width, sliderIcon.size - 1, 2.0f), false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage biResult = SubstanceCoreUtilities.getBlankImage(sliderIcon.size - 1, sliderIcon.size - 1);
            Graphics2D bg2d = (Graphics2D)biResult.getGraphics();
            bg2d.drawImage((Image)stateImage, delta, 0, null);
            if (sliderIcon.isMirrorred) {
                biResult = SubstanceImageCreator.getRotated(biResult, 2);
            }
            result = new ImageIcon(biResult);
            icons.put(key, result);
            return result;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    buttonModel.setEnabled(slider.isEnabled());
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(slider);
            Icon iconToDraw = SliderHorizontalIcon.getIcon(state, prevState, slider, this);
            iconToDraw.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.size - 1;
        }

        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class TrackableSlider
    implements Trackable {
        private JSlider slider;
        private Field thumbRectField;

        public TrackableSlider(JSlider slider) {
            this.slider = slider;
            SliderUI sliderUI = slider.getUI();
            if (sliderUI instanceof BasicSliderUI) {
                try {
                    this.thumbRectField = BasicSliderUI.class.getDeclaredField("thumbRect");
                    this.thumbRectField.setAccessible(true);
                }
                catch (Exception exc) {
                    this.thumbRectField = null;
                }
            }
        }

        public boolean isInside(MouseEvent me) {
            try {
                Rectangle thumbB = (Rectangle)this.thumbRectField.get(this.slider.getUI());
                if (thumbB == null) {
                    return false;
                }
                return thumbB.contains(me.getX(), me.getY());
            }
            catch (Exception exc) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource {
        private Map<ColorScheme, Map<ComponentState, Icon>> icons = new HashMap<ColorScheme, Map<ComponentState, Icon>>();
        private int size;

        public RadioButtonMenuItemIcon(int size) {
            this.size = size;
        }

        private synchronized Map<ComponentState, Icon> getCurrentThemeIcons() {
            ColorScheme currColorScheme = SubstanceCoreUtilities.getActiveScheme(null);
            Map<ComponentState, Icon> currSchemeIcons = this.icons.get(currColorScheme);
            if (currSchemeIcons == null) {
                currSchemeIcons = new HashMap<ComponentState, Icon>();
                for (ComponentState state : ComponentState.values()) {
                    currSchemeIcons.put(state, new ImageIcon(SubstanceImageCreator.getRadioButton(this.size, state, 2)));
                }
                this.icons.put(currColorScheme, currSchemeIcons);
            }
            return currSchemeIcons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            Icon iconToDraw = this.getCurrentThemeIcons().get((Object)ComponentState.getState(b.getModel(), b));
            g.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size + 2;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource {
        private Map<ColorScheme, Map<ComponentState, Icon>> icons = new HashMap<ColorScheme, Map<ComponentState, Icon>>();
        private int size;

        public CheckBoxMenuItemIcon(int size) {
            this.size = size;
        }

        private synchronized Map<ComponentState, Icon> getCurrentThemeIcons() {
            ColorScheme currColorScheme = SubstanceCoreUtilities.getActiveScheme(null);
            Map<ComponentState, Icon> currSchemeIcons = this.icons.get(currColorScheme);
            if (currSchemeIcons == null) {
                currSchemeIcons = new HashMap<ComponentState, Icon>();
                for (ComponentState state : ComponentState.values()) {
                    currSchemeIcons.put(state, new ImageIcon(SubstanceImageCreator.getCheckBox(this.size + 3, state)));
                }
                this.icons.put(currColorScheme, currSchemeIcons);
            }
            return currSchemeIcons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            Icon iconToDraw = this.getCurrentThemeIcons().get((Object)ComponentState.getState(b.getModel(), b));
            g.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size + 2;
        }

        @Override
        public int getIconHeight() {
            return this.size + 2;
        }
    }
}

