/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.StreamWriterBase;

public class UTF8StreamWriter
extends StreamWriterBase {
    private byte[] m_converts;

    public UTF8StreamWriter(String[] uris) {
        super("UTF-8", uris);
        this.defineNamespace(0, "");
        this.defineNamespace(1, "xml");
    }

    public UTF8StreamWriter(UTF8StreamWriter base, String[] uris) {
        super(base, uris);
        this.defineNamespace(0, "");
        this.defineNamespace(1, "xml");
    }

    protected void writeMarkup(String text) throws IOException {
        int length = text.length();
        this.makeSpace(length * 3);
        int fill = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.m_buffer[fill++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill++] = (byte)chr;
        }
        this.m_fillOffset = fill;
    }

    protected void writeMarkup(char chr) throws IOException {
        this.makeSpace(3);
        if (chr > '\u007f') {
            if (chr > '\u07ff') {
                this.m_buffer[this.m_fillOffset++] = (byte)(224 + (chr >> 12));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (chr >> 6 & 0x3F));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (chr & 0x3F));
            } else {
                this.m_buffer[this.m_fillOffset++] = (byte)(192 + (chr >> 6));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (chr & 0x3F));
            }
        } else {
            this.m_buffer[this.m_fillOffset++] = (byte)chr;
        }
    }

    protected void defineNamespace(int index, String prefix) {
        byte[] trim;
        int limit = prefix.length() * 3;
        if (this.m_converts == null) {
            this.m_converts = new byte[limit];
        } else if (limit > this.m_converts.length) {
            this.m_converts = new byte[limit];
        }
        int fill = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            char chr = prefix.charAt(i);
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.m_converts[fill++] = (byte)(224 + (chr >> 12));
                    this.m_converts[fill++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_converts[fill++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_converts[fill++] = (byte)(192 + (chr >> 6));
                this.m_converts[fill++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_converts[fill++] = (byte)chr;
        }
        if (fill > 0) {
            trim = new byte[fill + 1];
            System.arraycopy(this.m_converts, 0, trim, 0, fill);
            trim[fill] = 58;
        } else {
            trim = new byte[]{};
        }
        if (index < this.m_prefixBytes.length) {
            this.m_prefixBytes[index] = trim;
        } else if (this.m_extensionBytes != null) {
            index -= this.m_prefixBytes.length;
            for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                int length = this.m_extensionBytes[i].length;
                if (index < length) {
                    this.m_extensionBytes[i][index] = trim;
                    continue;
                }
                index -= length;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    protected void writeAttributeText(String text) throws IOException {
        int length = text.length();
        this.makeSpace(length * 6);
        int fill = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == '\"') {
                fill = this.writeEntity(QUOT_ENTITY, fill);
                continue;
            }
            if (chr == '&') {
                fill = this.writeEntity(AMP_ENTITY, fill);
                continue;
            }
            if (chr == '<') {
                fill = this.writeEntity(LT_ENTITY, fill);
                continue;
            }
            if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                this.m_buffer[fill++] = 93;
                this.m_buffer[fill++] = 93;
                fill = this.writeEntity(GT_ENTITY, fill);
                continue;
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
                }
                this.m_buffer[fill++] = (byte)chr;
                continue;
            }
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
                    }
                    this.m_buffer[fill++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill++] = (byte)chr;
        }
        this.m_fillOffset = fill;
    }

    public void writeTextContent(String text) throws IOException {
        this.flagTextContent();
        int length = text.length();
        this.makeSpace(length * 5);
        int fill = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == '&') {
                fill = this.writeEntity(AMP_ENTITY, fill);
                continue;
            }
            if (chr == '<') {
                fill = this.writeEntity(LT_ENTITY, fill);
                continue;
            }
            if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                fill = this.writeEntity(GT_ENTITY, fill);
                continue;
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                }
                this.m_buffer[fill++] = (byte)chr;
                continue;
            }
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                    }
                    this.m_buffer[fill++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill++] = (byte)chr;
        }
        this.m_fillOffset = fill;
    }

    public void writeCData(String text) throws IOException {
        this.flagTextContent();
        int length = text.length();
        this.makeSpace(length * 3 + 12);
        int fill = this.m_fillOffset;
        fill = this.writeEntity(LT_CDATASTART, fill);
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                }
                this.m_buffer[fill++] = (byte)chr;
                continue;
            }
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in CDATA section text");
                    }
                    this.m_buffer[fill++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill++] = (byte)chr;
        }
        this.m_fillOffset = this.writeEntity(LT_CDATAEND, fill);
    }

    public IXMLWriter createChildWriter(String[] uris) {
        return new UTF8StreamWriter(this, uris);
    }
}

