/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;

public class SummaryStatisticsImpl
extends SummaryStatistics
implements Serializable {
    static final long serialVersionUID = 8787174276883311692L;
    protected long n = 0L;
    protected SecondMoment secondMoment = null;
    protected Sum sum = new Sum();
    protected SumOfSquares sumsq = new SumOfSquares();
    protected Min min = new Min();
    protected Max max = new Max();
    protected SumOfLogs sumLog = new SumOfLogs();
    protected GeometricMean geoMean = new GeometricMean();
    protected Mean mean = null;
    protected Variance variance = null;

    public SummaryStatisticsImpl() {
        this.secondMoment = new SecondMoment();
    }

    public void addValue(double value) {
        this.sum.increment(value);
        this.sumsq.increment(value);
        this.min.increment(value);
        this.max.increment(value);
        this.sumLog.increment(value);
        this.geoMean.increment(value);
        this.secondMoment.increment(value);
        ++this.n;
    }

    public long getN() {
        return this.n;
    }

    public double getSum() {
        return this.sum.getResult();
    }

    public double getSumsq() {
        return this.sumsq.getResult();
    }

    public double getMean() {
        return new Mean(this.secondMoment).getResult();
    }

    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? Math.sqrt(this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    public double getVariance() {
        return new Variance(this.secondMoment).getResult();
    }

    public double getMax() {
        return this.max.getResult();
    }

    public double getMin() {
        return this.min.getResult();
    }

    public double getGeometricMean() {
        return this.geoMean.getResult();
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("SummaryStatistics:\n");
        outBuffer.append("n: " + this.getN() + "\n");
        outBuffer.append("min: " + this.getMin() + "\n");
        outBuffer.append("max: " + this.getMax() + "\n");
        outBuffer.append("mean: " + this.getMean() + "\n");
        outBuffer.append("geometric mean: " + this.getGeometricMean() + "\n");
        outBuffer.append("variance: " + this.getVariance() + "\n");
        outBuffer.append("sum of squares: " + this.getSumsq() + "\n");
        outBuffer.append("standard deviation: " + this.getStandardDeviation() + "\n");
        return outBuffer.toString();
    }

    public void clear() {
        this.n = 0L;
        this.min.clear();
        this.max.clear();
        this.sum.clear();
        this.sumLog.clear();
        this.sumsq.clear();
        this.geoMean.clear();
        this.secondMoment.clear();
    }
}

